/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsBlockCache;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsInserter;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsPacksChangedEvent;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsReaderOptions;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.dfs.ReadableChannel;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.storage.pack.PackExt;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AnyObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectDatabase;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectInserter;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectReader;

public abstract class DfsObjDatabase
extends ObjectDatabase {
    private static final PackList NO_PACKS = new PackList(new DfsPackFile[0]){

        @Override
        boolean dirty() {
            return true;
        }

        @Override
        void clearDirty() {
        }

        @Override
        public void markDirty() {
        }
    };
    private final AtomicReference<PackList> packList;
    private final DfsRepository repository;
    private DfsReaderOptions readerOptions;

    protected DfsObjDatabase(DfsRepository repository, DfsReaderOptions options) {
        this.repository = repository;
        this.packList = new AtomicReference<PackList>(NO_PACKS);
        this.readerOptions = options;
    }

    public DfsReaderOptions getReaderOptions() {
        return this.readerOptions;
    }

    @Override
    public ObjectReader newReader() {
        return new DfsReader(this);
    }

    @Override
    public ObjectInserter newInserter() {
        return new DfsInserter(this);
    }

    public DfsPackFile[] getPacks() throws IOException {
        return this.getPackList().packs;
    }

    public PackList getPackList() throws IOException {
        return this.scanPacks(NO_PACKS);
    }

    protected DfsRepository getRepository() {
        return this.repository;
    }

    public DfsPackFile[] getCurrentPacks() {
        return this.getCurrentPackList().packs;
    }

    public PackList getCurrentPackList() {
        return this.packList.get();
    }

    public boolean has(AnyObjectId objectId, boolean avoidUnreachableObjects) throws IOException {
        try (ObjectReader or = this.newReader();){
            or.setAvoidUnreachableObjects(avoidUnreachableObjects);
            boolean bl = or.has(objectId);
            return bl;
        }
    }

    protected abstract DfsPackDescription newPack(PackSource var1) throws IOException;

    protected void commitPack(Collection<DfsPackDescription> desc, Collection<DfsPackDescription> replaces) throws IOException {
        this.commitPackImpl(desc, replaces);
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
    }

    protected abstract void commitPackImpl(Collection<DfsPackDescription> var1, Collection<DfsPackDescription> var2) throws IOException;

    protected abstract void rollbackPack(Collection<DfsPackDescription> var1);

    protected abstract List<DfsPackDescription> listPacks() throws IOException;

    protected abstract ReadableChannel openFile(DfsPackDescription var1, PackExt var2) throws FileNotFoundException, IOException;

    protected abstract DfsOutputStream writeFile(DfsPackDescription var1, PackExt var2) throws IOException;

    void addPack(DfsPackFile newPack) throws IOException {
        DfsPackFile[] packs;
        PackListImpl n;
        PackList o;
        do {
            if ((o = this.packList.get()) == NO_PACKS) {
                o = this.scanPacks(o);
                for (DfsPackFile p : o.packs) {
                    if (p != newPack) continue;
                    return;
                }
            }
            packs = new DfsPackFile[1 + o.packs.length];
            packs[0] = newPack;
            System.arraycopy(o.packs, 0, packs, 1, o.packs.length);
        } while (!this.packList.compareAndSet(o, n = new PackListImpl(packs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackList scanPacks(PackList original) throws IOException {
        PackList n;
        AtomicReference<PackList> atomicReference = this.packList;
        synchronized (atomicReference) {
            PackList o;
            do {
                if ((o = this.packList.get()) != original) {
                    return o;
                }
                n = this.scanPacksImpl(o);
                if (n != o) continue;
                return n;
            } while (!this.packList.compareAndSet(o, n));
        }
        this.getRepository().fireEvent(new DfsPacksChangedEvent());
        return n;
    }

    private PackList scanPacksImpl(PackList old) throws IOException {
        DfsBlockCache cache = DfsBlockCache.getInstance();
        Map<DfsPackDescription, DfsPackFile> forReuse = DfsObjDatabase.reuseMap(old);
        List<DfsPackDescription> scanned = this.listPacks();
        Collections.sort(scanned);
        ArrayList<DfsPackFile> list = new ArrayList<DfsPackFile>(scanned.size());
        boolean foundNew = false;
        for (DfsPackDescription dsc : scanned) {
            DfsPackFile oldPack = forReuse.remove(dsc);
            if (oldPack != null) {
                list.add(oldPack);
                continue;
            }
            list.add(cache.getOrCreate(dsc, null));
            foundNew = true;
        }
        for (DfsPackFile p : forReuse.values()) {
            p.close();
        }
        if (list.isEmpty()) {
            return new PackListImpl(DfsObjDatabase.NO_PACKS.packs);
        }
        if (!foundNew) {
            old.clearDirty();
            return old;
        }
        return new PackListImpl(list.toArray(new DfsPackFile[list.size()]));
    }

    private static Map<DfsPackDescription, DfsPackFile> reuseMap(PackList old) {
        HashMap<DfsPackDescription, DfsPackFile> forReuse = new HashMap<DfsPackDescription, DfsPackFile>();
        for (DfsPackFile p : old.packs) {
            if (p.invalid()) {
                p.close();
                continue;
            }
            DfsPackFile prior = forReuse.put(p.getPackDescription(), p);
            if (prior == null) continue;
            forReuse.put(prior.getPackDescription(), prior);
            p.close();
        }
        return forReuse;
    }

    protected void clearCache() {
        this.packList.set(NO_PACKS);
    }

    @Override
    public void close() {
        this.packList.set(NO_PACKS);
    }

    public static abstract class PackList {
        public final DfsPackFile[] packs;
        private long lastModified = -1L;

        PackList(DfsPackFile[] packs) {
            this.packs = packs;
        }

        public long getLastModified() {
            if (this.lastModified < 0L) {
                long max = 0L;
                for (DfsPackFile pack : this.packs) {
                    max = Math.max(max, pack.getPackDescription().getLastModified());
                }
                this.lastModified = max;
            }
            return this.lastModified;
        }

        abstract boolean dirty();

        abstract void clearDirty();

        public abstract void markDirty();
    }

    private static final class PackListImpl
    extends PackList {
        private volatile boolean dirty;

        PackListImpl(DfsPackFile[] packs) {
            super(packs);
        }

        @Override
        boolean dirty() {
            return this.dirty;
        }

        @Override
        void clearDirty() {
            this.dirty = false;
        }

        @Override
        public void markDirty() {
            this.dirty = true;
        }
    }

    public static enum PackSource {
        INSERT(0),
        RECEIVE(0),
        COMPACT(1),
        GC(2),
        GC_REST(3),
        GC_TXN(4),
        UNREACHABLE_GARBAGE(5);

        final int category;

        private PackSource(int category) {
            this.category = category;
        }
    }
}

