/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.util.List;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchConstants;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.KetchLeader;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.LogIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.ketch.Round;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.CommitBuilder;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectInserter;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.TreeFormatter;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElectionRound
extends Round {
    private static final Logger log = LoggerFactory.getLogger(ElectionRound.class);
    private long term;

    ElectionRound(KetchLeader leader, LogIndex head) {
        super(leader, head);
    }

    @Override
    void start() throws IOException {
        ObjectId id;
        try (Repository git = this.leader.openRepository();
             ObjectInserter inserter = git.newObjectInserter();){
            id = this.bumpTerm(git, inserter);
            inserter.flush();
        }
        this.runAsync(id);
    }

    @Override
    void success() {
    }

    long getTerm() {
        return this.term;
    }

    private ObjectId bumpTerm(Repository git, ObjectInserter inserter) throws IOException {
        CommitBuilder b = new CommitBuilder();
        if (!ObjectId.zeroId().equals(this.acceptedOldIndex)) {
            try (RevWalk rw = new RevWalk(git);){
                RevCommit c = rw.parseCommit(this.acceptedOldIndex);
                b.setTreeId(c.getTree());
                b.setParentId(this.acceptedOldIndex);
                this.term = ElectionRound.parseTerm(c.getFooterLines(KetchConstants.TERM)) + 1L;
            }
        } else {
            this.term = 1L;
            b.setTreeId(inserter.insert(new TreeFormatter()));
        }
        StringBuilder msg = new StringBuilder();
        msg.append(KetchConstants.TERM.getName()).append(": ").append(this.term);
        String tag = this.leader.getSystem().newLeaderTag();
        if (tag != null && !tag.isEmpty()) {
            msg.append(' ').append(tag);
        }
        b.setAuthor(this.leader.getSystem().newCommitter());
        b.setCommitter(b.getAuthor());
        b.setMessage(msg.toString());
        if (log.isDebugEnabled()) {
            log.debug("Trying to elect myself " + b.getMessage());
        }
        return inserter.insert(b);
    }

    private static long parseTerm(List<String> footer) {
        if (footer.isEmpty()) {
            return 0L;
        }
        String s = footer.get(0);
        int p = s.indexOf(32);
        if (p > 0) {
            s = s.substring(0, p);
        }
        return Long.parseLong(s, 10);
    }
}

