/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.impldep.org.eclipse.jgit.api.CloneCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.Git;
import org.gradle.internal.impldep.org.eclipse.jgit.api.MergeCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.RebaseCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.TransportCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.GitAPIException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.JGitInternalException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoHeadException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.NoMessageException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.RefNotFoundException;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.gradle.internal.impldep.org.eclipse.jgit.dircache.DirCacheCheckout;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.ConfigInvalidException;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.RefUpdate;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.merge.MergeStrategy;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.submodule.SubmoduleWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> updated = new ArrayList<String>();
            while (generator.next()) {
                block37: {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    Repository submoduleRepo = generator.getRepository();
                    if (submoduleRepo == null) {
                        CloneCommand clone = Git.cloneRepository();
                        this.configure(clone);
                        clone.setURI(url);
                        clone.setDirectory(generator.getDirectory());
                        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), generator.getPath()));
                        if (this.monitor != null) {
                            clone.setProgressMonitor(this.monitor);
                        }
                        submoduleRepo = clone.call().getRepository();
                    }
                    try (RevWalk walk = new RevWalk(submoduleRepo);){
                        RevCommit commit = walk.parseCommit(generator.getObjectId());
                        String update = generator.getConfigUpdate();
                        if ("merge".equals(update)) {
                            MergeCommand merge = new MergeCommand(submoduleRepo);
                            merge.include(commit);
                            merge.setProgressMonitor(this.monitor);
                            merge.setStrategy(this.strategy);
                            merge.call();
                            break block37;
                        }
                        if ("rebase".equals(update)) {
                            RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                            rebase.setUpstream(commit);
                            rebase.setProgressMonitor(this.monitor);
                            rebase.setStrategy(this.strategy);
                            rebase.call();
                        } else {
                            DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                            co.setFailOnConflict(true);
                            co.checkout();
                            RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                            refUpdate.setNewObjectId(commit);
                            refUpdate.forceUpdate();
                        }
                    }
                    finally {
                        submoduleRepo.close();
                    }
                }
                updated.add(generator.getPath());
            }
            ArrayList<String> arrayList = updated;
            return arrayList;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }
}

