/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.impldep.org.bouncycastle.bcpg.S2K;
import org.gradle.internal.impldep.org.bouncycastle.util.io.Streams;

class SXprUtils {
    SXprUtils() {
    }

    private static int readLength(InputStream inputStream, int n) throws IOException {
        int n2 = n - 48;
        while ((n = inputStream.read()) >= 0 && n != 58) {
            n2 = n2 * 10 + n - 48;
        }
        return n2;
    }

    static String readString(InputStream inputStream, int n) throws IOException {
        int n2 = SXprUtils.readLength(inputStream, n);
        char[] cArray = new char[n2];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)inputStream.read();
        }
        return new String(cArray);
    }

    static byte[] readBytes(InputStream inputStream, int n) throws IOException {
        int n2 = SXprUtils.readLength(inputStream, n);
        byte[] byArray = new byte[n2];
        Streams.readFully(inputStream, byArray);
        return byArray;
    }

    static S2K parseS2K(InputStream inputStream) throws IOException {
        SXprUtils.skipOpenParenthesis(inputStream);
        String string = SXprUtils.readString(inputStream, inputStream.read());
        byte[] byArray = SXprUtils.readBytes(inputStream, inputStream.read());
        final long l = Long.parseLong(SXprUtils.readString(inputStream, inputStream.read()));
        SXprUtils.skipCloseParenthesis(inputStream);
        S2K s2K = new S2K(2, byArray, (int)l){

            public long getIterationCount() {
                return l;
            }
        };
        return s2K;
    }

    static void skipOpenParenthesis(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != 40) {
            throw new IOException("unknown character encountered");
        }
    }

    static void skipCloseParenthesis(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n != 41) {
            throw new IOException("unknown character encountered");
        }
    }
}

