/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.xbean.recipe;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.org.apache.xbean.recipe.CircularDependencyException;
import org.gradle.internal.impldep.org.apache.xbean.recipe.ConstructionException;
import org.gradle.internal.impldep.org.apache.xbean.recipe.DefaultExecutionContext;
import org.gradle.internal.impldep.org.apache.xbean.recipe.DefaultRepository;
import org.gradle.internal.impldep.org.apache.xbean.recipe.ExecutionContext;
import org.gradle.internal.impldep.org.apache.xbean.recipe.NoSuchObjectException;
import org.gradle.internal.impldep.org.apache.xbean.recipe.Recipe;
import org.gradle.internal.impldep.org.apache.xbean.recipe.Reference;
import org.gradle.internal.impldep.org.apache.xbean.recipe.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectGraph {
    private Repository repository;

    public ObjectGraph() {
        this(new DefaultRepository());
    }

    public ObjectGraph(Repository repository) {
        if (repository == null) {
            throw new NullPointerException("repository is null");
        }
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        if (repository == null) {
            throw new NullPointerException("repository is null");
        }
        this.repository = repository;
    }

    public Object create(String name) throws ConstructionException {
        Map<String, Object> objects = this.createAll(Collections.singletonList(name));
        Object instance = objects.get(name);
        if (instance == null) {
            instance = this.repository.get(name);
        }
        return instance;
    }

    public Map<String, Object> createAll(String ... names) throws ConstructionException {
        return this.createAll(Arrays.asList(names));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> createAll(List<String> names) throws ConstructionException {
        boolean createNewContext;
        boolean bl = createNewContext = !ExecutionContext.isContextSet();
        if (createNewContext) {
            ExecutionContext.setContext(new DefaultExecutionContext(this.repository));
        }
        WrapperExecutionContext wrapperContext = new WrapperExecutionContext(ExecutionContext.getContext());
        ExecutionContext.setContext(wrapperContext);
        try {
            LinkedHashMap<String, Recipe> recipes = this.getSortedRecipes(names);
            LinkedHashMap<String, Object> objects = new LinkedHashMap<String, Object>();
            ArrayList<String> existingObjectNames = new ArrayList<String>(names);
            existingObjectNames.removeAll(recipes.keySet());
            for (String string : existingObjectNames) {
                Object object = this.repository.get(string);
                if (object == null) {
                    throw new NoSuchObjectException(string);
                }
                objects.put(string, object);
            }
            for (Map.Entry entry : recipes.entrySet()) {
                String name = (String)entry.getKey();
                Recipe recipe = (Recipe)entry.getValue();
                if (wrapperContext.containsObject(name) && !(wrapperContext.getObject(name) instanceof Recipe)) continue;
                recipe.create((Type)((Object)Object.class), false);
            }
            objects.putAll(wrapperContext.getConstructedObject());
            LinkedHashMap<String, Object> linkedHashMap = objects;
            return linkedHashMap;
        }
        finally {
            if (createNewContext) {
                ExecutionContext.setContext(null);
            }
        }
    }

    private LinkedHashMap<String, Recipe> getSortedRecipes(List<String> names) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        for (String name : names) {
            Object object = this.repository.get(name);
            if (!(object instanceof Recipe)) continue;
            Recipe recipe = (Recipe)object;
            if (!recipe.getName().equals(name)) {
                throw new ConstructionException("Recipe '" + name + "' returned from the repository has name '" + name + "'");
            }
            this.createNode(name, recipe, nodes);
        }
        ArrayList<Node> sortedNodes = new ArrayList<Node>(nodes.size());
        LinkedList<Node> leafNodes = new LinkedList<Node>();
        for (Node n : nodes.values()) {
            if (n.refernceCount != 0) continue;
            if (n.references.size() == 0) {
                sortedNodes.add(n);
                continue;
            }
            leafNodes.add(n);
        }
        while (!leafNodes.isEmpty()) {
            Node node = (Node)leafNodes.removeFirst();
            sortedNodes.add(node);
            for (Node ref : node.references) {
                --ref.refernceCount;
                if (ref.refernceCount != 0) continue;
                leafNodes.add(ref);
            }
        }
        if (sortedNodes.size() != nodes.size()) {
            this.findCircuit((Node)nodes.values().iterator().next(), new ArrayList<Recipe>(nodes.size()));
            throw new ConstructionException("Internal Error: expected a CircularDependencyException");
        }
        LinkedHashMap<String, Recipe> sortedRecipes = new LinkedHashMap<String, Recipe>();
        for (Node node : sortedNodes) {
            sortedRecipes.put(node.name, node.recipe);
        }
        return sortedRecipes;
    }

    private void findCircuit(Node node, ArrayList<Recipe> stack) {
        if (stack.contains(node.recipe)) {
            ArrayList<Recipe> circularity = new ArrayList<Recipe>(stack.subList(stack.indexOf(node.recipe), stack.size()));
            Iterator<Recipe> iterator = circularity.iterator();
            while (iterator.hasNext()) {
                Recipe recipe = iterator.next();
                if (recipe == node.recipe || recipe.getName() != null) continue;
                iterator.remove();
            }
            circularity.add(node.recipe);
            throw new CircularDependencyException(circularity);
        }
        stack.add(node.recipe);
        for (Node reference : node.references) {
            this.findCircuit(reference, stack);
        }
    }

    private Node createNode(String name, Recipe recipe, Map<String, Node> nodes) {
        if (nodes.containsKey(name)) {
            Node node = nodes.get(name);
            if (node.recipe != recipe) {
                throw new ConstructionException("The name '" + name + "' is assigned to multiple recipies");
            }
            return node;
        }
        Node node = new Node();
        node.name = name;
        node.recipe = recipe;
        nodes.put(name, node);
        LinkedList<Recipe> nestedRecipes = new LinkedList<Recipe>(recipe.getNestedRecipes());
        LinkedList<Recipe> constructorRecipes = new LinkedList<Recipe>(recipe.getConstructorRecipes());
        while (!nestedRecipes.isEmpty()) {
            Recipe nestedRecipe = nestedRecipes.removeFirst();
            String nestedName = nestedRecipe.getName();
            if (nestedName != null) {
                Node nestedNode = this.createNode(nestedName, nestedRecipe, nodes);
                if (!constructorRecipes.contains(nestedRecipe)) continue;
                ++node.refernceCount;
                nestedNode.references.add(node);
                continue;
            }
            nestedRecipes.addAll(nestedRecipe.getNestedRecipes());
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapperExecutionContext
    extends ExecutionContext {
        private final ExecutionContext executionContext;
        private final Map<String, Object> constructedObject = new LinkedHashMap<String, Object>();

        private WrapperExecutionContext(ExecutionContext executionContext) {
            if (executionContext == null) {
                throw new NullPointerException("executionContext is null");
            }
            this.executionContext = executionContext;
        }

        public Map<String, Object> getConstructedObject() {
            return this.constructedObject;
        }

        @Override
        public void push(Recipe recipe) throws CircularDependencyException {
            this.executionContext.push(recipe);
        }

        @Override
        public Recipe pop() {
            return this.executionContext.pop();
        }

        @Override
        public LinkedList<Recipe> getStack() {
            return this.executionContext.getStack();
        }

        @Override
        public Object getObject(String name) {
            return this.executionContext.getObject(name);
        }

        @Override
        public boolean containsObject(String name) {
            return this.executionContext.containsObject(name);
        }

        @Override
        public void addObject(String name, Object object) {
            this.executionContext.addObject(name, object);
            this.constructedObject.put(name, object);
        }

        @Override
        public void addReference(Reference reference) {
            this.executionContext.addReference(reference);
        }

        @Override
        public Map<String, List<Reference>> getUnresolvedRefs() {
            return this.executionContext.getUnresolvedRefs();
        }

        @Override
        public ClassLoader getClassLoader() {
            return this.executionContext.getClassLoader();
        }
    }

    private class Node {
        String name;
        Recipe recipe;
        final List<Node> references = new ArrayList<Node>();
        int refernceCount;

        private Node() {
        }
    }
}

