/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.wagon;

import java.io.File;
import java.util.StringTokenizer;

public final class PathUtils {
    private PathUtils() {
    }

    public static String dirname(String path) {
        int i = path.lastIndexOf("/");
        return i >= 0 ? path.substring(0, i) : "";
    }

    public static String filename(String path) {
        int i = path.lastIndexOf("/");
        return i >= 0 ? path.substring(i + 1) : path;
    }

    public static String[] dirnames(String path) {
        String dirname = PathUtils.dirname(path);
        return PathUtils.split(dirname, "/", -1);
    }

    private static String[] split(String str, String separator, int max) {
        StringTokenizer tok = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            int lastTokenBegin;
            if (max > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list[i] = str.substring(lastTokenBegin);
                break;
            }
            list[i] = tok.nextToken();
            lastTokenBegin = str.indexOf(list[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i].length();
            ++i;
        }
        return list;
    }

    public static String host(String url) {
        String authorization = PathUtils.authorization(url);
        int index = authorization.indexOf(64);
        if (index >= 0) {
            return authorization.substring(index + 1);
        }
        return authorization;
    }

    static String authorization(String url) {
        int pos;
        if (url == null) {
            return "localhost";
        }
        String protocol = PathUtils.protocol(url);
        if (protocol == null || protocol.equalsIgnoreCase("file")) {
            return "localhost";
        }
        String host = url;
        if (protocol.equalsIgnoreCase("scm")) {
            host = host.substring(host.indexOf(":", 4) + 1).trim();
        }
        if ((host = host.substring(host.indexOf(":") + 1).trim()).startsWith("//")) {
            host = host.substring(2);
        }
        if ((pos = host.indexOf("/")) > 0) {
            host = host.substring(0, pos);
        }
        if ((pos = (pos = host.indexOf(64)) > 0 ? host.indexOf(58, pos) : host.indexOf(":")) > 0) {
            host = host.substring(0, pos);
        }
        return host;
    }

    public static String protocol(String url) {
        int pos = url.indexOf(":");
        if (pos == -1) {
            return "";
        }
        return url.substring(0, pos).trim();
    }

    public static int port(String url) {
        String protocol = PathUtils.protocol(url);
        if (protocol == null || protocol.equalsIgnoreCase("file")) {
            return -1;
        }
        String authorization = PathUtils.authorization(url);
        if (authorization == null) {
            return -1;
        }
        if (protocol.equalsIgnoreCase("scm")) {
            url = url.substring(url.indexOf(":", 4) + 1).trim();
        }
        if (url.regionMatches(true, 0, "file:", 0, 5) || url.regionMatches(true, 0, "local:", 0, 6)) {
            return -1;
        }
        if ((url = url.substring(url.indexOf(":") + 1).trim()).startsWith("//")) {
            url = url.substring(2);
        }
        int start = authorization.length();
        if (url.length() > start && url.charAt(start) == ':') {
            int end = url.indexOf(47, start);
            if (end == start + 1) {
                return -1;
            }
            if (end == -1) {
                end = url.length();
            }
            return Integer.parseInt(url.substring(start + 1, end));
        }
        return -1;
    }

    public static String basedir(String url) {
        String protocol = PathUtils.protocol(url);
        String retValue = null;
        if (protocol.equalsIgnoreCase("scm") && url.regionMatches(true, 0, "scm:svn:", 0, 8)) {
            url = url.substring(url.indexOf(":", 4) + 1);
            protocol = PathUtils.protocol(url);
        }
        if (protocol.equalsIgnoreCase("file")) {
            retValue = url.substring(protocol.length() + 1);
            if ((retValue = PathUtils.decode(retValue)).startsWith("//")) {
                if ((retValue = retValue.substring(2)).length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                    retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                } else {
                    int index = retValue.indexOf("/");
                    if (index >= 0) {
                        retValue = retValue.substring(index + 1);
                    }
                    if (retValue.length() >= 2 && (retValue.charAt(1) == '|' || retValue.charAt(1) == ':')) {
                        retValue = retValue.charAt(0) + ":" + retValue.substring(2);
                    } else if (index >= 0) {
                        retValue = "/" + retValue;
                    }
                }
            }
            if (retValue.length() >= 2 && retValue.charAt(1) == '|') {
                retValue = retValue.charAt(0) + ":" + retValue.substring(2);
            }
        } else {
            String authorization = PathUtils.authorization(url);
            int port = PathUtils.port(url);
            int pos = 0;
            if (protocol.equalsIgnoreCase("scm")) {
                pos = url.indexOf(":", 4) + 1;
                pos = url.indexOf(":", pos) + 1;
            } else {
                int index = url.indexOf("://");
                if (index != -1) {
                    pos = index + 3;
                }
            }
            pos += authorization.length();
            if (port != -1) {
                pos = pos + Integer.toString(port).length() + 1;
            }
            if (url.length() > pos) {
                retValue = url.substring(pos);
                if (retValue.startsWith(":")) {
                    retValue = retValue.substring(1);
                }
                retValue = retValue.replace(':', '/');
            }
        }
        if (retValue == null) {
            retValue = "/";
        }
        return retValue.trim();
    }

    private static String decode(String url) {
        String decoded = url;
        if (url != null) {
            int pos = -1;
            while ((pos = decoded.indexOf(37, pos + 1)) >= 0) {
                if (pos + 2 >= decoded.length()) continue;
                String hexStr = decoded.substring(pos + 1, pos + 3);
                char ch = (char)Integer.parseInt(hexStr, 16);
                decoded = decoded.substring(0, pos) + ch + decoded.substring(pos + 3);
            }
        }
        return decoded;
    }

    public static String user(String url) {
        String host = PathUtils.authorization(url);
        int index = host.indexOf(64);
        if (index > 0) {
            String userInfo = host.substring(0, index);
            if ((index = userInfo.indexOf(58)) > 0) {
                return userInfo.substring(0, index);
            }
            if (index < 0) {
                return userInfo;
            }
        }
        return null;
    }

    public static String password(String url) {
        String userInfo;
        String host = PathUtils.authorization(url);
        int index = host.indexOf(64);
        if (index > 0 && (index = (userInfo = host.substring(0, index)).indexOf(58)) >= 0) {
            return userInfo.substring(index + 1);
        }
        return null;
    }

    public static String toRelative(File basedir, String absolutePath) {
        String relative;
        String basedirPath;
        if ((absolutePath = absolutePath.replace('\\', '/')).startsWith(basedirPath = basedir.getAbsolutePath().replace('\\', '/'))) {
            relative = absolutePath.substring(basedirPath.length());
            if (relative.startsWith("/")) {
                relative = relative.substring(1);
            }
            if (relative.length() <= 0) {
                relative = ".";
            }
        } else {
            relative = absolutePath;
        }
        return relative;
    }
}

