/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.api.client.googleapis.media;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gradle.internal.impldep.com.google.api.client.googleapis.media.MediaHttpUploader;
import org.gradle.internal.impldep.com.google.api.client.http.HttpIOExceptionHandler;
import org.gradle.internal.impldep.com.google.api.client.http.HttpRequest;
import org.gradle.internal.impldep.com.google.api.client.http.HttpResponse;
import org.gradle.internal.impldep.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import org.gradle.internal.impldep.com.google.api.client.util.Beta;
import org.gradle.internal.impldep.com.google.api.client.util.Preconditions;

@Beta
class MediaUploadErrorHandler
implements HttpUnsuccessfulResponseHandler,
HttpIOExceptionHandler {
    static final Logger LOGGER = Logger.getLogger(MediaUploadErrorHandler.class.getName());
    private final MediaHttpUploader uploader;
    private final HttpIOExceptionHandler originalIOExceptionHandler;
    private final HttpUnsuccessfulResponseHandler originalUnsuccessfulHandler;

    public MediaUploadErrorHandler(MediaHttpUploader uploader, HttpRequest request) {
        this.uploader = Preconditions.checkNotNull(uploader);
        this.originalIOExceptionHandler = request.getIOExceptionHandler();
        this.originalUnsuccessfulHandler = request.getUnsuccessfulResponseHandler();
        request.setIOExceptionHandler(this);
        request.setUnsuccessfulResponseHandler(this);
    }

    public boolean handleIOException(HttpRequest request, boolean supportsRetry) throws IOException {
        boolean handled;
        boolean bl = handled = this.originalIOExceptionHandler != null && this.originalIOExceptionHandler.handleIOException(request, supportsRetry);
        if (handled) {
            try {
                this.uploader.serverErrorCallback();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "exception thrown while calling server callback", e);
            }
        }
        return handled;
    }

    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) throws IOException {
        boolean handled;
        boolean bl = handled = this.originalUnsuccessfulHandler != null && this.originalUnsuccessfulHandler.handleResponse(request, response, supportsRetry);
        if (handled && supportsRetry && response.getStatusCode() / 100 == 5) {
            try {
                this.uploader.serverErrorCallback();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "exception thrown while calling server callback", e);
            }
        }
        return handled;
    }
}

