/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.esotericsoftware.kryo.serializers;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.Kryo;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.Serializer;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Input;
import org.gradle.internal.impldep.com.esotericsoftware.kryo.io.Output;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSerializer
extends Serializer<Collection> {
    private boolean elementsCanBeNull = true;
    private Serializer serializer;
    private Class elementClass;
    private Class genericType;

    public CollectionSerializer() {
    }

    public CollectionSerializer(Class elementClass, Serializer serializer) {
        this.setElementClass(elementClass, serializer);
    }

    public CollectionSerializer(Class elementClass, Serializer serializer, boolean elementsCanBeNull) {
        this.setElementClass(elementClass, serializer);
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementsCanBeNull(boolean elementsCanBeNull) {
        this.elementsCanBeNull = elementsCanBeNull;
    }

    public void setElementClass(Class elementClass, Serializer serializer) {
        this.elementClass = elementClass;
        this.serializer = serializer;
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        if (kryo.isFinal(generics[0])) {
            this.genericType = generics[0];
        }
    }

    @Override
    public void write(Kryo kryo, Output output, Collection collection) {
        int length = collection.size();
        output.writeInt(length, true);
        Serializer serializer = this.serializer;
        if (this.genericType != null) {
            if (serializer == null) {
                serializer = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer != null) {
            if (this.elementsCanBeNull) {
                for (Object element : collection) {
                    kryo.writeObjectOrNull(output, element, serializer);
                }
            } else {
                for (Object element : collection) {
                    kryo.writeObject(output, element, serializer);
                }
            }
        } else {
            for (Object element : collection) {
                kryo.writeClassAndObject(output, element);
            }
        }
    }

    protected Collection create(Kryo kryo, Input input, Class<Collection> type) {
        return kryo.newInstance(type);
    }

    @Override
    public Collection read(Kryo kryo, Input input, Class<Collection> type) {
        Collection collection = this.create(kryo, input, type);
        kryo.reference(collection);
        int length = input.readInt(true);
        if (collection instanceof ArrayList) {
            ((ArrayList)collection).ensureCapacity(length);
        }
        Class elementClass = this.elementClass;
        Serializer serializer = this.serializer;
        if (this.genericType != null) {
            if (serializer == null) {
                elementClass = this.genericType;
                serializer = kryo.getSerializer(this.genericType);
            }
            this.genericType = null;
        }
        if (serializer != null) {
            if (this.elementsCanBeNull) {
                for (int i = 0; i < length; ++i) {
                    collection.add(kryo.readObjectOrNull(input, elementClass, serializer));
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    collection.add(kryo.readObject(input, elementClass, serializer));
                }
            }
        } else {
            for (int i = 0; i < length; ++i) {
                collection.add(kryo.readClassAndObject(input));
            }
        }
        return collection;
    }

    protected Collection createCopy(Kryo kryo, Collection original) {
        return (Collection)kryo.newInstance(original.getClass());
    }

    @Override
    public Collection copy(Kryo kryo, Collection original) {
        Collection copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        for (Object element : original) {
            copy.add(kryo.copy(element));
        }
        return copy;
    }
}

