/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;

public class TestDataGuessByTestDiscoveryUtil {
    public static final String COMMUNITY_PREFIX = "/community";
    private static final Logger LOG = Logger.getInstance(TestDataGuessByTestDiscoveryUtil.class);

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiMethod method) {
        List<TestDataFile> list;
        if (method == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(0);
        }
        if (!TestDataGuessByTestDiscoveryUtil.isEnabled()) {
            List<TestDataFile> list2 = Collections.emptyList();
            if (list2 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(1);
            }
            return list2;
        }
        PsiClass testClass = (PsiClass)ReadAction.compute(() -> method.getContainingClass());
        if (testClass == null) {
            List<TestDataFile> list3 = Collections.emptyList();
            if (list3 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(2);
            }
            return list3;
        }
        String testClassQualifiedName = (String)ReadAction.compute(() -> testClass.getQualifiedName());
        if (testClassQualifiedName == null) {
            List<TestDataFile> list4 = Collections.emptyList();
            if (list4 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(3);
            }
            return list4;
        }
        List<Couple> testQName = Collections.singletonList(Couple.of((Object)testClassQualifiedName, (Object)ReadAction.compute(() -> method.getName())));
        try {
            Project project = (Project)ReadAction.compute(() -> method.getProject());
            AffectedPathConsumer consumer = new AffectedPathConsumer(project);
            TestDiscoveryProducer.consumeAffectedPaths((Project)project, testQName, (Consumer)consumer, (byte)0);
            list = consumer.getTestData();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            List<TestDataFile> list5 = Collections.emptyList();
            if (list5 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(5);
            }
            return list5;
        }
        if (list == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiClass parametrizedTestClass) {
        List<TestDataFile> list;
        if (parametrizedTestClass == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(6);
        }
        if (!TestDataGuessByTestDiscoveryUtil.isEnabled()) {
            List<TestDataFile> list2 = Collections.emptyList();
            if (list2 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(7);
            }
            return list2;
        }
        String testClassQualifiedName = (String)ReadAction.compute(() -> parametrizedTestClass.getQualifiedName());
        if (testClassQualifiedName == null) {
            List<TestDataFile> list3 = Collections.emptyList();
            if (list3 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(8);
            }
            return list3;
        }
        Project project = (Project)ReadAction.compute(() -> parametrizedTestClass.getProject());
        try {
            AffectedPathConsumer consumer = new AffectedPathConsumer(project);
            TestDiscoveryProducer.consumeAffectedPaths((Project)project, (String)testClassQualifiedName, (Consumer)consumer, (byte)0);
            list = consumer.getTestData();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            List<TestDataFile> list4 = Collections.emptyList();
            if (list4 == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(10);
            }
            return list4;
        }
        if (list == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isEnabled() {
        return Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametrizedTestClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestDataByExistingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTestDataByExistingFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AffectedPathConsumer
    implements Consumer<String> {
        private final List<String> myTestData = new ArrayList<String>();
        private final String myBasePath;

        private AffectedPathConsumer(Project project) {
            this.myBasePath = project.getBasePath();
        }

        public void consume(String path) {
            String fullPath = this.myBasePath + path;
            if (FileUtil.exists((String)fullPath)) {
                this.myTestData.add(fullPath);
                return;
            }
            path = StringUtil.trimStart((String)path, (String)TestDataGuessByTestDiscoveryUtil.COMMUNITY_PREFIX);
            fullPath = this.myBasePath + path;
            if (FileUtil.exists((String)fullPath)) {
                this.myTestData.add(fullPath);
            }
        }

        @NotNull
        List<TestDataFile> getTestData() {
            List list = ContainerUtil.mapNotNull(this.myTestData, f -> new TestDataFile.LazyResolved((String)f));
            if (list == null) {
                AffectedPathConsumer.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil$AffectedPathConsumer", "getTestData"));
        }
    }
}

