/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

class ExperimentalFeatureIdContributor
extends PsiReferenceContributor {
    ExperimentalFeatureIdContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            ExperimentalFeatureIdContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PsiJavaPatterns.psiLiteral().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName(new String[]{"isFeatureEnabled", "setFeatureEnabled"})).inClass((ElementPattern)PsiJavaPatterns.psiClass().withQualifiedName(Experiments.class.getName()))), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new ExperimentalFeatureIdReference(element)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/ExperimentalFeatureIdContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/ExperimentalFeatureIdContributor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, 100.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/references/ExperimentalFeatureIdContributor", "registerReferenceProviders"));
    }

    private static class ExperimentalFeatureIdReference
    extends PsiReferenceBase<PsiElement> {
        private ExperimentalFeatureIdReference(PsiElement element) {
            super(element);
        }

        @Nullable
        public PsiElement resolve() {
            final String myId = this.getValue();
            CommonProcessors.FindProcessor<Extension> resolveProcessor = new CommonProcessors.FindProcessor<Extension>(){

                protected boolean accept(Extension extension) {
                    return myId.equals(extension.getId().getStringValue());
                }
            };
            this.processCandidates((Processor<Extension>)resolveProcessor);
            Extension value = (Extension)resolveProcessor.getFoundValue();
            if (value == null) {
                return null;
            }
            DomTarget target = DomTarget.getTarget((DomElement)value);
            return target != null ? PomService.convertToPsi((PsiTarget)target) : value.getXmlElement();
        }

        @NotNull
        public Object[] getVariants() {
            SmartList variants = new SmartList();
            this.processCandidates((Processor<Extension>)((Processor)arg_0 -> ExperimentalFeatureIdReference.lambda$getVariants$0((List)variants, arg_0)));
            Object[] objectArray = variants.toArray(LookupElement.EMPTY_ARRAY);
            if (objectArray == null) {
                ExperimentalFeatureIdReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        @Nullable
        private static String getDescription(Extension extension) {
            DomFixedChildDescription description2 = extension.getGenericInfo().getFixedChildDescription("description");
            if (description2 == null) {
                return null;
            }
            DomElement element = (DomElement)ContainerUtil.getFirstItem((List)description2.getValues((DomElement)extension));
            if (element instanceof ExtensionDomExtender.SimpleTagValue) {
                return ((ExtensionDomExtender.SimpleTagValue)element).getTagValue();
            }
            return null;
        }

        @Nullable
        private static String getAttributeValue(Extension extension, String attributeName) {
            DomAttributeChildDescription attributeDescription = extension.getGenericInfo().getAttributeChildDescription(attributeName);
            if (attributeDescription == null) {
                return null;
            }
            return attributeDescription.getDomAttributeValue((DomElement)extension).getStringValue();
        }

        private void processCandidates(Processor<Extension> processor) {
            Project project = this.myElement.getProject();
            PsiClass experimentalFeatureClass = JavaPsiFacade.getInstance((Project)project).findClass(ExperimentalFeature.class.getName(), this.myElement.getResolveScope());
            if (experimentalFeatureClass == null) {
                return;
            }
            ExtensionPointLocator extensionPointLocator = new ExtensionPointLocator(experimentalFeatureClass);
            ExtensionPointCandidate extensionPointCandidate = (ExtensionPointCandidate)ContainerUtil.getFirstItem(extensionPointLocator.findDirectCandidates());
            if (extensionPointCandidate == null) {
                return;
            }
            DomManager manager = DomManager.getDomManager((Project)project);
            DomElement extensionPointDomElement = manager.getDomElement((XmlTag)extensionPointCandidate.pointer.getElement());
            if (!(extensionPointDomElement instanceof ExtensionPoint)) {
                return;
            }
            for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByExtensionPoint((ExtensionPoint)extensionPointDomElement)) {
                XmlTag element = (XmlTag)candidate.pointer.getElement();
                DomElement domElement = manager.getDomElement(element);
                if (!(domElement instanceof Extension) || processor.process((Object)((Extension)domElement))) continue;
                return;
            }
        }

        private static /* synthetic */ boolean lambda$getVariants$0(List variants, Extension extension) {
            GenericAttributeValue<String> id = extension.getId();
            if (id == null || extension.getXmlElement() == null) {
                return true;
            }
            String value = id.getStringValue();
            if (value == null) {
                return true;
            }
            boolean requireRestart = "true".equals(ExperimentalFeatureIdReference.getAttributeValue(extension, "requireRestart"));
            boolean isInternalFeature = "true".equals(ExperimentalFeatureIdReference.getAttributeValue(extension, "internalFeature"));
            String description2 = " " + StringUtil.notNullize((String)ExperimentalFeatureIdReference.getDescription(extension), (String)"No Description");
            String percentage = ExperimentalFeatureIdReference.getAttributeValue(extension, "percentOfUsers");
            variants.add(LookupElementBuilder.create((Object)extension.getXmlElement(), (String)value).withIcon(requireRestart ? AllIcons.Nodes.PluginRestart : AllIcons.Nodes.Plugin).withBoldness(isInternalFeature).withTailText(description2, true).withTypeText(percentage != null ? percentage + "%" : ""));
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/references/ExperimentalFeatureIdContributor$ExperimentalFeatureIdReference", "getVariants"));
        }
    }
}

