/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColorUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.UIUtil;
import icons.DevkitIcons;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.util.PointableCandidate;

class LineMarkerInfoHelper {
    private static final NotNullFunction<PointableCandidate, Collection<? extends PsiElement>> CONVERTER = candidate -> Collections.singleton(candidate.pointer.getElement());
    private static final NotNullFunction<PointableCandidate, Collection<? extends GotoRelatedItem>> RELATED_ITEM_PROVIDER = candidate -> GotoRelatedItem.createItems(Collections.singleton(candidate.pointer.getElement()), (String)"DevKit");
    private static final NullableFunction<PointableCandidate, String> EXTENSION_NAMER = LineMarkerInfoHelper.createNamer("line.marker.tooltip.extension.declaration", (NotNullFunction<? super XmlTag, String>)((NotNullFunction)XmlTag::getName));
    private static final NullableFunction<PointableCandidate, String> EXTENSION_POINT_NAMER = LineMarkerInfoHelper.createNamer("line.marker.tooltip.extension.point.declaration", (NotNullFunction<? super XmlTag, String>)((NotNullFunction)tag -> {
        String name = tag.getAttributeValue("name");
        if (StringUtil.isEmpty((String)name)) {
            name = "Extension Point";
        }
        return name;
    }));
    private static final String MODULE_SUFFIX_PATTERN = " <font color='" + ColorUtil.toHex((Color)UIUtil.getInactiveTextColor()) + "'>[{0}]</font>";

    private LineMarkerInfoHelper() {
    }

    @NotNull
    static RelatedItemLineMarkerInfo<PsiElement> createExtensionLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(0);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(1);
        }
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo = LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, "Choose Extension", EXTENSION_NAMER);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(2);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    static RelatedItemLineMarkerInfo<PsiElement> createExtensionPointLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(3);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(4);
        }
        RelatedItemLineMarkerInfo<PsiElement> relatedItemLineMarkerInfo = LineMarkerInfoHelper.createPluginLineMarkerInfo(targets, element, "Choose Extension Point", EXTENSION_POINT_NAMER);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(5);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    private static RelatedItemLineMarkerInfo<PsiElement> createPluginLineMarkerInfo(@NotNull List<? extends PointableCandidate> targets, @NotNull PsiElement element, String popup, NullableFunction<PointableCandidate, String> namer) {
        if (targets == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(6);
        }
        if (element == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(7);
        }
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = NavigationGutterIconBuilder.create((Icon)DevkitIcons.Gutter.Plugin, CONVERTER, RELATED_ITEM_PROVIDER).setTargets(targets).setPopupTitle(popup).setNamer(namer).setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(element);
        if (relatedItemLineMarkerInfo == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(8);
        }
        return relatedItemLineMarkerInfo;
    }

    @NotNull
    private static NullableFunction<PointableCandidate, String> createNamer(String tooltipPatternPropertyName, NotNullFunction<? super XmlTag, String> nameProvider) {
        NullableFunction nullableFunction = target -> {
            XmlTag tag = (XmlTag)target.pointer.getElement();
            if (tag == null) {
                throw new NullPointerException("Null element for pointable candidate: " + target);
            }
            PsiFile file = tag.getContainingFile();
            String path = file.getVirtualFile().getPath();
            String fileDisplayName = file.getName();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
            if (module != null) {
                fileDisplayName = fileDisplayName + MessageFormat.format(MODULE_SUFFIX_PATTERN, module.getName());
            }
            return DevKitBundle.message(tooltipPatternPropertyName, path, String.valueOf(tag.getTextRange().getStartOffset()), nameProvider.fun((Object)tag), fileDisplayName);
        };
        if (nullableFunction == null) {
            LineMarkerInfoHelper.$$$reportNull$$$0(9);
        }
        return nullableFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/navigation/LineMarkerInfoHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtensionLineMarkerInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtensionPointLineMarkerInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginLineMarkerInfo";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionLineMarkerInfo";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionPointLineMarkerInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPluginLineMarkerInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

