/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import icons.DevkitIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedClassLineMarkerProviderBase;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DescriptionTypeRelatedItemLineMarkerProvider
extends DevkitRelatedClassLineMarkerProviderBase {
    private static final NotNullFunction<PsiFile, Collection<? extends PsiElement>> CONVERTER = psiFile -> ContainerUtil.createMaybeSingletonList((Object)psiFile);
    private static final NotNullFunction<PsiFile, Collection<? extends GotoRelatedItem>> RELATED_ITEM_PROVIDER = psiFile -> GotoRelatedItem.createItems(Collections.singleton(psiFile), (String)"DevKit");
    private final GutterIconDescriptor.Option myDescriptionOption = new GutterIconDescriptor.Option("devkit.description", "Description", DevkitIcons.Gutter.DescriptionFile);
    private final GutterIconDescriptor.Option myBeforeAfterOption = new GutterIconDescriptor.Option("devkit.beforeAfter", "Before/After templates", DevkitIcons.Gutter.Diff);

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        GutterIconDescriptor.Option[] optionArray = new GutterIconDescriptor.Option[]{this.myDescriptionOption, this.myBeforeAfterOption};
        if (optionArray == null) {
            DescriptionTypeRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        return optionArray;
    }

    public String getName() {
        return "Description / Before|After Templates";
    }

    @Override
    protected void process(@NotNull PsiElement highlightingElement, @NotNull PsiClass psiClass, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        if (highlightingElement == null) {
            DescriptionTypeRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (psiClass == null) {
            DescriptionTypeRelatedItemLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            DescriptionTypeRelatedItemLineMarkerProvider.$$$reportNull$$$0(3);
        }
        boolean descriptionEnabled = this.myDescriptionOption.isEnabled();
        boolean beforeAfterEnabled = this.myBeforeAfterOption.isEnabled();
        if (!descriptionEnabled && !beforeAfterEnabled) {
            return;
        }
        if (!PsiUtil.isInstantiable(psiClass)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        for (DescriptionType type : DescriptionType.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)type.getClassName())) continue;
            String descriptionDirName = DescriptionCheckerUtil.getDescriptionDirName(psiClass);
            if (StringUtil.isEmptyOrSpaces((String)descriptionDirName)) {
                return;
            }
            if (type == DescriptionType.INSPECTION) {
                if (!descriptionEnabled) {
                    return;
                }
                InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
                if (info.hasDescriptionFile()) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addDescriptionFileGutterIcon(highlightingElement, info.getDescriptionFile(), result);
                }
                return;
            }
            for (PsiDirectory descriptionDir : DescriptionCheckerUtil.getDescriptionsDirs(module, type)) {
                PsiFile descriptionFile;
                PsiDirectory dir = descriptionDir.findSubdirectory(descriptionDirName);
                if (dir == null || (descriptionFile = dir.findFile("description.html")) == null) continue;
                if (descriptionEnabled) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addDescriptionFileGutterIcon(highlightingElement, descriptionFile, result);
                }
                if (beforeAfterEnabled) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addBeforeAfterTemplateFilesGutterIcon(highlightingElement, dir, result);
                }
                return;
            }
            return;
        }
    }

    private static void addDescriptionFileGutterIcon(PsiElement highlightingElement, PsiFile descriptionFile, Collection<? super RelatedItemLineMarkerInfo> result) {
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)DevkitIcons.Gutter.DescriptionFile, CONVERTER, RELATED_ITEM_PROVIDER).setTarget((Object)descriptionFile).setTooltipText("Description").setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(highlightingElement);
        result.add((RelatedItemLineMarkerInfo)info);
    }

    private static void addBeforeAfterTemplateFilesGutterIcon(PsiElement highlightingElement, PsiDirectory descriptionDirectory, Collection<? super RelatedItemLineMarkerInfo> result) {
        SortedList templateFiles = new SortedList(Comparator.comparing(PsiFileSystemItem::getName));
        for (PsiFile file : descriptionDirectory.getFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".template") || !fileName.startsWith("after.") && !fileName.startsWith("before.")) continue;
            templateFiles.add(file);
        }
        if (templateFiles.isEmpty()) {
            return;
        }
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)DevkitIcons.Gutter.Diff, CONVERTER, RELATED_ITEM_PROVIDER).setTargets((Collection)templateFiles).setPopupTitle("Select Template").setTooltipText("Before/After Templates").setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(highlightingElement);
        result.add((RelatedItemLineMarkerInfo)info);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/navigation/DescriptionTypeRelatedItemLineMarkerProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/navigation/DescriptionTypeRelatedItemLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

