/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageVisitorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolvingHint;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.missingApi.MissingRecentApiVisitor;
import org.jetbrains.idea.devkit.inspections.missingApi.SinceUntilRange;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 52\u00020\u0001:\u00015B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u001bH\u0016J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0016J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J.\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000fH\u0016J\u000e\u0010.\u001a\u0004\u0018\u00010)*\u00020/H\u0002J\u0014\u00100\u001a\u0004\u0018\u00010)*\b\u0012\u0004\u0012\u00020\u00130\u0007H\u0002J\u000e\u00101\u001a\u0004\u0018\u000102*\u00020\u000fH\u0002J\f\u00103\u001a\u00020,*\u00020\u000fH\u0002J\u0014\u00104\u001a\u00020,*\u00020\b2\u0006\u0010(\u001a\u00020)H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiVisitor;", "Lcom/intellij/codeInspection/apiUsage/ApiUsageVisitorBase;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "targetedSinceUntilRanges", "", "Lorg/jetbrains/idea/devkit/inspections/missingApi/SinceUntilRange;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/ProblemHighlightType;Ljava/util/List;)V", "checkClassDefaultConstructorApi", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "elementToHighlight", "Lcom/intellij/psi/PsiElement;", "checkMissingApi", "refElement", "findEmptyConstructorAnnotations", "Lcom/intellij/psi/PsiAnnotation;", "getElementToHighlight", "reference", "Lcom/intellij/psi/PsiReference;", "processConstructorInvocation", "instantiatedClass", "Lcom/intellij/psi/PsiJavaCodeReferenceElement;", "constructor", "Lcom/intellij/psi/PsiMethod;", "processDefaultConstructorInvocation", "processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassConstructor", "superClass", "subclassConstructor", "processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassDeclaration", "subclass", "processMethodOverriding", "method", "overriddenMethod", "processReference", "registerDefaultConstructorProblem", "constructorOwner", "apiSinceBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "brokenRanges", "shouldProcessReferences", "", "element", "getApiSinceBuildNumber", "Lcom/intellij/psi/PsiModifierListOwner;", "getAvailableSinceBuildNumber", "getPresentableName", "", "isInsideImportStatement", "someBuildsAreNotCovered", "Companion", "intellij.devkit"})
public final class MissingRecentApiVisitor
extends ApiUsageVisitorBase {
    private final ProblemsHolder holder;
    private final ProblemHighlightType highlightType;
    private final List<SinceUntilRange> targetedSinceUntilRanges;
    @NotNull
    private static final String AVAILABLE_SINCE_ANNOTATION;
    public static final Companion Companion;

    public boolean shouldProcessReferences(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return !this.isInsideImportStatement(element);
    }

    private final boolean isInsideImportStatement(@NotNull PsiElement $receiver) {
        PsiElement $receiver$iv = $receiver;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        return UastContextKt.getUastParentOfType((PsiElement)$receiver$iv, UImportStatement.class, (boolean)strict$iv) != null;
    }

    public void processReference(@NotNull PsiReference reference) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        if (reference instanceof ResolvingHint && !((ResolvingHint)reference).canResolveTo(PsiModifierListOwner.class)) {
            return;
        }
        PsiElement resolved = reference.resolve();
        if (resolved != null) {
            PsiElement elementToHighlight = this.getElementToHighlight(reference);
            this.checkMissingApi(resolved, elementToHighlight);
        }
    }

    private final PsiElement getElementToHighlight(PsiReference reference) {
        PsiElement referenceNameElement;
        if (reference instanceof PsiJavaCodeReferenceElement && (referenceNameElement = ((PsiJavaCodeReferenceElement)reference).getReferenceNameElement()) != null) {
            return referenceNameElement;
        }
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"reference.element");
        return psiElement;
    }

    public void processConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass, @NotNull PsiMethod constructor) {
        Intrinsics.checkParameterIsNotNull((Object)instantiatedClass, (String)"instantiatedClass");
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        this.checkMissingApi((PsiElement)constructor, (PsiElement)instantiatedClass);
    }

    public void processDefaultConstructorInvocation(@NotNull PsiJavaCodeReferenceElement instantiatedClass) {
        Intrinsics.checkParameterIsNotNull((Object)instantiatedClass, (String)"instantiatedClass");
        PsiElement psiElement = instantiatedClass.resolve();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return;
        }
        PsiClass createdClass = psiClass;
        this.checkClassDefaultConstructorApi(createdClass, (PsiElement)instantiatedClass);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkClassDefaultConstructorApi(PsiClass psiClass, PsiElement elementToHighlight) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        BuildNumber buildNumber = this.findEmptyConstructorAnnotations(psiClass);
        if (buildNumber == null || (buildNumber = this.getAvailableSinceBuildNumber((List<? extends PsiAnnotation>)buildNumber)) == null) {
            return;
        }
        BuildNumber availableSince = buildNumber;
        Iterable iterable = $receiver$iv = (Iterable)this.targetedSinceUntilRanges;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SinceUntilRange it = (SinceUntilRange)element$iv$iv;
            boolean bl = false;
            if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List brokenRanges = (List)destination$iv$iv;
        Collection collection = brokenRanges;
        if (!collection.isEmpty()) {
            this.registerDefaultConstructorProblem(psiClass, elementToHighlight, availableSince, brokenRanges);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassDeclaration(@NotNull PsiClass subclass, @NotNull PsiClass superClass) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)subclass, (String)"subclass");
        Intrinsics.checkParameterIsNotNull((Object)superClass, (String)"superClass");
        BuildNumber buildNumber = this.findEmptyConstructorAnnotations(superClass);
        if (buildNumber == null || (buildNumber = this.getAvailableSinceBuildNumber((List<? extends PsiAnnotation>)buildNumber)) == null) {
            return;
        }
        BuildNumber availableSince = buildNumber;
        Iterable iterable = $receiver$iv = (Iterable)this.targetedSinceUntilRanges;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SinceUntilRange it = (SinceUntilRange)element$iv$iv;
            boolean bl = false;
            if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List brokenRanges = (List)destination$iv$iv;
        $receiver$iv = brokenRanges;
        if (!$receiver$iv.isEmpty()) {
            PsiElement elementToHighlight;
            PsiExpressionList argumentList;
            PsiAnonymousClass asAnonymous;
            PsiClass psiClass = subclass;
            if (!(psiClass instanceof PsiAnonymousClass)) {
                psiClass = null;
            }
            if ((asAnonymous = (PsiAnonymousClass)psiClass) != null && (argumentList = asAnonymous.getArgumentList()) != null && !argumentList.isEmpty()) {
                return;
            }
            PsiAnonymousClass psiAnonymousClass = asAnonymous;
            PsiElement psiElement = psiAnonymousClass != null && (psiAnonymousClass = psiAnonymousClass.getBaseClassReference()) != null ? (PsiElement)psiAnonymousClass : (elementToHighlight = (PsiElement)subclass.getNameIdentifier());
            if (elementToHighlight != null) {
                this.registerDefaultConstructorProblem(superClass, elementToHighlight, availableSince, brokenRanges);
            }
        }
    }

    public void processEmptyConstructorOfSuperClassImplicitInvocationAtSubclassConstructor(@NotNull PsiClass superClass, @NotNull PsiMethod subclassConstructor) {
        Intrinsics.checkParameterIsNotNull((Object)superClass, (String)"superClass");
        Intrinsics.checkParameterIsNotNull((Object)subclassConstructor, (String)"subclassConstructor");
        PsiIdentifier psiIdentifier = subclassConstructor.getNameIdentifier();
        if (psiIdentifier == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiIdentifier, (String)"subclassConstructor.nameIdentifier ?: return");
        PsiIdentifier nameIdentifier = psiIdentifier;
        this.checkClassDefaultConstructorApi(superClass, (PsiElement)nameIdentifier);
    }

    /*
     * WARNING - void declaration
     */
    public void processMethodOverriding(@NotNull PsiMethod method, @NotNull PsiMethod overriddenMethod) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)overriddenMethod, (String)"overriddenMethod");
        BuildNumber buildNumber = this.getApiSinceBuildNumber((PsiModifierListOwner)overriddenMethod);
        if (buildNumber == null) {
            return;
        }
        BuildNumber availableSince = buildNumber;
        Iterable iterable = $receiver$iv = (Iterable)this.targetedSinceUntilRanges;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SinceUntilRange it = (SinceUntilRange)element$iv$iv;
            boolean bl = false;
            if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List brokenRanges = (List)destination$iv$iv;
        $receiver$iv = brokenRanges;
        if (!$receiver$iv.isEmpty()) {
            PsiClass psiClass = overriddenMethod.getContainingClass();
            if (psiClass == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"overriddenMethod.containingClass ?: return");
            PsiClass aClass = psiClass;
            PsiIdentifier psiIdentifier = method.getNameIdentifier();
            if (psiIdentifier == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiIdentifier, (String)"method.nameIdentifier ?: return");
            PsiIdentifier nameIdentifier = psiIdentifier;
            String description2 = DevKitBundle.message("inspections.api.overrides.method.available.only.since", this.getPresentableName((PsiElement)aClass), availableSince.asString(), CollectionsKt.joinToString$default((Iterable)brokenRanges, null, null, null, (int)0, null, (Function1)processMethodOverriding.description.1.INSTANCE, (int)31, null));
            this.holder.registerProblem((PsiElement)nameIdentifier, description2, this.highlightType, new LocalQuickFix[0]);
        }
    }

    private final void registerDefaultConstructorProblem(PsiClass constructorOwner, PsiElement elementToHighlight, BuildNumber apiSinceBuildNumber, List<SinceUntilRange> brokenRanges) {
        String description2 = DevKitBundle.message("inspections.api.constructor.only.since", constructorOwner.getQualifiedName(), apiSinceBuildNumber.asString(), CollectionsKt.joinToString$default((Iterable)brokenRanges, null, null, null, (int)0, null, (Function1)registerDefaultConstructorProblem.description.1.INSTANCE, (int)31, null));
        this.holder.registerProblem(elementToHighlight, description2, this.highlightType, new LocalQuickFix[0]);
    }

    private final List<PsiAnnotation> findEmptyConstructorAnnotations(PsiClass psiClass) {
        PsiMethod emptyConstructor;
        block3: {
            PsiMethod psiMethod;
            PsiMethod[] psiMethodArray;
            PsiMethod[] psiMethodArray2;
            PsiMethod[] constructors;
            PsiMethod[] psiMethodArray3 = psiClass.getConstructors();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray3, (String)"psiClass.constructors");
            PsiMethod[] psiMethodArray4 = constructors = psiMethodArray3;
            if (psiMethodArray4.length == 0) {
                return ExternalAnnotationsManager.getInstance((Project)psiClass.getProject()).findDefaultConstructorExternalAnnotations(psiClass, AVAILABLE_SINCE_ANNOTATION);
            }
            PsiMethod[] psiMethodArray5 = psiMethodArray2 = (psiMethodArray = constructors);
            int n = psiMethodArray5.length;
            for (int i = 0; i < n; ++i) {
                PsiMethod psiMethod2;
                PsiMethod it = psiMethod2 = psiMethodArray5[i];
                boolean bl = false;
                PsiMethod psiMethod3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod3, (String)"it");
                PsiParameterList psiParameterList = psiMethod3.getParameterList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"it.parameterList");
                if (!psiParameterList.isEmpty()) continue;
                psiMethod = psiMethod2;
                break block3;
            }
            psiMethod = emptyConstructor = null;
        }
        if (emptyConstructor != null) {
            return AnnotationUtil.findAllAnnotations((PsiModifierListOwner)((PsiModifierListOwner)emptyConstructor), (Collection)CollectionsKt.listOf((Object)AVAILABLE_SINCE_ANNOTATION), (boolean)false);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkMissingApi(PsiElement refElement, PsiElement elementToHighlight) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (!(refElement instanceof PsiModifierListOwner)) {
            return;
        }
        BuildNumber buildNumber = this.getApiSinceBuildNumber((PsiModifierListOwner)refElement);
        if (buildNumber == null) {
            return;
        }
        BuildNumber availableSince = buildNumber;
        Iterable iterable = $receiver$iv = (Iterable)this.targetedSinceUntilRanges;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SinceUntilRange it = (SinceUntilRange)element$iv$iv;
            boolean bl = false;
            if (!this.someBuildsAreNotCovered(it, availableSince)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List brokenRanges = (List)destination$iv$iv;
        $receiver$iv = brokenRanges;
        if (!$receiver$iv.isEmpty()) {
            String description2 = DevKitBundle.message("inspections.api.available.only.since", this.getPresentableName(refElement), availableSince.asString(), CollectionsKt.joinToString$default((Iterable)brokenRanges, null, null, null, (int)0, null, (Function1)checkMissingApi.description.1.INSTANCE, (int)31, null));
            this.holder.registerProblem(elementToHighlight, description2, this.highlightType, new LocalQuickFix[0]);
        }
    }

    private final BuildNumber getApiSinceBuildNumber(@NotNull PsiModifierListOwner $receiver) {
        List list = AnnotationUtil.findAllAnnotations((PsiModifierListOwner)$receiver, (Collection)CollectionsKt.listOf((Object)AVAILABLE_SINCE_ANNOTATION), (boolean)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"AnnotationUtil.findAllAn\u2026SINCE_ANNOTATION), false)");
        List externalAnnotations = list;
        if (externalAnnotations.isEmpty()) {
            return null;
        }
        return this.getAvailableSinceBuildNumber(externalAnnotations);
    }

    private final BuildNumber getAvailableSinceBuildNumber(@NotNull List<? extends PsiAnnotation> $receiver) {
        return (BuildNumber)SequencesKt.min((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$receiver), (Function1)getAvailableSinceBuildNumber.1.INSTANCE));
    }

    private final boolean someBuildsAreNotCovered(@NotNull SinceUntilRange $receiver, BuildNumber apiSinceBuildNumber) {
        return $receiver.getSinceBuild() == null || $receiver.getSinceBuild().compareTo(apiSinceBuildNumber) < 0;
    }

    private final String getPresentableName(@NotNull PsiElement $receiver) {
        return $receiver instanceof PsiMethod && PsiUtil.isAnnotationMethod((PsiElement)$receiver) ? ((PsiMethod)$receiver).getName() : HighlightMessageUtil.getSymbolName((PsiElement)$receiver);
    }

    public MissingRecentApiVisitor(@NotNull ProblemsHolder holder, @NotNull ProblemHighlightType highlightType, @NotNull List<SinceUntilRange> targetedSinceUntilRanges) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)highlightType, (String)"highlightType");
        Intrinsics.checkParameterIsNotNull(targetedSinceUntilRanges, (String)"targetedSinceUntilRanges");
        this.holder = holder;
        this.highlightType = highlightType;
        this.targetedSinceUntilRanges = targetedSinceUntilRanges;
    }

    static {
        Companion = new Companion(null);
        String string = Reflection.getOrCreateKotlinClass(ApiStatus.AvailableSince.class).getQualifiedName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        AVAILABLE_SINCE_ANNOTATION = string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/MissingRecentApiVisitor$Companion;", "", "()V", "AVAILABLE_SINCE_ANNOTATION", "", "getAVAILABLE_SINCE_ANNOTATION", "()Ljava/lang/String;", "intellij.devkit"})
    public static final class Companion {
        @NotNull
        public final String getAVAILABLE_SINCE_ANNOTATION() {
            return AVAILABLE_SINCE_ANNOTATION;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

