/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.command.CommandToken;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ShuffleNamesAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShuffleNamesAction.$$$reportNull$$$0(0);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        e.getPresentation().setEnabled(editor != null && file != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShuffleNamesAction.$$$reportNull$$$0(1);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (editor == null || file == null) {
            return;
        }
        Project project = file.getProject();
        CommandProcessorEx commandProcessor = (CommandProcessorEx)CommandProcessorEx.getInstance();
        CommandToken commandToken = commandProcessor.startCommand(project, e.getPresentation().getText(), (Object)e.getPresentation().getText(), UndoConfirmationPolicy.DEFAULT);
        try {
            WriteAction.run(() -> ShuffleNamesAction.shuffleIds(file, editor));
        }
        finally {
            commandProcessor.finishCommand(commandToken, null);
        }
    }

    private static boolean shuffleIds(PsiFile file, Editor editor) {
        THashMap map = new THashMap();
        StringBuilder sb = new StringBuilder();
        final StringBuilder quote = new StringBuilder();
        ArrayList split = new ArrayList(100);
        file.acceptChildren((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor((Map)map, split, sb){
            final /* synthetic */ Map val$map;
            final /* synthetic */ ArrayList val$split;
            final /* synthetic */ StringBuilder val$sb;
            {
                this.val$map = map;
                this.val$split = arrayList;
                this.val$sb = stringBuilder2;
            }

            public void visitElement(PsiElement element) {
                if (element instanceof LeafPsiElement) {
                    char c;
                    String type = ((LeafPsiElement)element).getElementType().toString();
                    String text = element.getText();
                    if (text.isEmpty()) {
                        return;
                    }
                    int len = text.length();
                    for (int i = 0; i < len / 2 && (c = text.charAt(i)) == text.charAt(len - i - 1) && !Character.isLetter(c); ++i) {
                        quote.append(c);
                    }
                    boolean isQuoted = quote.length() > 0;
                    boolean isNumber = false;
                    if (isQuoted || type.equals("ID") || type.contains("IDENT") && !"ts".equals(text) || (isNumber = text.matches("[0-9]+"))) {
                        String replacement = (String)this.val$map.get(text);
                        if (replacement == null) {
                            this.val$split.addAll(Arrays.asList((isQuoted ? text.substring(quote.length(), text.length() - quote.length()).replace("''", "") : text).split("")));
                            if (!isNumber) {
                                ListIterator<String> it = this.val$split.listIterator();
                                while (it.hasNext()) {
                                    int cap;
                                    String s = (String)it.next();
                                    if (s.isEmpty()) {
                                        it.remove();
                                        continue;
                                    }
                                    int c2 = s.charAt(0);
                                    c2 = (char)((c2 &= ~(cap = c2 & 0x20)) >= 65 && c2 <= 90 ? (c2 - 65 + 7) % 26 + 65 : c2) | cap;
                                    it.set(String.valueOf((char)c2));
                                }
                            }
                            Collections.shuffle(this.val$split);
                            if (isNumber && "0".equals(this.val$split.get(0))) {
                                this.val$split.set(0, "1");
                            }
                            replacement = StringUtil.join((Collection)this.val$split, (String)"");
                            if (isQuoted) {
                                replacement = quote + replacement + quote.reverse();
                            }
                            this.val$map.put(text, replacement);
                        }
                        text = replacement;
                    }
                    this.val$sb.append(text);
                    quote.setLength(0);
                    this.val$split.clear();
                }
                super.visitElement(element);
            }
        });
        editor.getDocument().setText((CharSequence)sb.toString());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/devkit/actions/ShuffleNamesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

