/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions;

import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.actions.CreateTemplateInPackageAction;
import com.intellij.ide.actions.JavaCreateTemplateInPackageAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.actions.DevkitActionsUtil;
import org.jetbrains.idea.devkit.actions.NewActionDialog;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class NewActionAction
extends CreateElementActionBase
implements DescriptorUtil.Patcher {
    private static final PsiClass[] CANCELED = new PsiClass[1];
    private NewActionDialog myDialog;
    private XmlFile pluginDescriptorToPatch;

    public NewActionAction() {
        super(DevKitBundle.message("new.menu.action.text", new Object[0]), DevKitBundle.message("new.menu.action.description", new Object[0]), null);
    }

    @NotNull
    protected final PsiElement[] invokeDialog(Project project, PsiDirectory directory) {
        PsiElement[] psiElements = this.doInvokeDialog(project, directory);
        PsiElement[] psiElementArray = psiElements == CANCELED ? PsiElement.EMPTY_ARRAY : psiElements;
        if (psiElementArray == null) {
            NewActionAction.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PsiElement[] doInvokeDialog(Project project, PsiDirectory directory) {
        this.myDialog = new NewActionDialog(project, directory);
        try {
            this.myDialog.show();
            if (this.myDialog.getExitCode() == 0) {
                this.pluginDescriptorToPatch = DevkitActionsUtil.choosePluginModuleDescriptor(directory);
                if (this.pluginDescriptorToPatch != null) {
                    CreateElementActionBase.MyInputValidator validator = new CreateElementActionBase.MyInputValidator((CreateElementActionBase)this, project, directory);
                    validator.canClose(this.myDialog.getActionName());
                    PsiElement[] psiElementArray = validator.getCreatedElements();
                    return psiElementArray;
                }
            }
            PsiElement[] psiElementArray = PsiElement.EMPTY_ARRAY;
            return psiElementArray;
        }
        finally {
            this.myDialog = null;
            this.pluginDescriptorToPatch = null;
        }
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)dataContext.getData(LangDataKeys.MODULE);
        if (module == null || !PsiUtil.isPluginModule(module)) {
            return false;
        }
        return CreateTemplateInPackageAction.isAvailable((DataContext)dataContext, (Set)JavaModuleSourceRootTypes.SOURCES, JavaCreateTemplateInPackageAction::doCheckPackageExists);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected PsiElement[] create(@NotNull String newName, PsiDirectory directory) throws Exception {
        if (newName == null) {
            NewActionAction.$$$reportNull$$$0(1);
        }
        PsiClass createdClass = DevkitActionsUtil.createSingleClass(newName, "Action.java", directory);
        DescriptorUtil.patchPluginXml(this, createdClass, this.pluginDescriptorToPatch);
        PsiElement[] psiElementArray = new PsiElement[]{createdClass};
        if (psiElementArray == null) {
            NewActionAction.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public void patchPluginXml(XmlFile pluginXml, PsiClass klass) throws IncorrectOperationException {
        ActionType.ACTION.patchPluginXml(pluginXml, klass, this.myDialog);
    }

    protected String getErrorTitle() {
        return DevKitBundle.message("new.action.error", new Object[0]);
    }

    protected String getCommandName() {
        return DevKitBundle.message("new.action.command", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return DevKitBundle.message("new.action.action.name", directory, newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/actions/NewActionAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/actions/NewActionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

