/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.AreaListener;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class Extensions {
    public static final ExtensionPointName<AreaListener> AREA_LISTENER_EXTENSION_POINT = new ExtensionPointName("com.intellij.arealistener");
    private static final Map<AreaInstance, ExtensionsAreaImpl> ourAreaInstance2area = ContainerUtil.newConcurrentMap();
    private static final Map<String, AreaClassConfiguration> ourAreaClass2Configuration = ContainerUtil.newConcurrentMap();
    @NotNull
    private static ExtensionsAreaImpl ourRootArea = Extensions.createRootArea();

    private Extensions() {
    }

    @NotNull
    private static ExtensionsAreaImpl createRootArea() {
        ExtensionsAreaImpl rootArea = new ExtensionsAreaImpl(null, null, null);
        rootArea.registerExtensionPoint(new InterfaceExtensionPoint<AreaListener>(AREA_LISTENER_EXTENSION_POINT.getName(), AreaListener.class, rootArea));
        ExtensionsAreaImpl extensionsAreaImpl = rootArea;
        if (extensionsAreaImpl == null) {
            Extensions.$$$reportNull$$$0(0);
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public static ExtensionsArea getRootArea() {
        ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
        if (extensionsAreaImpl == null) {
            Extensions.$$$reportNull$$$0(1);
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public static ExtensionsArea getArea(@Nullable(value="null means root") AreaInstance areaInstance) {
        if (areaInstance == null) {
            ExtensionsAreaImpl extensionsAreaImpl = ourRootArea;
            if (extensionsAreaImpl == null) {
                Extensions.$$$reportNull$$$0(2);
            }
            return extensionsAreaImpl;
        }
        ExtensionsAreaImpl area = ourAreaInstance2area.get(areaInstance);
        if (area == null) {
            throw new IllegalArgumentException("No area instantiated for: " + areaInstance);
        }
        ExtensionsAreaImpl extensionsAreaImpl = area;
        if (extensionsAreaImpl == null) {
            Extensions.$$$reportNull$$$0(3);
        }
        return extensionsAreaImpl;
    }

    public static void cleanRootArea(@NotNull Disposable parentDisposable) {
        ExtensionsAreaImpl newArea;
        if (parentDisposable == null) {
            Extensions.$$$reportNull$$$0(4);
        }
        ExtensionsAreaImpl oldRootArea = (ExtensionsAreaImpl)Extensions.getRootArea();
        ourRootArea = newArea = Extensions.createRootArea();
        oldRootArea.notifyAreaReplaced(newArea);
        Disposer.register((Disposable)parentDisposable, () -> {
            ourRootArea = oldRootArea;
            newArea.notifyAreaReplaced(oldRootArea);
        });
    }

    @NotNull
    public static Object[] getExtensions(@NonNls @NotNull String extensionPointName) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(5);
        }
        Object[] objectArray = Extensions.getExtensions(extensionPointName, null);
        if (objectArray == null) {
            Extensions.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @Deprecated
    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(7);
        }
        T[] TArray = extensionPointName.getExtensions();
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(8);
        }
        return TArray;
    }

    @Deprecated
    @NotNull
    public static <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName, @Nullable AreaInstance areaInstance) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(9);
        }
        T[] TArray = extensionPointName.getExtensions(areaInstance);
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(10);
        }
        return TArray;
    }

    @NotNull
    public static <T> T[] getExtensions(@NotNull String extensionPointName, @Nullable(value="null means root") AreaInstance areaInstance) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(11);
        }
        ExtensionsArea area = Extensions.getArea(areaInstance);
        ExtensionPoint extensionPoint = area.getExtensionPoint(extensionPointName);
        T[] TArray = extensionPoint.getExtensions();
        if (TArray == null) {
            Extensions.$$$reportNull$$$0(12);
        }
        return TArray;
    }

    @Deprecated
    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(13);
        }
        if (extClass == null) {
            Extensions.$$$reportNull$$$0(14);
        }
        U u = extensionPointName.findExtensionOrFail(extClass);
        if (u == null) {
            Extensions.$$$reportNull$$$0(15);
        }
        return u;
    }

    @NotNull
    public static <T, U extends T> U findExtension(@NotNull ExtensionPointName<T> extensionPointName, AreaInstance areaInstance, @NotNull Class<U> extClass) {
        if (extensionPointName == null) {
            Extensions.$$$reportNull$$$0(16);
        }
        if (extClass == null) {
            Extensions.$$$reportNull$$$0(17);
        }
        for (T t : extensionPointName.getExtensions(areaInstance)) {
            if (!extClass.isInstance(t)) continue;
            T t2 = t;
            if (t2 == null) {
                Extensions.$$$reportNull$$$0(18);
            }
            return (U)t2;
        }
        throw new IllegalArgumentException("could not find extension implementation " + extClass);
    }

    public static void instantiateArea(@NonNls @NotNull String areaClass, @NotNull AreaInstance areaInstance, @Nullable(value="null means root") AreaInstance parentAreaInstance) {
        AreaClassConfiguration configuration;
        if (areaClass == null) {
            Extensions.$$$reportNull$$$0(19);
        }
        if (areaInstance == null) {
            Extensions.$$$reportNull$$$0(20);
        }
        if ((configuration = ourAreaClass2Configuration.get(areaClass)) == null) {
            throw new IllegalArgumentException("Area class is not registered: " + areaClass);
        }
        ExtensionsArea parentArea = Extensions.getArea(parentAreaInstance);
        if (!Objects.equals(parentArea.getAreaClass(), configuration.getParentClassName())) {
            throw new IllegalArgumentException("Wrong parent area. Expected class: " + configuration.getParentClassName() + " actual class: " + parentArea.getAreaClass());
        }
        ExtensionsAreaImpl area = new ExtensionsAreaImpl(areaClass, areaInstance, (PicoContainer)parentArea.getPicoContainer());
        if (ourAreaInstance2area.put(areaInstance, area) != null) {
            throw new IllegalArgumentException("Area already instantiated for: " + areaInstance);
        }
        for (AreaListener listener : Extensions.getAreaListeners()) {
            listener.areaCreated(areaClass, areaInstance);
        }
    }

    @NotNull
    private static List<AreaListener> getAreaListeners() {
        List<AreaListener> list = Extensions.getRootArea().getExtensionPoint(AREA_LISTENER_EXTENSION_POINT).getExtensionList();
        if (list == null) {
            Extensions.$$$reportNull$$$0(21);
        }
        return list;
    }

    public static void registerAreaClass(@NonNls @NotNull String areaClass, @Nullable @NonNls String parentAreaClass) {
        if (areaClass == null) {
            Extensions.$$$reportNull$$$0(22);
        }
        if (ourAreaClass2Configuration.containsKey(areaClass)) {
            AreaClassConfiguration configuration = ourAreaClass2Configuration.get(areaClass);
            if (!Objects.equals(configuration.getParentClassName(), parentAreaClass)) {
                throw new RuntimeException("Area class already registered: " + areaClass + ", " + configuration);
            }
            return;
        }
        AreaClassConfiguration configuration = new AreaClassConfiguration(areaClass, parentAreaClass);
        ourAreaClass2Configuration.put(areaClass, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disposeArea(@NotNull AreaInstance areaInstance) {
        if (areaInstance == null) {
            Extensions.$$$reportNull$$$0(23);
        }
        assert (ourAreaInstance2area.containsKey(areaInstance));
        String areaClass = ourAreaInstance2area.get(areaInstance).getAreaClass();
        if (areaClass == null) {
            throw new IllegalArgumentException("Area class is null (area never instantiated?). Instance: " + areaInstance);
        }
        try {
            for (AreaListener listener : Extensions.getAreaListeners()) {
                listener.areaDisposing(areaClass, areaInstance);
            }
        }
        finally {
            ourAreaInstance2area.remove(areaInstance);
        }
    }

    public static boolean isComponentSuitableForOs(@Nullable String os) {
        if (StringUtil.isEmpty((String)os)) {
            return true;
        }
        if (os.equals("mac")) {
            return SystemInfoRt.isMac;
        }
        if (os.equals("linux")) {
            return SystemInfoRt.isLinux;
        }
        if (os.equals("windows")) {
            return SystemInfoRt.isWindows;
        }
        if (os.equals("unix")) {
            return SystemInfoRt.isUnix;
        }
        if (os.equals("freebsd")) {
            return SystemInfoRt.isFreeBSD;
        }
        throw new IllegalArgumentException("Unknown OS " + os);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/Extensions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extClass";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "areaClass";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "areaInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createRootArea";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootArea";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArea";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/Extensions";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtension";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAreaListeners";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cleanRootArea";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "instantiateArea";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "registerAreaClass";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "disposeArea";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AreaClassConfiguration {
        private final String myClassName;
        private final String myParentClassName;

        private AreaClassConfiguration(@NotNull String className, String parentClassName) {
            if (className == null) {
                AreaClassConfiguration.$$$reportNull$$$0(0);
            }
            this.myClassName = className;
            this.myParentClassName = parentClassName;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                AreaClassConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getParentClassName() {
            return this.myParentClassName;
        }

        public String toString() {
            return "AreaClassConfiguration{myClassName='" + this.myClassName + '\'' + ", myParentClassName='" + this.myParentClassName + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "className";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/Extensions$AreaClassConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/Extensions$AreaClassConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getClassName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

