/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ImportSettingsFilenameFilter
implements FilenameFilter,
Serializable {
    public static final String SETTINGS_JAR_MARKER = "IntelliJ IDEA Global Settings";
    private static final long serialVersionUID = 201708031943L;
    private final String[] myRelativeNamesToExtract;

    public ImportSettingsFilenameFilter(@NotNull Set<String> relativeNamesToExtract) {
        if (relativeNamesToExtract == null) {
            ImportSettingsFilenameFilter.$$$reportNull$$$0(0);
        }
        this.myRelativeNamesToExtract = ArrayUtil.toStringArray(relativeNamesToExtract);
    }

    @Override
    public boolean accept(File dir, String name) {
        if (name.equals(SETTINGS_JAR_MARKER)) {
            return false;
        }
        File configPath = new File(PathManager.getConfigPath());
        String rPath = FileUtil.getRelativePath((File)configPath, (File)new File(dir, name));
        assert (rPath != null);
        String relativePath = FileUtil.toSystemIndependentName((String)rPath);
        for (String allowedRelPath : this.myRelativeNamesToExtract) {
            if (!relativePath.startsWith(allowedRelPath)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeNamesToExtract", "com/intellij/ide/actions/ImportSettingsFilenameFilter", "<init>"));
    }
}

