/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.util.HgUtil;

public class HgRevisionNumber
implements VcsRevisionNumber {
    private static final int SHORT_HASH_SIZE = 12;
    @NotNull
    private final String revision;
    @NotNull
    private final String changeset;
    @NotNull
    private final String commitMessage;
    @NotNull
    private final String author;
    @NotNull
    private final String email;
    @NotNull
    private final List<? extends HgRevisionNumber> parents;
    @NotNull
    private final String mySubject;
    private final boolean isWorkingVersion;
    public static final HgRevisionNumber NULL_REVISION_NUMBER = new HgRevisionNumber("", "", "", "", Collections.emptyList()){

        @Override
        public int compareTo(VcsRevisionNumber o) {
            return NULL.compareTo((Object)o);
        }

        @Override
        public String asString() {
            return NULL.asString();
        }
    };

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset, @NotNull String author, @NotNull String commitMessage) {
        if (revision == null) {
            HgRevisionNumber.$$$reportNull$$$0(0);
        }
        if (changeset == null) {
            HgRevisionNumber.$$$reportNull$$$0(1);
        }
        if (author == null) {
            HgRevisionNumber.$$$reportNull$$$0(2);
        }
        if (commitMessage == null) {
            HgRevisionNumber.$$$reportNull$$$0(3);
        }
        return new HgRevisionNumber(revision, changeset, author, commitMessage, Collections.emptyList());
    }

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset) {
        if (revision == null) {
            HgRevisionNumber.$$$reportNull$$$0(4);
        }
        if (changeset == null) {
            HgRevisionNumber.$$$reportNull$$$0(5);
        }
        return new HgRevisionNumber(revision, changeset, "", "", Collections.emptyList());
    }

    public static HgRevisionNumber getInstance(@NotNull String revision, @NotNull String changeset, @NotNull List<? extends HgRevisionNumber> parents) {
        if (revision == null) {
            HgRevisionNumber.$$$reportNull$$$0(6);
        }
        if (changeset == null) {
            HgRevisionNumber.$$$reportNull$$$0(7);
        }
        if (parents == null) {
            HgRevisionNumber.$$$reportNull$$$0(8);
        }
        return new HgRevisionNumber(revision, changeset, "", "", parents);
    }

    public static HgRevisionNumber getLocalInstance(@NotNull String revision) {
        if (revision == null) {
            HgRevisionNumber.$$$reportNull$$$0(9);
        }
        return new HgRevisionNumber(revision, "", "", "", Collections.emptyList());
    }

    public HgRevisionNumber(@NotNull String revision, @NotNull String changeset, @NotNull String authorInfo, @NotNull String commitMessage, @NotNull List<? extends HgRevisionNumber> parents) {
        if (revision == null) {
            HgRevisionNumber.$$$reportNull$$$0(10);
        }
        if (changeset == null) {
            HgRevisionNumber.$$$reportNull$$$0(11);
        }
        if (authorInfo == null) {
            HgRevisionNumber.$$$reportNull$$$0(12);
        }
        if (commitMessage == null) {
            HgRevisionNumber.$$$reportNull$$$0(13);
        }
        if (parents == null) {
            HgRevisionNumber.$$$reportNull$$$0(14);
        }
        this(revision, changeset, (String)HgUtil.parseUserNameAndEmail(authorInfo).getFirst(), (String)HgUtil.parseUserNameAndEmail(authorInfo).getSecond(), commitMessage, parents);
    }

    public HgRevisionNumber(@NotNull String revision, @NotNull String changeset, @NotNull String author, @NotNull String email, @NotNull String commitMessage, @NotNull List<? extends HgRevisionNumber> parents) {
        if (revision == null) {
            HgRevisionNumber.$$$reportNull$$$0(15);
        }
        if (changeset == null) {
            HgRevisionNumber.$$$reportNull$$$0(16);
        }
        if (author == null) {
            HgRevisionNumber.$$$reportNull$$$0(17);
        }
        if (email == null) {
            HgRevisionNumber.$$$reportNull$$$0(18);
        }
        if (commitMessage == null) {
            HgRevisionNumber.$$$reportNull$$$0(19);
        }
        if (parents == null) {
            HgRevisionNumber.$$$reportNull$$$0(20);
        }
        this.commitMessage = commitMessage;
        this.author = author;
        this.email = email;
        this.parents = parents;
        this.revision = revision.trim();
        this.changeset = changeset.trim();
        this.isWorkingVersion = changeset.endsWith("+");
        this.mySubject = HgBaseLogParser.extractSubject(commitMessage);
    }

    @NotNull
    public String getChangeset() {
        String string = this.changeset;
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getRevision() {
        String string = this.revision;
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(22);
        }
        return string;
    }

    public long getRevisionAsLong() {
        return Long.parseLong(this.revision);
    }

    @NotNull
    public String getCommitMessage() {
        String string = this.commitMessage;
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.author;
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getEmail() {
        String string = this.email;
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public String getAuthor() {
        String string = VcsUserUtil.getUserName((String)this.author, (String)this.email);
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(26);
        }
        return string;
    }

    public boolean isWorkingVersion() {
        return this.isWorkingVersion;
    }

    public String asString() {
        if (this.revision.isEmpty()) {
            return this.changeset;
        }
        return this.revision + ":" + this.changeset;
    }

    @NotNull
    public List<? extends HgRevisionNumber> getParents() {
        List<? extends HgRevisionNumber> list = this.parents;
        if (list == null) {
            HgRevisionNumber.$$$reportNull$$$0(27);
        }
        return list;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof HgRevisionNumber)) {
            return -1;
        }
        HgRevisionNumber other = (HgRevisionNumber)o;
        if (this.changeset.equals(other.changeset)) {
            return 0;
        }
        if (this.changeset.isEmpty()) {
            return 1;
        }
        if (other.changeset.isEmpty()) {
            return -1;
        }
        int revCompare = Long.valueOf(this.getRevisionNumber()).compareTo(Long.valueOf(other.getRevisionNumber()));
        if (revCompare != 0) {
            return revCompare;
        }
        if (HgRevisionNumber.getShortHash(this.changeset).equals(HgRevisionNumber.getShortHash(other.changeset))) {
            return 0;
        }
        if (this.isWorkingVersion) {
            return other.isWorkingVersion ? 0 : 1;
        }
        return other.isWorkingVersion ? -1 : 0;
    }

    private static String getShortHash(@NotNull String changeset) {
        if (changeset == null) {
            HgRevisionNumber.$$$reportNull$$$0(28);
        }
        return changeset.substring(0, 12);
    }

    public String getRevisionNumber() {
        if (this.isWorkingVersion) {
            return this.revision.substring(0, this.revision.length() - 1);
        }
        return this.revision;
    }

    public int hashCode() {
        return Objects.hash(this.revision, this.revision.isEmpty() ? this.changeset : HgRevisionNumber.getShortHash(this.changeset));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HgRevisionNumber)) {
            return false;
        }
        HgRevisionNumber that = (HgRevisionNumber)object;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public String getSubject() {
        String string = this.mySubject;
        if (string == null) {
            HgRevisionNumber.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeset";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "author";
                break;
            }
            case 3: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 8: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authorInfo";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "email";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgRevisionNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgRevisionNumber";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeset";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevision";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessage";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmail";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInstance";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getShortHash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

