/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.stash.GitShelveChangesSaver;
import git4idea.stash.GitStashChangesSaver;
import java.util.Collection;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitChangesSaver {
    private static final Logger LOG = Logger.getInstance(GitChangesSaver.class);
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final Git myGit;
    @NotNull
    protected final ProgressIndicator myProgressIndicator;
    @NotNull
    protected final String myStashMessage;
    protected GitConflictResolver.Params myParams;

    @NotNull
    public static GitChangesSaver getSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator progressIndicator, @NotNull String stashMessage, @NotNull GitVcsSettings.UpdateChangesPolicy saveMethod) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(1);
        }
        if (progressIndicator == null) {
            GitChangesSaver.$$$reportNull$$$0(2);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(3);
        }
        if (saveMethod == null) {
            GitChangesSaver.$$$reportNull$$$0(4);
        }
        if (saveMethod == GitVcsSettings.UpdateChangesPolicy.SHELVE) {
            GitShelveChangesSaver gitShelveChangesSaver = new GitShelveChangesSaver(project, git, progressIndicator, stashMessage);
            if (gitShelveChangesSaver == null) {
                GitChangesSaver.$$$reportNull$$$0(5);
            }
            return gitShelveChangesSaver;
        }
        GitStashChangesSaver gitStashChangesSaver = new GitStashChangesSaver(project, git, progressIndicator, stashMessage);
        if (gitStashChangesSaver == null) {
            GitChangesSaver.$$$reportNull$$$0(6);
        }
        return gitStashChangesSaver;
    }

    protected GitChangesSaver(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator, @NotNull String stashMessage) {
        if (project == null) {
            GitChangesSaver.$$$reportNull$$$0(7);
        }
        if (git == null) {
            GitChangesSaver.$$$reportNull$$$0(8);
        }
        if (indicator == null) {
            GitChangesSaver.$$$reportNull$$$0(9);
        }
        if (stashMessage == null) {
            GitChangesSaver.$$$reportNull$$$0(10);
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
        this.myStashMessage = stashMessage;
    }

    public void saveLocalChanges(@Nullable Collection<VirtualFile> rootsToSave) throws VcsException {
        if (rootsToSave == null || rootsToSave.isEmpty()) {
            return;
        }
        this.save(rootsToSave);
    }

    public void notifyLocalChangesAreNotRestored() {
        if (this.wereChangesSaved()) {
            LOG.info("Update is incomplete, changes are not restored");
            VcsNotifier.getInstance((Project)this.myProject).notifyImportantWarning("Local changes were not restored", "Before update your uncommitted changes were saved to <a href='saver'>" + this.getSaverName() + "</a>.<br/>Update is not complete, you have unresolved merges in your working tree<br/>Resolve conflicts, complete update and restore changes manually.", (NotificationListener)new ShowSavedChangesNotificationListener());
        }
    }

    public void setConflictResolverParams(GitConflictResolver.Params params) {
        this.myParams = params;
    }

    protected abstract void save(Collection<VirtualFile> var1) throws VcsException;

    public abstract void load();

    public abstract boolean wereChangesSaved();

    public abstract String getSaverName();

    @NotNull
    public abstract String getOperationName();

    public abstract void showSavedChanges();

    @NotNull
    protected static String getConflictRightPanelTitle() {
        if ("Changes from remote" == null) {
            GitChangesSaver.$$$reportNull$$$0(11);
        }
        return "Changes from remote";
    }

    @NotNull
    protected static String getConflictLeftPanelTitle() {
        if ("Your uncommitted changes" == null) {
            GitChangesSaver.$$$reportNull$$$0(12);
        }
        return "Your uncommitted changes";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stashMessage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saveMethod";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/stash/GitChangesSaver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/stash/GitChangesSaver";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaver";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictRightPanelTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictLeftPanelTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSaver";
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ShowSavedChangesNotificationListener
    implements NotificationListener {
        protected ShowSavedChangesNotificationListener() {
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                ShowSavedChangesNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                ShowSavedChangesNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("saver")) {
                GitChangesSaver.this.showSavedChanges();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "git4idea/stash/GitChangesSaver$ShowSavedChangesNotificationListener";
            objectArray[2] = "hyperlinkUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

