/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.merge.MergeProvider2;
import com.intellij.openapi.vcs.merge.MergeSession;
import com.intellij.openapi.vcs.merge.MergeSessionEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsRunnable;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.merge.GitMergeUtil;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeProvider
implements MergeProvider2 {
    private static final Logger LOG = Logger.getInstance(GitMergeProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<VirtualFile> myReverseRoots;

    private GitMergeProvider(@NotNull Project project, @NotNull Set<VirtualFile> reverseRoots) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(0);
        }
        if (reverseRoots == null) {
            GitMergeProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myReverseRoots = reverseRoots;
    }

    public GitMergeProvider(@NotNull Project project, boolean reverse) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(2);
        }
        this(project, GitMergeProvider.findReverseRoots(project, reverse ? ReverseRequest.REVERSE : ReverseRequest.FORWARD));
    }

    @NotNull
    public static MergeProvider detect(@NotNull Project project) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(3);
        }
        GitMergeProvider gitMergeProvider = new GitMergeProvider(project, GitMergeProvider.findReverseRoots(project, ReverseRequest.DETECT));
        if (gitMergeProvider == null) {
            GitMergeProvider.$$$reportNull$$$0(4);
        }
        return gitMergeProvider;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    private static Set<VirtualFile> findReverseRoots(@NotNull Project project, @NotNull ReverseRequest reverseOrDetect) {
        if (project == null) {
            GitMergeProvider.$$$reportNull$$$0(6);
        }
        if (reverseOrDetect == null) {
            GitMergeProvider.$$$reportNull$$$0(7);
        }
        HashSet reverseMap = ContainerUtil.newHashSet();
        for (GitRepository repository : GitUtil.getRepositoryManager(project).getRepositories()) {
            boolean reverse;
            if (reverseOrDetect == ReverseRequest.DETECT) {
                reverse = repository.getState().equals((Object)Repository.State.REBASING);
            } else {
                boolean bl = reverse = reverseOrDetect == ReverseRequest.REVERSE;
            }
            if (!reverse) continue;
            reverseMap.add(repository.getRoot());
        }
        HashSet hashSet = reverseMap;
        if (hashSet == null) {
            GitMergeProvider.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public MergeData loadRevisions(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(9);
        }
        final Ref mergeDataRef = new Ref((Object)new MergeData());
        final VirtualFile root = GitUtil.getGitRoot(file);
        final FilePath path = VcsUtil.getFilePath((VirtualFile)file);
        VcsRunnable runnable = new VcsRunnable(){

            public void run() throws VcsException {
                mergeDataRef.set((Object)GitMergeUtil.loadMergeData(GitMergeProvider.this.myProject, root, path, GitMergeProvider.this.myReverseRoots.contains(root)));
            }
        };
        VcsUtil.runVcsProcessWithProgress((VcsRunnable)runnable, (String)GitBundle.message("merge.load.files", new Object[0]), (boolean)false, (Project)this.myProject);
        MergeData mergeData = (MergeData)mergeDataRef.get();
        if (mergeData == null) {
            GitMergeProvider.$$$reportNull$$$0(10);
        }
        return mergeData;
    }

    @Nullable
    public String resolveMergeBranch(@NotNull VirtualFile file) {
        GitRepository repository;
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(11);
        }
        if ((repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(file)) == null) {
            return null;
        }
        return this.resolveMergeBranch(repository);
    }

    @Nullable
    public String resolveMergeBranchOrCherryPick(@NotNull VirtualFile file) {
        GitRepository repository;
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(12);
        }
        if ((repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile(file)) == null) {
            return null;
        }
        String mergeBranch = this.resolveMergeBranch(repository);
        if (mergeBranch != null) {
            return mergeBranch;
        }
        String rebaseOntoBranch = this.resolveRebaseOntoBranch(repository.getRoot());
        if (rebaseOntoBranch != null) {
            return rebaseOntoBranch;
        }
        try {
            GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "CHERRY_PICK_HEAD");
            return "cherry-pick";
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public String resolveMergeBranch(GitRepository repository) {
        GitRevisionNumber mergeHeadRevisionNumber;
        try {
            mergeHeadRevisionNumber = GitRevisionNumber.resolve(this.myProject, repository.getRoot(), "MERGE_HEAD");
        }
        catch (VcsException e) {
            return null;
        }
        return GitMergeProvider.resolveBranchName(repository, mergeHeadRevisionNumber);
    }

    @Nullable
    public String resolveRebaseOntoBranch(@NotNull VirtualFile root) {
        String ontoHash;
        File rebaseDir;
        if (root == null) {
            GitMergeProvider.$$$reportNull$$$0(13);
        }
        if ((rebaseDir = GitRebaseUtils.getRebaseDir(this.myProject, root)) == null) {
            return null;
        }
        try {
            ontoHash = FileUtil.loadFile((File)new File(rebaseDir, "onto")).trim();
        }
        catch (IOException e) {
            return null;
        }
        GitRepository repo = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRoot(root);
        if (repo == null) {
            return null;
        }
        return GitMergeProvider.resolveBranchName(repo, new GitRevisionNumber(ontoHash));
    }

    public static String resolveBranchName(GitRepository repository, GitRevisionNumber revisionNumber) {
        Collection<GitRemoteBranch> remoteBranchesByHash;
        Hash hash = HashImpl.build((String)revisionNumber.asString());
        Collection<GitLocalBranch> localBranchesByHash = repository.getBranches().findLocalBranchesByHash(hash);
        if (localBranchesByHash.size() == 1) {
            return localBranchesByHash.iterator().next().getName();
        }
        if (localBranchesByHash.isEmpty() && (remoteBranchesByHash = repository.getBranches().findRemoteBranchesByHash(hash)).size() == 1) {
            return remoteBranchesByHash.iterator().next().getName();
        }
        return revisionNumber.getShortRev();
    }

    public void conflictResolvedForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(14);
        }
        try {
            GitFileUtils.addFilesForce(this.myProject, GitUtil.getGitRoot(file), Collections.singletonList(file));
        }
        catch (VcsException e) {
            LOG.error("Confirming conflict resolution failed", (Throwable)e);
        }
    }

    public boolean isBinary(@NotNull VirtualFile file) {
        if (file == null) {
            GitMergeProvider.$$$reportNull$$$0(15);
        }
        return file.getFileType().isBinary();
    }

    @NotNull
    public MergeSession createMergeSession(@NotNull List<VirtualFile> files) {
        if (files == null) {
            GitMergeProvider.$$$reportNull$$$0(16);
        }
        MyMergeSession myMergeSession = new MyMergeSession(files);
        if (myMergeSession == null) {
            GitMergeProvider.$$$reportNull$$$0(17);
        }
        return myMergeSession;
    }

    public MergeDialogCustomizer createDefaultMergeDialogCustomizer() {
        return new GitDefaultMergeDialogCustomizer(this);
    }

    @NotNull
    public static String calcColumnName(boolean isTheirs, @Nullable String branchName) {
        String title = isTheirs ? GitBundle.message("merge.tool.column.theirs.status", new Object[0]) : GitBundle.message("merge.tool.column.yours.status", new Object[0]);
        String string = branchName != null ? title + " (" + branchName + ")" : title;
        if (string == null) {
            GitMergeProvider.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public String getSingleMergeBranchName(Collection<VirtualFile> roots) {
        return ((Optional)roots.stream().map(root -> this.resolveMergeBranchOrCherryPick((VirtualFile)root)).filter(branch -> branch != null).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    @Nullable
    public String getSingleCurrentBranchName(Collection<VirtualFile> roots) {
        return ((Optional)roots.stream().map(root -> (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForFile((VirtualFile)root)).map(repo -> repo == null ? null : repo.getCurrentBranchName()).filter(branch -> branch != null).collect(MoreCollectors.onlyOne())).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseRoots";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitMergeProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseOrDetect";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitMergeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findReverseRoots";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRevisions";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createMergeSession";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumnName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findReverseRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadRevisions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveMergeBranch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveMergeBranchOrCherryPick";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveRebaseOntoBranch";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "conflictResolvedForFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isBinary";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createMergeSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMergeSession
    implements MergeSessionEx {
        Map<VirtualFile, Conflict> myConflicts = new HashMap<VirtualFile, Conflict>();
        String currentBranchName;
        String mergeHeadBranchName;

        MyMergeSession(List<VirtualFile> filesToMerge) {
            try {
                Map<VirtualFile, List<VirtualFile>> filesByRoot = GitUtil.sortFilesByGitRoot(filesToMerge);
                for (Map.Entry<VirtualFile, List<VirtualFile>> e : filesByRoot.entrySet()) {
                    HashMap<String, Conflict> cs = new HashMap<String, Conflict>();
                    VirtualFile root = e.getKey();
                    List<VirtualFile> files = e.getValue();
                    GitLineHandler h = new GitLineHandler(GitMergeProvider.this.myProject, root, GitCommand.LS_FILES);
                    h.setStdoutSuppressed(true);
                    h.setSilent(true);
                    h.addParameters("--exclude-standard", "--unmerged", "-t", "-z");
                    h.endOptions();
                    String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
                    StringScanner s = new StringScanner(output);
                    while (s.hasMoreData()) {
                        if (!"M".equals(s.spaceToken())) {
                            s.boundedToken('\u0000');
                            continue;
                        }
                        s.spaceToken();
                        s.spaceToken();
                        int source = Integer.parseInt(s.tabToken());
                        String file = s.boundedToken('\u0000');
                        Conflict c = (Conflict)cs.get(file);
                        if (c == null) {
                            c = new Conflict();
                            c.myRoot = root;
                            cs.put(file, c);
                        }
                        if (source == 3) {
                            c.myStatusTheirs = Conflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 2) {
                            c.myStatusYours = Conflict.Status.MODIFIED;
                            continue;
                        }
                        if (source == 1) continue;
                        throw new IllegalStateException("Unknown revision " + source + " for the file: " + file);
                    }
                    for (VirtualFile f : files) {
                        String path = VcsFileUtil.relativePath((VirtualFile)root, (VirtualFile)f);
                        Conflict c = (Conflict)cs.get(path);
                        if (c == null) {
                            LOG.error(String.format("The conflict not found for file: %s(%s)%nFull ls-files output: %n%s%nAll files: %n%s", f.getPath(), path, output, files));
                            continue;
                        }
                        c.myFile = f;
                        if (c.myStatusTheirs == null) {
                            c.myStatusTheirs = Conflict.Status.DELETED;
                        }
                        if (c.myStatusYours == null) {
                            c.myStatusYours = Conflict.Status.DELETED;
                        }
                        this.myConflicts.put(f, c);
                    }
                }
                this.currentBranchName = GitMergeProvider.this.getSingleCurrentBranchName(filesByRoot.keySet());
                this.mergeHeadBranchName = GitMergeProvider.this.getSingleMergeBranchName(filesByRoot.keySet());
            }
            catch (VcsException ex) {
                throw new IllegalStateException("The git operation should not fail in this context", ex);
            }
        }

        @NotNull
        public ColumnInfo[] getMergeInfoColumns() {
            ColumnInfo[] columnInfoArray = new ColumnInfo[]{new StatusColumn(false, this.currentBranchName), new StatusColumn(true, this.mergeHeadBranchName)};
            if (columnInfoArray == null) {
                MyMergeSession.$$$reportNull$$$0(0);
            }
            return columnInfoArray;
        }

        public boolean canMerge(@NotNull VirtualFile file) {
            Conflict c;
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(1);
            }
            return (c = this.myConflicts.get(file)) != null && !file.isDirectory();
        }

        public void conflictResolvedForFile(@NotNull VirtualFile file, @NotNull MergeSession.Resolution resolution) {
            if (file == null) {
                MyMergeSession.$$$reportNull$$$0(2);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(3);
            }
            this.conflictResolvedForFiles(Collections.singletonList(file), resolution);
        }

        public void conflictResolvedForFiles(@NotNull List<VirtualFile> files, @NotNull MergeSession.Resolution resolution) {
            if (files == null) {
                MyMergeSession.$$$reportNull$$$0(4);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(5);
            }
            MultiMap<VirtualFile, Conflict> byRoot = this.groupConflictsByRoot(files);
            for (VirtualFile root : byRoot.keySet()) {
                Collection conflicts = byRoot.get((Object)root);
                ArrayList<VirtualFile> toAdd = new ArrayList<VirtualFile>();
                ArrayList<VirtualFile> toDelete = new ArrayList<VirtualFile>();
                for (Conflict c : conflicts) {
                    Conflict.Status status;
                    boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(c.myRoot);
                    switch (resolution) {
                        case AcceptedTheirs: {
                            status = !isReversed ? c.myStatusTheirs : c.myStatusYours;
                            break;
                        }
                        case AcceptedYours: {
                            status = isReversed ? c.myStatusTheirs : c.myStatusYours;
                            break;
                        }
                        case Merged: {
                            status = Conflict.Status.MODIFIED;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported resolution: " + resolution);
                        }
                    }
                    if (status == Conflict.Status.MODIFIED) {
                        toAdd.add(c.myFile);
                        continue;
                    }
                    toDelete.add(c.myFile);
                }
                try {
                    GitFileUtils.addFilesForce(GitMergeProvider.this.myProject, root, toAdd);
                    GitFileUtils.deleteFiles(GitMergeProvider.this.myProject, root, toDelete, new String[0]);
                }
                catch (VcsException e) {
                    LOG.error(String.format("Unexpected exception during the git operation: modified - %s deleted - %s)", toAdd, toDelete), (Throwable)e);
                }
            }
        }

        public void acceptFilesRevisions(@NotNull List<VirtualFile> files, @NotNull MergeSession.Resolution resolution) throws VcsException {
            if (files == null) {
                MyMergeSession.$$$reportNull$$$0(6);
            }
            if (resolution == null) {
                MyMergeSession.$$$reportNull$$$0(7);
            }
            assert (resolution == MergeSession.Resolution.AcceptedYours || resolution == MergeSession.Resolution.AcceptedTheirs);
            MultiMap<VirtualFile, Conflict> byRoot = this.groupConflictsByRoot(files);
            for (VirtualFile root : byRoot.keySet()) {
                Collection conflicts = byRoot.get((Object)root);
                boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(root);
                boolean acceptYours = !isReversed ? resolution == MergeSession.Resolution.AcceptedYours : resolution == MergeSession.Resolution.AcceptedTheirs;
                List filesToCheckout = ContainerUtil.mapNotNull((Collection)conflicts, c -> {
                    Conflict.Status status = acceptYours ? c.myStatusYours : c.myStatusTheirs;
                    return status == Conflict.Status.MODIFIED ? c.myFile : null;
                });
                String parameter = acceptYours ? "--ours" : "--theirs";
                for (List paths : VcsFileUtil.chunkFiles((VirtualFile)root, (Collection)filesToCheckout)) {
                    GitLineHandler handler = new GitLineHandler(GitMergeProvider.this.myProject, root, GitCommand.CHECKOUT);
                    handler.addParameters(parameter);
                    handler.endOptions();
                    handler.addParameters(paths);
                    GitCommandResult result2 = Git.getInstance().runCommand(handler);
                    if (result2.success()) continue;
                    throw new VcsException(result2.getErrorOutputAsJoinedString());
                }
            }
        }

        @NotNull
        private MultiMap<VirtualFile, Conflict> groupConflictsByRoot(@NotNull List<VirtualFile> files) {
            if (files == null) {
                MyMergeSession.$$$reportNull$$$0(8);
            }
            MultiMap byRoot = MultiMap.create();
            for (VirtualFile file : files) {
                Conflict c = this.myConflicts.get(file);
                if (c == null) {
                    LOG.error("Conflict was not loaded for the file: " + file.getPath());
                    continue;
                }
                byRoot.putValue((Object)c.myRoot, (Object)c);
            }
            MultiMap multiMap = byRoot;
            if (multiMap == null) {
                MyMergeSession.$$$reportNull$$$0(9);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/merge/GitMergeProvider$MyMergeSession";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolution";
                    break;
                }
                case 4: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergeInfoColumns";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/merge/GitMergeProvider$MyMergeSession";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "groupConflictsByRoot";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "canMerge";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "conflictResolvedForFile";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "conflictResolvedForFiles";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptFilesRevisions";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "groupConflictsByRoot";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        class StatusColumn
        extends ColumnInfo<VirtualFile, String> {
            private final boolean myIsLast;

            StatusColumn(@Nullable boolean isLast, String branchName) {
                super(GitMergeProvider.calcColumnName(isLast, branchName));
                this.myIsLast = isLast;
            }

            public String valueOf(VirtualFile file) {
                Conflict c = MyMergeSession.this.myConflicts.get(file);
                if (c == null) {
                    LOG.error("No conflict for the file " + file);
                    return "";
                }
                boolean isReversed = GitMergeProvider.this.myReverseRoots.contains(c.myRoot);
                Conflict.Status currentStatus = !isReversed ? c.myStatusYours : c.myStatusTheirs;
                Conflict.Status lastStatus = isReversed ? c.myStatusYours : c.myStatusTheirs;
                Conflict.Status status = this.myIsLast ? lastStatus : currentStatus;
                switch (status) {
                    case MODIFIED: {
                        return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
                    }
                    case DELETED: {
                        return GitBundle.message("merge.tool.column.status.deleted", new Object[0]);
                    }
                }
                throw new IllegalStateException("Unknown status " + (Object)((Object)status) + " for file " + file.getPath());
            }

            public String getMaxStringValue() {
                return GitBundle.message("merge.tool.column.status.modified", new Object[0]);
            }

            public int getAdditionalWidth() {
                return 10;
            }
        }
    }

    private static class Conflict {
        VirtualFile myFile;
        VirtualFile myRoot;
        Status myStatusTheirs;
        Status myStatusYours;

        private Conflict() {
        }

        static enum Status {
            MODIFIED,
            DELETED;

        }
    }

    private static enum ReverseRequest {
        REVERSE,
        FORWARD,
        DETECT;

    }
}

