/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.commands.GitHandler;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitLogRecord {
    private static final Logger LOG = Logger.getInstance(GitLogRecord.class);
    @NotNull
    private final Map<GitLogParser.GitLogOption, String> myOptions;
    @NotNull
    private final List<VcsFileStatusInfo> myStatusInfo;
    private final boolean mySupportsRawBody;
    private GitHandler myHandler;

    GitLogRecord(@NotNull Map<GitLogParser.GitLogOption, String> options, @NotNull List<VcsFileStatusInfo> statusInfo, boolean supportsRawBody) {
        if (options == null) {
            GitLogRecord.$$$reportNull$$$0(0);
        }
        if (statusInfo == null) {
            GitLogRecord.$$$reportNull$$$0(1);
        }
        this.myOptions = options;
        this.myStatusInfo = statusInfo;
        this.mySupportsRawBody = supportsRawBody;
    }

    @NotNull
    private Collection<String> getPaths() {
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (VcsFileStatusInfo info : this.myStatusInfo) {
            result2.add(info.getFirstPath());
            if (info.getSecondPath() == null) continue;
            result2.add(info.getSecondPath());
        }
        LinkedHashSet linkedHashSet = result2;
        if (linkedHashSet == null) {
            GitLogRecord.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @NotNull
    List<VcsFileStatusInfo> getStatusInfos() {
        List<VcsFileStatusInfo> list = this.myStatusInfo;
        if (list == null) {
            GitLogRecord.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<FilePath> getFilePaths(@NotNull VirtualFile root) {
        if (root == null) {
            GitLogRecord.$$$reportNull$$$0(4);
        }
        ArrayList<FilePath> res = new ArrayList<FilePath>();
        String prefix = root.getPath() + "/";
        for (String strPath : this.getPaths()) {
            res.add(VcsUtil.getFilePath((String)(prefix + strPath), (boolean)false));
        }
        ArrayList<FilePath> arrayList = res;
        if (arrayList == null) {
            GitLogRecord.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private String lookup(@NotNull GitLogParser.GitLogOption key) {
        String value;
        if (key == null) {
            GitLogRecord.$$$reportNull$$$0(6);
        }
        if ((value = this.myOptions.get((Object)key)) == null) {
            LOG.error("Missing value for option " + (Object)((Object)key) + ", while executing " + this.myHandler);
            if ("" == null) {
                GitLogRecord.$$$reportNull$$$0(7);
            }
            return "";
        }
        String string = GitLogRecord.shortBuffer(value);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    String getHash() {
        String string = this.lookup(GitLogParser.GitLogOption.HASH);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    String getTreeHash() {
        String string = this.lookup(GitLogParser.GitLogOption.TREE);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    String getAuthorName() {
        String string = this.lookup(GitLogParser.GitLogOption.AUTHOR_NAME);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    String getAuthorEmail() {
        String string = this.lookup(GitLogParser.GitLogOption.AUTHOR_EMAIL);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    String getCommitterName() {
        String string = this.lookup(GitLogParser.GitLogOption.COMMITTER_NAME);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    String getCommitterEmail() {
        String string = this.lookup(GitLogParser.GitLogOption.COMMITTER_EMAIL);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    String getSubject() {
        String string = this.lookup(GitLogParser.GitLogOption.SUBJECT);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    String getBody() {
        String string = this.lookup(GitLogParser.GitLogOption.BODY);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    String getRawBody() {
        String string = this.lookup(GitLogParser.GitLogOption.RAW_BODY);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    String getShortenedRefLog() {
        String string = this.lookup(GitLogParser.GitLogOption.SHORT_REF_LOG_SELECTOR);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    Date getDate() {
        Date date = new Date(this.getCommitTime());
        if (date == null) {
            GitLogRecord.$$$reportNull$$$0(19);
        }
        return date;
    }

    long getCommitTime() {
        try {
            return Long.parseLong(this.myOptions.get((Object)GitLogParser.GitLogOption.COMMIT_TIME).trim()) * 1000L;
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get commit time from " + this.toString() + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    long getAuthorTimeStamp() {
        try {
            return Long.parseLong(this.myOptions.get((Object)GitLogParser.GitLogOption.AUTHOR_TIME).trim()) * 1000L;
        }
        catch (NumberFormatException e) {
            LOG.error("Couldn't get author time from " + this.toString() + ", while executing " + this.myHandler, (Throwable)e);
            return 0L;
        }
    }

    String getFullMessage() {
        return this.mySupportsRawBody ? this.getRawBody().trim() : (this.getSubject() + "\n\n" + this.getBody()).trim();
    }

    @NotNull
    String[] getParentsHashes() {
        String parents = this.lookup(GitLogParser.GitLogOption.PARENTS);
        if (parents.trim().length() == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                GitLogRecord.$$$reportNull$$$0(20);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = parents.split(" ");
        if (stringArray == null) {
            GitLogRecord.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    @NotNull
    public Collection<String> getRefs() {
        String decorate = this.myOptions.get((Object)GitLogParser.GitLogOption.REF_NAMES);
        List<String> list = GitLogRecord.parseRefNames(decorate);
        if (list == null) {
            GitLogRecord.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public Map<GitLogParser.GitLogOption, String> getOptions() {
        Map<GitLogParser.GitLogOption, String> map2 = this.myOptions;
        if (map2 == null) {
            GitLogRecord.$$$reportNull$$$0(23);
        }
        return map2;
    }

    public boolean isSupportsRawBody() {
        return this.mySupportsRawBody;
    }

    @NotNull
    private static List<String> parseRefNames(@Nullable String decoration) {
        if (decoration == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GitLogRecord.$$$reportNull$$$0(24);
            }
            return list;
        }
        int startParentheses = decoration.indexOf("(");
        int endParentheses = decoration.indexOf(")");
        if (startParentheses == -1 || endParentheses == -1) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GitLogRecord.$$$reportNull$$$0(25);
            }
            return list;
        }
        String refs = decoration.substring(startParentheses + 1, endParentheses);
        String[] names = refs.split(", ");
        ArrayList result2 = ContainerUtil.newArrayList();
        for (String item : names) {
            String POINTER = " -> ";
            if (item.contains(" -> ")) {
                List parts = StringUtil.split((String)item, (String)" -> ");
                result2.addAll(ContainerUtil.map((Collection)parts, s -> GitLogRecord.shortBuffer(s.trim())));
                continue;
            }
            int colon = item.indexOf(58);
            result2.add(GitLogRecord.shortBuffer(colon > 0 ? item.substring(colon + 1).trim() : item));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            GitLogRecord.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static String shortBuffer(@NotNull String raw) {
        if (raw == null) {
            GitLogRecord.$$$reportNull$$$0(27);
        }
        String string = new String(raw);
        if (string == null) {
            GitLogRecord.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public List<Change> parseChanges(@NotNull Project project, @NotNull VirtualFile vcsRoot) throws VcsException {
        if (project == null) {
            GitLogRecord.$$$reportNull$$$0(29);
        }
        if (vcsRoot == null) {
            GitLogRecord.$$$reportNull$$$0(30);
        }
        String[] hashes2 = this.getParentsHashes();
        List<Change> list = GitChangesParser.parse(project, vcsRoot, this.myStatusInfo, this.getHash(), this.getDate(), hashes2.length == 0 ? null : hashes2[0]);
        if (list == null) {
            GitLogRecord.$$$reportNull$$$0(31);
        }
        return list;
    }

    public void setUsedHandler(GitHandler handler) {
        this.myHandler = handler;
    }

    public String toString() {
        return String.format("GitLogRecord{myOptions=%s, myStatusInfo=%s, mySupportsRawBody=%s, myHandler=%s}", this.myOptions, this.myStatusInfo, this.mySupportsRawBody, this.myHandler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusInfo";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogRecord";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "raw";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogRecord";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusInfos";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePaths";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "lookup";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeHash";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthorEmail";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitterEmail";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawBody";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortenedRefLog";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDate";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentsHashes";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRefNames";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "shortBuffer";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "parseChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilePaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lookup";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shortBuffer";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "parseChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

