/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogUtil;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GitCommit
extends VcsChangesLazilyParsedDetails {
    @NotNull
    private final GitLogUtil.DiffRenameLimit myRenameLimit;

    /*
     * WARNING - void declaration
     */
    public GitCommit(Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<VcsFileStatusInfo>> list, @NotNull GitLogUtil.DiffRenameLimit diffRenameLimit) {
        void reportedChanges;
        void renameLimit;
        if (hash == null) {
            GitCommit.$$$reportNull$$$0(0);
        }
        if (parents == null) {
            GitCommit.$$$reportNull$$$0(1);
        }
        if (root == null) {
            GitCommit.$$$reportNull$$$0(2);
        }
        if (subject == null) {
            GitCommit.$$$reportNull$$$0(3);
        }
        if (author == null) {
            GitCommit.$$$reportNull$$$0(4);
        }
        if (message == null) {
            GitCommit.$$$reportNull$$$0(5);
        }
        if (committer == null) {
            GitCommit.$$$reportNull$$$0(6);
        }
        if (list == null) {
            GitCommit.$$$reportNull$$$0(7);
        }
        if (diffRenameLimit == null) {
            GitCommit.$$$reportNull$$$0(8);
        }
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
        this.myRenameLimit = renameLimit;
        this.myChanges.set(reportedChanges.isEmpty() ? EMPTY_CHANGES : new UnparsedChanges(project, (List)reportedChanges));
    }

    public boolean hasRenames() {
        switch (this.myRenameLimit) {
            case INFINITY: {
                return true;
            }
            case GIT_CONFIG: {
                return false;
            }
            case REGISTRY: {
                VcsChangesLazilyParsedDetails.Changes changes = (VcsChangesLazilyParsedDetails.Changes)this.myChanges.get();
                int estimate = changes instanceof UnparsedChanges ? ((UnparsedChanges)changes).getRenameLimitEstimate() : this.getRenameLimitEstimate();
                return estimate <= Registry.intValue((String)"git.diff.renameLimit");
            }
        }
        return true;
    }

    private int getRenameLimitEstimate() {
        int size = 0;
        for (int i = 0; i < this.getParents().size(); ++i) {
            int sources = 0;
            int targets = 0;
            for (Change info : this.getChanges(i)) {
                Change.Type type = info.getType();
                if (ContainerUtil.set((Object[])new Change.Type[]{Change.Type.DELETED, Change.Type.MOVED}).contains(type)) {
                    ++sources;
                }
                if (!ContainerUtil.set((Object[])new Change.Type[]{Change.Type.NEW}).contains(type)) continue;
                ++targets;
            }
            size = Math.max(Math.max(sources, targets), size);
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "hash";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "subject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "author";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "committer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "reportedChanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "renameLimit";
                break;
            }
        }
        objectArray[1] = "git4idea/GitCommit";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UnparsedChanges
    extends VcsChangesLazilyParsedDetails.UnparsedChanges {
        private UnparsedChanges(@NotNull Project project, List<List<VcsFileStatusInfo>> changesOutput) {
            if (project == null) {
                UnparsedChanges.$$$reportNull$$$0(0);
            }
            if (changesOutput == null) {
                UnparsedChanges.$$$reportNull$$$0(1);
            }
            super((VcsChangesLazilyParsedDetails)GitCommit.this, project, changesOutput);
        }

        @NotNull
        protected List<Change> parseStatusInfo(@NotNull List<VcsFileStatusInfo> changes, int parentIndex) throws VcsException {
            if (changes == null) {
                UnparsedChanges.$$$reportNull$$$0(2);
            }
            String parentHash = null;
            if (parentIndex < GitCommit.this.getParents().size()) {
                parentHash = ((Hash)GitCommit.this.getParents().get(parentIndex)).asString();
            }
            List<Change> list = GitChangesParser.parse(this.myProject, GitCommit.this.getRoot(), changes, GitCommit.this.getId().asString(), new Date(GitCommit.this.getCommitTime()), parentHash);
            if (list == null) {
                UnparsedChanges.$$$reportNull$$$0(3);
            }
            return list;
        }

        int getRenameLimitEstimate() {
            int size = 0;
            for (List changesWithParent : this.myChangesOutput) {
                int sources = 0;
                int targets = 0;
                for (VcsFileStatusInfo info : changesWithParent) {
                    Change.Type type = info.getType();
                    if (ContainerUtil.set((Object[])new Change.Type[]{Change.Type.DELETED, Change.Type.MOVED}).contains(type)) {
                        ++sources;
                    }
                    if (!ContainerUtil.set((Object[])new Change.Type[]{Change.Type.NEW}).contains(type)) continue;
                    ++targets;
                }
                size = Math.max(Math.max(sources, targets), size);
            }
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesOutput";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/GitCommit$UnparsedChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/GitCommit$UnparsedChanges";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseStatusInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parseStatusInfo";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

