/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.wrappers.FileResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.android.resourceManagers.ValueResourceInfoImpl;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceManager {
    protected final Project myProject;

    protected ResourceManager(@NotNull Project project) {
        if (project == null) {
            ResourceManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public abstract ResourceRepository getResourceRepository();

    @NotNull
    public abstract Multimap<String, VirtualFile> getAllResourceDirs();

    @NotNull
    public abstract List<VirtualFile> getResourceDirs();

    public abstract boolean isResourceDir(@NotNull VirtualFile var1);

    @Nullable
    public abstract AttributeDefinitions getAttributeDefinitions();

    private void processFileResources(@NotNull Multimap<String, VirtualFile> resDirs, @NotNull ResourceFolderType folderType, @NotNull FileResourceProcessor processor) {
        if (resDirs == null) {
            ResourceManager.$$$reportNull$$$0(1);
        }
        if (folderType == null) {
            ResourceManager.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            ResourceManager.$$$reportNull$$$0(3);
        }
        for (Map.Entry entry : resDirs.asMap().entrySet()) {
            for (VirtualFile resSubdir : AndroidResourceUtil.getResourceSubdirs(folderType, (Collection)entry.getValue())) {
                ResourceFolderType resType = ResourceFolderType.getFolderType((String)resSubdir.getName());
                if (resType == null) continue;
                assert (folderType.equals((Object)resType));
                String resTypeName = resType.getName();
                for (VirtualFile resFile : resSubdir.getChildren()) {
                    String resName = AndroidCommonUtils.getResourceName((String)resTypeName, (String)resFile.getName());
                    if (resFile.isDirectory() || !this.isResourcePublic(resTypeName, resName)) continue;
                    processor.process(resFile, resName, (String)entry.getKey());
                }
            }
        }
    }

    @NotNull
    private Multimap<String, VirtualFile> getResourceDirsByLibraryName(boolean withDependencies) {
        Multimap<String, VirtualFile> resDirs;
        if (withDependencies) {
            resDirs = this.getAllResourceDirs();
        } else {
            resDirs = HashMultimap.create();
            resDirs.putAll(null, this.getResourceDirs());
        }
        Multimap<String, VirtualFile> multimap = resDirs;
        if (multimap == null) {
            ResourceManager.$$$reportNull$$$0(4);
        }
        return multimap;
    }

    public boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            ResourceManager.$$$reportNull$$$0(5);
        }
        if (name == null) {
            ResourceManager.$$$reportNull$$$0(6);
        }
        return true;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceType) {
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(7);
        }
        List<PsiFile> list = this.findResourceFiles(resourceType, null, true, true);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> findResourceFiles(@NotNull ResourceFolderType resourceFolderType, @Nullable String nameToLookFor, boolean distinguishDelimitersInName, boolean withDependencies) {
        if (resourceFolderType == null) {
            ResourceManager.$$$reportNull$$$0(9);
        }
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        this.processFileResources(this.getResourceDirsByLibraryName(withDependencies), resourceFolderType, (resFile, resName, libraryName) -> {
            PsiFile file;
            if ((nameToLookFor == null || AndroidUtils.equal(nameToLookFor, resName, distinguishDelimitersInName)) && (file = AndroidPsiUtils.getPsiFileSafely(this.myProject, resFile)) != null) {
                result2.add(file);
            }
        });
        ArrayList<PsiFile> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Nullable
    public ResourceType getValueResourceType(@NotNull XmlTag tag) {
        ResourceFolderType fileResType;
        if (tag == null) {
            ResourceManager.$$$reportNull$$$0(11);
        }
        if (ResourceFolderType.VALUES == (fileResType = this.getFileResourceFolderType(tag.getContainingFile()))) {
            return AndroidResourceUtil.getResourceTypeForResourceTag(tag);
        }
        return null;
    }

    @Nullable
    public ResourceFolderType getFileResourceFolderType(@NotNull PsiFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(12);
        }
        return (ResourceFolderType)ApplicationManager.getApplication().runReadAction(() -> {
            PsiDirectory dir = file.getContainingDirectory();
            if (dir == null) {
                return null;
            }
            PsiDirectory possibleResDir = dir.getParentDirectory();
            if (possibleResDir == null || !this.isResourceDir(possibleResDir.getVirtualFile())) {
                return null;
            }
            return ResourceFolderType.getFolderType((String)dir.getName());
        });
    }

    @Nullable
    public String getFileResourceType(@NotNull PsiFile file) {
        ResourceFolderType folderType;
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(13);
        }
        return (folderType = this.getFileResourceFolderType(file)) == null ? null : folderType.getName();
    }

    @NotNull
    private Collection<SingleNamespaceResourceRepository> getLeafResourceRepositories() {
        ArrayList<SingleNamespaceResourceRepository> result2 = new ArrayList<SingleNamespaceResourceRepository>();
        this.getResourceRepository().getLeafResourceRepositories(result2);
        ArrayList<SingleNamespaceResourceRepository> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public List<XmlAttributeValue> findIdDeclarations(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(15);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(16);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(17);
            }
            return list;
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles(files2, attributeValue -> {
            if (AndroidResourceUtil.isIdDeclaration(attributeValue)) {
                String idInAttr = AndroidResourceUtil.getResourceNameByReferenceText(attributeValue.getValue());
                return id.equals(idInAttr);
            }
            return false;
        });
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<XmlAttributeValue> findConstraintReferencedIds(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(19);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(20);
        }
        if (!this.isResourcePublic(ResourceType.ID.getName(), id)) {
            List<XmlAttributeValue> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(21);
            }
            return list;
        }
        Set<VirtualFile> files2 = this.getFilesDeclaringId(namespace, id);
        List<XmlAttributeValue> list = this.findIdUsagesFromFiles(files2, attributeValue -> {
            String ids;
            if (AndroidResourceUtil.isConstraintReferencedIds(attributeValue) && (ids = attributeValue.getValue()) != null) {
                return Arrays.asList(ids.split(",")).contains(id);
            }
            return false;
        });
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    private Set<VirtualFile> getFilesDeclaringId(@NotNull ResourceNamespace namespace, @NotNull String id) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(23);
        }
        if (id == null) {
            ResourceManager.$$$reportNull$$$0(24);
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (ResourceRepository resourceRepository : this.getLeafResourceRepositories()) {
            List items2 = resourceRepository.getResources(namespace, ResourceType.ID, id);
            for (ResourceItem item : items2) {
                VirtualFile file = ResourceHelper.getSourceAsVirtualFile(item);
                if (file == null) continue;
                files2.add(file);
            }
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            ResourceManager.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    private List<XmlAttributeValue> findIdUsagesFromFiles(@NotNull Set<VirtualFile> fileSet, final @NotNull Predicate<XmlAttributeValue> condition) {
        if (fileSet == null) {
            ResourceManager.$$$reportNull$$$0(26);
        }
        if (condition == null) {
            ResourceManager.$$$reportNull$$$0(27);
        }
        final ArrayList<XmlAttributeValue> usages = new ArrayList<XmlAttributeValue>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (VirtualFile file : fileSet) {
            PsiFile psiFile;
            if (!fileSet.contains(file) || !((psiFile = psiManager.findFile(file)) instanceof XmlFile)) continue;
            psiFile.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

                public void visitXmlAttributeValue(XmlAttributeValue attributeValue) {
                    if (condition.test(attributeValue)) {
                        usages.add(attributeValue);
                    }
                }
            });
        }
        return usages;
    }

    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(28);
        }
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(29);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(30);
        }
        return this.findValueResources(namespace, resType, resName, true);
    }

    @NotNull
    public List<ResourceElement> findValueResources(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(31);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(32);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(33);
        }
        List<ValueResourceInfoImpl> resources = this.findValueResourceInfos(namespace, resourceType, resourceName, distinguishDelimitersInName, false);
        ArrayList<ResourceElement> result2 = new ArrayList<ResourceElement>();
        for (ValueResourceInfoImpl resource : resources) {
            ResourceElement domElement = resource.computeDomElement();
            if (domElement == null) continue;
            result2.add(domElement);
        }
        ArrayList<ResourceElement> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    public void collectLazyResourceElements(@NotNull ResourceNamespace namespace, @NotNull String resType, @NotNull String resName, boolean withAttrs, @NotNull PsiElement context, @NotNull Collection<PsiElement> elements) {
        ResourceFolderType folderType;
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(35);
        }
        if (resType == null) {
            ResourceManager.$$$reportNull$$$0(36);
        }
        if (resName == null) {
            ResourceManager.$$$reportNull$$$0(37);
        }
        if (context == null) {
            ResourceManager.$$$reportNull$$$0(38);
        }
        if (elements == null) {
            ResourceManager.$$$reportNull$$$0(39);
        }
        List<ValueResourceInfoImpl> valueResources = this.findValueResourceInfos(namespace, resType, resName, false, withAttrs);
        for (ValueResourceInfo valueResourceInfo : valueResources) {
            elements.add((PsiElement)new LazyValueResourceElementWrapper(valueResourceInfo, context));
        }
        if (resType.equals("id")) {
            elements.addAll(this.findIdDeclarations(namespace, resName));
        }
        if (elements.isEmpty() && (folderType = ResourceFolderType.getTypeByName((String)resType)) != null) {
            for (PsiFile file : this.findResourceFiles(folderType, resName, false, true)) {
                elements.add(new FileResourceElementWrapper(file));
            }
        }
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull String resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        ResourceType type;
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(40);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(41);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(42);
        }
        ResourceType resourceType2 = type = resourceType.startsWith("+") ? ResourceType.ID : ResourceType.fromClassName((String)resourceType);
        if (type == null) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(43);
            }
            return list;
        }
        List<ValueResourceInfoImpl> list = this.findValueResourceInfos(namespace, type, resourceName, distinguishDelimitersInName, searchAttrs);
        if (list == null) {
            ResourceManager.$$$reportNull$$$0(44);
        }
        return list;
    }

    @NotNull
    public List<ValueResourceInfoImpl> findValueResourceInfos(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String resourceName, boolean distinguishDelimitersInName, boolean searchAttrs) {
        if (namespace == null) {
            ResourceManager.$$$reportNull$$$0(45);
        }
        if (resourceType == null) {
            ResourceManager.$$$reportNull$$$0(46);
        }
        if (resourceName == null) {
            ResourceManager.$$$reportNull$$$0(47);
        }
        if (!(AndroidResourceUtil.VALUE_RESOURCE_TYPES.contains(resourceType) || resourceType == ResourceType.ATTR && searchAttrs)) {
            List<ValueResourceInfoImpl> list = Collections.emptyList();
            if (list == null) {
                ResourceManager.$$$reportNull$$$0(48);
            }
            return list;
        }
        ArrayList<ValueResourceInfoImpl> result2 = new ArrayList<ValueResourceInfoImpl>();
        for (ResourceRepository resourceRepository : this.getLeafResourceRepositories()) {
            List items2;
            if (distinguishDelimitersInName) {
                List items22 = resourceRepository.getResources(namespace, resourceType, resourceName);
            } else {
                items2 = resourceRepository.getResources(namespace, resourceType, item -> AndroidUtils.equal(resourceName, item.getName(), false));
            }
            for (ResourceItem item2 : items2) {
                VirtualFile file = ResourceHelper.getSourceAsVirtualFile(item2);
                if (file == null || !ResourceManager.isValueResourceFile(file)) continue;
                result2.add(new ValueResourceInfoImpl(item2, file, this.myProject));
            }
        }
        ArrayList<ValueResourceInfoImpl> arrayList = result2;
        if (arrayList == null) {
            ResourceManager.$$$reportNull$$$0(49);
        }
        return arrayList;
    }

    private static boolean isValueResourceFile(@NotNull VirtualFile file) {
        if (file == null) {
            ResourceManager.$$$reportNull$$$0(50);
        }
        return ResourceFolderType.getFolderType((String)file.getParent().getName()) == ResourceFolderType.VALUES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDirs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 32: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceFolderType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: 
            case 13: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 16: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resName";
                break;
            }
            case 33: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/ResourceManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirsByLibraryName";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourceFiles";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeafResourceRepositories";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findIdDeclarations";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findConstraintReferencedIds";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesDeclaringId";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResources";
                break;
            }
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueResourceInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processFileResources";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isResourcePublic";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResourceFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getValueResourceType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceFolderType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileResourceType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findIdDeclarations";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findConstraintReferencedIds";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFilesDeclaringId";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findIdUsagesFromFiles";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findValueResources";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "collectLazyResourceElements";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findValueResourceInfos";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isValueResourceFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 34: 
            case 43: 
            case 44: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface FileResourceProcessor {
        public void process(@NotNull VirtualFile var1, @NotNull String var2, @Nullable String var3);
    }
}

