/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.AttributeDefinitionsImpl;
import org.jetbrains.android.dom.resources.Attr;
import org.jetbrains.android.dom.resources.DeclareStyleable;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Resources;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalResourceManager
extends ResourceManager {
    private final AndroidFacet myFacet;
    private final Object myAttrDefsLock;
    @GuardedBy(value="myAttrDefsLock")
    private AttributeDefinitions myAttrDefs;

    @Nullable
    public static LocalResourceManager getInstance(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            LocalResourceManager.$$$reportNull$$$0(0);
        }
        return (facet = AndroidFacet.getInstance(module)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    @Nullable
    public static LocalResourceManager getInstance(@NotNull PsiElement element) {
        AndroidFacet facet;
        if (element == null) {
            LocalResourceManager.$$$reportNull$$$0(1);
        }
        return (facet = AndroidFacet.getInstance(element)) != null ? ModuleResourceManagers.getInstance(facet).getLocalResourceManager() : null;
    }

    public LocalResourceManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            LocalResourceManager.$$$reportNull$$$0(2);
        }
        super(facet.getModule().getProject());
        this.myAttrDefsLock = new Object();
        this.myFacet = facet;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @Override
    @NotNull
    public ResourceRepository getResourceRepository() {
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getAppResources(this.myFacet);
        if (localResourceRepository == null) {
            LocalResourceManager.$$$reportNull$$$0(3);
        }
        return localResourceRepository;
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            LocalResourceManager.$$$reportNull$$$0(4);
        }
        for (VirtualFile resDir : this.getResourceDirs()) {
            if (!dir.equals(resDir)) continue;
            return true;
        }
        for (VirtualFile dir1 : AndroidRootUtil.getResourceOverlayDirs(this.myFacet)) {
            if (!dir.equals(dir1)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        List<VirtualFile> list = ResourceFolderManager.getInstance(this.myFacet).getFolders();
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    public Multimap<String, VirtualFile> getAllResourceDirs() {
        Multimap<String, VirtualFile> multimap = ResourceRepositoryManager.getOrCreateInstance(this.myFacet).getAllResourceDirs();
        if (multimap == null) {
            LocalResourceManager.$$$reportNull$$$0(6);
        }
        return multimap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public AttributeDefinitions getAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        // MONITORENTER : object
        if (this.myAttrDefs == null) {
            FrameworkResourceManager frameworkResourceManager = ModuleResourceManagers.getInstance(this.myFacet).getFrameworkResourceManager();
            AttributeDefinitions frameworkAttributes = frameworkResourceManager == null ? null : ((ResourceManager)frameworkResourceManager).getAttributeDefinitions();
            this.myAttrDefs = AttributeDefinitionsImpl.create(frameworkAttributes, this.getResourceRepository());
        }
        AttributeDefinitions attributeDefinitions = this.myAttrDefs;
        // MONITOREXIT : object
        if (attributeDefinitions != null) return attributeDefinitions;
        LocalResourceManager.$$$reportNull$$$0(7);
        return attributeDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAttributeDefinitions() {
        Object object = this.myAttrDefsLock;
        synchronized (object) {
            this.myAttrDefs = null;
        }
    }

    @NotNull
    public List<Attr> findAttrs(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(8);
        }
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(9);
        }
        ArrayList<Attr> list = new ArrayList<Attr>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.ATTR, name);
        for (Resources root : rootElements) {
            for (Attr attr : root.getAttrs()) {
                if (!name.equals(attr.getName().getValue())) continue;
                list.add(attr);
            }
            for (DeclareStyleable styleable : root.getDeclareStyleables()) {
                for (Attr attr : styleable.getAttrs()) {
                    if (!name.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        ArrayList<Attr> arrayList = list;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public List<DeclareStyleable> findStyleables(@NotNull ResourceNamespace namespace, @NotNull String name) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(11);
        }
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(12);
        }
        ArrayList<DeclareStyleable> list = new ArrayList<DeclareStyleable>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.STYLEABLE, name);
        for (Resources root : rootElements) {
            for (DeclareStyleable styleable : root.getDeclareStyleables()) {
                if (!name.equals(styleable.getName().getValue())) continue;
                list.add(styleable);
            }
        }
        return list;
    }

    public List<Attr> findStyleableAttributesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String fieldName) {
        int prev;
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(14);
        }
        int index = fieldName.lastIndexOf(95);
        while (index >= 0 && (prev = fieldName.lastIndexOf(95, index - 1)) != -1 && !Character.isUpperCase(fieldName.charAt(prev + 1))) {
            index = prev;
        }
        if (index < 0) {
            return Collections.emptyList();
        }
        String styleableName = fieldName.substring(0, index);
        String attrName = fieldName.substring(index + 1);
        ArrayList<Attr> list = new ArrayList<Attr>();
        List<Resources> rootElements = this.loadPsiForFilesContainingResource(namespace, ResourceType.STYLEABLE, styleableName);
        for (Resources root : rootElements) {
            for (DeclareStyleable styleable : root.getDeclareStyleables()) {
                if (!styleableName.equals(styleable.getName().getValue())) continue;
                for (Attr attr : styleable.getAttrs()) {
                    if (!attrName.equals(attr.getName().getValue())) continue;
                    list.add(attr);
                }
            }
        }
        return list;
    }

    @NotNull
    private List<Resources> loadPsiForFilesContainingResource(@NotNull ResourceNamespace namespace, @NotNull ResourceType resourceType, @NotNull String name) {
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(15);
        }
        if (resourceType == null) {
            LocalResourceManager.$$$reportNull$$$0(16);
        }
        if (name == null) {
            LocalResourceManager.$$$reportNull$$$0(17);
        }
        List<Resources> list = this.getResourceRepository().getResources(namespace, resourceType, name).stream().map(item -> ResourceHelper.getSourceAsVirtualFile(item)).filter(file -> Objects.nonNull(file)).distinct().map(file -> AndroidUtils.loadDomElement(this.myProject, file, Resources.class)).filter(res -> Objects.nonNull(res)).collect(Collectors.toList());
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByField(@NotNull PsiField field2) {
        String type;
        if (field2 == null) {
            LocalResourceManager.$$$reportNull$$$0(19);
        }
        if ((type = AndroidResourceUtil.getResourceClassName(field2)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(20);
            }
            return list;
        }
        String fieldName = field2.getName();
        if (fieldName == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(21);
            }
            return list;
        }
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance((PsiElement)field2);
        if (repositoryManager == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                LocalResourceManager.$$$reportNull$$$0(22);
            }
            return list;
        }
        ResourceNamespace namespace = repositoryManager.getNamespace();
        List<PsiElement> list = this.findResourcesByFieldName(namespace, type, fieldName);
        if (list == null) {
            LocalResourceManager.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    public List<PsiElement> findResourcesByFieldName(@NotNull ResourceNamespace namespace, @NotNull String resClassName, @NotNull String fieldName) {
        ResourceFolderType folderType;
        if (namespace == null) {
            LocalResourceManager.$$$reportNull$$$0(24);
        }
        if (resClassName == null) {
            LocalResourceManager.$$$reportNull$$$0(25);
        }
        if (fieldName == null) {
            LocalResourceManager.$$$reportNull$$$0(26);
        }
        ArrayList<PsiElement> targets = new ArrayList<PsiElement>();
        if (resClassName.equals(ResourceType.ID.getName())) {
            targets.addAll(this.findIdDeclarations(namespace, fieldName));
        }
        if ((folderType = ResourceFolderType.getTypeByName((String)resClassName)) != null) {
            targets.addAll(this.findResourceFiles(folderType, fieldName, false, true));
        }
        for (ResourceElement element : this.findValueResources(namespace, resClassName, fieldName, false)) {
            targets.add((PsiElement)element.getName().getXmlAttributeValue());
        }
        if (resClassName.equals(ResourceType.ATTR.getName())) {
            for (Attr attr : this.findAttrs(namespace, fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        } else if (resClassName.equals(ResourceType.STYLEABLE.getName())) {
            for (DeclareStyleable styleable : this.findStyleables(namespace, fieldName)) {
                targets.add((PsiElement)styleable.getName().getXmlAttributeValue());
            }
            for (Attr attr : this.findStyleableAttributesByFieldName(namespace, fieldName)) {
                targets.add((PsiElement)attr.getName().getXmlAttributeValue());
            }
        }
        ArrayList<PsiElement> arrayList = targets;
        if (arrayList == null) {
            LocalResourceManager.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/resourceManagers/LocalResourceManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceRepository";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceDirs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDefinitions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttrs";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPsiForFilesContainingResource";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByField";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findResourcesByFieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isResourceDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAttrs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findStyleables";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findStyleableAttributesByFieldName";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadPsiForFilesContainingResource";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByField";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findResourcesByFieldName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

