/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.internal.util.function.TriFunction;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.repositories.RepositoriesModel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAppCompatUtil;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

abstract class MigrateToAppCompatUsageInfo
extends UsageInfo {
    MigrateToAppCompatUsageInfo(@NotNull PsiReference reference2) {
        if (reference2 == null) {
            MigrateToAppCompatUsageInfo.$$$reportNull$$$0(0);
        }
        super(reference2);
    }

    MigrateToAppCompatUsageInfo(@NotNull PsiElement element) {
        if (element == null) {
            MigrateToAppCompatUsageInfo.$$$reportNull$$$0(1);
        }
        super(element);
    }

    @Nullable
    public abstract PsiElement applyChange(@NotNull PsiMigration var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "reference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class AddGoogleRepositoryUsageInfo
    extends GradleUsageInfo {
        private final RepositoriesModel myRepositoriesModel;
        private final ProjectBuildModel myProjectBuildModel;

        public AddGoogleRepositoryUsageInfo(@NotNull ProjectBuildModel projectBuildModel, @NotNull RepositoriesModel repositoriesModel) {
            if (projectBuildModel == null) {
                AddGoogleRepositoryUsageInfo.$$$reportNull$$$0(0);
            }
            if (repositoriesModel == null) {
                AddGoogleRepositoryUsageInfo.$$$reportNull$$$0(1);
            }
            super(repositoriesModel.getPsiElement());
            this.myProjectBuildModel = projectBuildModel;
            this.myRepositoriesModel = repositoriesModel;
        }

        @Override
        @Nullable
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            if (migration == null) {
                AddGoogleRepositoryUsageInfo.$$$reportNull$$$0(2);
            }
            this.myRepositoriesModel.addGoogleMavenRepository(this.getProject());
            this.myProjectBuildModel.applyChanges();
            return this.getElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectBuildModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositoriesModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$AddGoogleRepositoryUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GradleStringUsageInfo
    extends GradleUsageInfo {
        @NotNull
        private final String myNewValue;

        public GradleStringUsageInfo(@NotNull GrLiteral element, @NotNull String newValue) {
            if (element == null) {
                GradleStringUsageInfo.$$$reportNull$$$0(0);
            }
            if (newValue == null) {
                GradleStringUsageInfo.$$$reportNull$$$0(1);
            }
            super((PsiElement)element);
            this.myNewValue = newValue;
        }

        @Override
        @Nullable
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            if (migration == null) {
                GradleStringUsageInfo.$$$reportNull$$$0(2);
            }
            if ((element = this.getElement()) == null) {
                return null;
            }
            PsiReference reference2 = element.getReference();
            if (reference2 != null) {
                reference2.handleElementRename(this.myNewValue);
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$GradleStringUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class GradleDependencyUsageInfo
    extends GradleUsageInfo {
        @NotNull
        private final TriFunction<String, String, String, String> myGetLibraryRevisionFunction;
        private final AppCompatMigrationEntry.GradleMigrationEntry mapEntry;
        private final ArtifactDependencyModel myModel;
        private final ProjectBuildModel myBuildModel;

        public GradleDependencyUsageInfo(@NotNull PsiElement element, @NotNull ProjectBuildModel buildModel, @NotNull ArtifactDependencyModel model, AppCompatMigrationEntry.GradleMigrationEntry entry, @NotNull TriFunction<String, String, String, String> versionProvider2) {
            if (element == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(0);
            }
            if (buildModel == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(1);
            }
            if (model == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(2);
            }
            if (versionProvider2 == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(3);
            }
            super(element);
            this.mapEntry = entry;
            this.myGetLibraryRevisionFunction = versionProvider2;
            this.myModel = model;
            this.myBuildModel = buildModel;
        }

        @Override
        @Nullable
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            if (migration == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(4);
            }
            if ((element = this.getElement()) == null || !element.isValid() || !element.isWritable()) {
                return null;
            }
            if (this.myModel != null && this.myBuildModel != null) {
                PsiElement modelPsi = this.myModel.getPsiElement();
                if (modelPsi != null && modelPsi.isValid()) {
                    this.myModel.enableSetThrough();
                    if (this.mapEntry instanceof AppCompatMigrationEntry.GradleDependencyMigrationEntry) {
                        AppCompatMigrationEntry.GradleDependencyMigrationEntry depEntry = (AppCompatMigrationEntry.GradleDependencyMigrationEntry)this.mapEntry;
                        String group = this.myModel.group().toString();
                        String name = this.myModel.name().toString();
                        if (group != null && group.equals(depEntry.getOldGroupName())) {
                            this.myModel.group().getResultModel().setValue(depEntry.getNewGroupName());
                        }
                        if (name != null && name.equals(depEntry.getOldArtifactName())) {
                            this.myModel.name().getResultModel().setValue(depEntry.getNewArtifactName());
                        }
                    }
                    String version2 = this.myModel.version().toString();
                    String newVersion = this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDepedencyVersionMigrationEntry ? GradleDependencyUsageInfo.getHighestVersion(version2, this.mapEntry.getNewBaseVersion()) : this.mapEntry.getNewBaseVersion();
                    if (newVersion != null) {
                        this.myModel.version().getResultModel().setValue(newVersion);
                    }
                }
                ApplicationManager.getApplication().runReadAction(this.myBuildModel::applyChanges);
                return null;
            }
            if (element instanceof GrArgumentList) {
                GrArgumentList list = (GrArgumentList)element;
                GroovyPsiElement[] expressions = list.getAllArguments();
                PsiElement group = null;
                PsiElement name = null;
                PsiElement version3 = null;
                block10: for (GroovyPsiElement expression : expressions) {
                    GrNamedArgument namedArgument;
                    String labelName;
                    if (!(expression instanceof GrNamedArgument) || (labelName = (namedArgument = (GrNamedArgument)expression).getLabelName()) == null) continue;
                    PsiElement val = PsiTreeUtil.findChildOfType((PsiElement)namedArgument, GrLiteral.class);
                    switch (labelName) {
                        case "group": {
                            group = val;
                            continue block10;
                        }
                        case "name": {
                            name = val;
                            continue block10;
                        }
                        case "version": {
                            version3 = val;
                        }
                    }
                }
                if (group == null || name == null || version3 == null) {
                    return null;
                }
                if (this.mapEntry instanceof AppCompatMigrationEntry.GradleDependencyMigrationEntry) {
                    AppCompatMigrationEntry.GradleDependencyMigrationEntry depEntry = (AppCompatMigrationEntry.GradleDependencyMigrationEntry)this.mapEntry;
                    GradleDependencyUsageInfo.renameElement(group, depEntry.getOldGroupName(), depEntry.getNewGroupName());
                    GradleDependencyUsageInfo.renameElement(name, depEntry.getOldArtifactName(), depEntry.getNewArtifactName());
                }
                if (version3.getReference() != null) {
                    String newVersion;
                    if (this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDepedencyVersionMigrationEntry) {
                        newVersion = GradleDependencyUsageInfo.getHighestVersion(version3.getText(), this.mapEntry.getNewBaseVersion());
                        if (newVersion == null) {
                            return null;
                        }
                    } else {
                        newVersion = this.mapEntry.getNewBaseVersion();
                    }
                    version3.getReference().handleElementRename((String)this.myGetLibraryRevisionFunction.apply((Object)this.mapEntry.getNewGroupName(), (Object)this.mapEntry.getNewArtifactName(), (Object)newVersion));
                }
            } else if (element.getReference() != null) {
                String newVersion;
                if (this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDepedencyVersionMigrationEntry) {
                    GradleCoordinate existingCoordinate = GradleCoordinate.parseCoordinateString((String)element.getReference().getCanonicalText());
                    newVersion = GradleDependencyUsageInfo.getHighestVersion(existingCoordinate, this.mapEntry.getNewBaseVersion());
                    if (newVersion == null) {
                        return null;
                    }
                } else {
                    newVersion = this.mapEntry.getNewBaseVersion();
                }
                PsiElement parent = element.getParent();
                if (element instanceof GrReferenceExpression && parent != null) {
                    GrLiteral newLiteral = GroovyPsiElementFactory.getInstance((Project)this.getProject()).createLiteralFromValue((Object)this.mapEntry.toCompactNotation((String)this.myGetLibraryRevisionFunction.apply((Object)this.mapEntry.getNewGroupName(), (Object)this.mapEntry.getNewArtifactName(), (Object)newVersion)));
                    parent.replace((PsiElement)newLiteral);
                } else {
                    element.getReference().handleElementRename(this.mapEntry.toCompactNotation((String)this.myGetLibraryRevisionFunction.apply((Object)this.mapEntry.getNewGroupName(), (Object)this.mapEntry.getNewArtifactName(), (Object)newVersion)));
                }
            } else if (element instanceof GrString) {
                String newVersion;
                if (this.mapEntry instanceof AppCompatMigrationEntry.UpdateGradleDepedencyVersionMigrationEntry) {
                    GradleCoordinate existingCoordinate = GradleCoordinate.parseCoordinateString((String)GrStringUtil.removeQuotes((String)element.getText()));
                    newVersion = GradleDependencyUsageInfo.getHighestVersion(existingCoordinate, this.mapEntry.getNewBaseVersion());
                    if (newVersion == null) {
                        return null;
                    }
                } else {
                    newVersion = this.mapEntry.getNewBaseVersion();
                }
                GrLiteral newLiteral = GroovyPsiElementFactory.getInstance((Project)this.getProject()).createLiteralFromValue((Object)this.mapEntry.toCompactNotation((String)this.myGetLibraryRevisionFunction.apply((Object)this.mapEntry.getNewGroupName(), (Object)this.mapEntry.getNewArtifactName(), (Object)newVersion)));
                element.replace((PsiElement)newLiteral);
            }
            return null;
        }

        @Nullable
        static String getHighestVersion(@Nullable String a, @NotNull String defaultVersion) {
            GradleCoordinate versionB;
            if (defaultVersion == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(5);
            }
            if (a == null) {
                return defaultVersion;
            }
            if (a.startsWith("$")) {
                return null;
            }
            GradleCoordinate versionA = GradleCoordinate.parseVersionOnly((String)a);
            if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(versionA, versionB = GradleCoordinate.parseVersionOnly((String)defaultVersion)) >= 0) {
                return a;
            }
            return defaultVersion;
        }

        @Nullable
        static String getHighestVersion(@Nullable GradleCoordinate coordinate, @NotNull String defaultVersion) {
            if (defaultVersion == null) {
                GradleDependencyUsageInfo.$$$reportNull$$$0(6);
            }
            if (coordinate == null) {
                return defaultVersion;
            }
            return coordinate.getVersion() != null ? GradleDependencyUsageInfo.getHighestVersion(coordinate.getVersion().toString(), defaultVersion) : defaultVersion;
        }

        private static void renameElement(PsiElement current, String oldName, String newName2) {
            String elementText = StringUtil.trimStart((String)current.getText(), (String)"'");
            elementText = StringUtil.trimEnd((String)elementText, (String)"'");
            elementText = StringUtil.trimStart((String)elementText, (String)"\"");
            if ((elementText = StringUtil.trimEnd((String)elementText, (String)"\"")).equals(oldName) && current.getReference() != null) {
                current.getReference().handleElementRename(newName2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultVersion";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$GradleDependencyUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHighestVersion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class GradleUsageInfo
    extends MigrateToAppCompatUsageInfo {
        public GradleUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                GradleUsageInfo.$$$reportNull$$$0(0);
            }
            super(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$GradleUsageInfo", "<init>"));
        }
    }

    static class ChangeXmlAttrValueUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.AttributeValueMigrationEntry myEntry;

        ChangeXmlAttrValueUsageInfo(@NotNull PsiElement element, @NotNull AppCompatMigrationEntry.AttributeValueMigrationEntry entry) {
            if (element == null) {
                ChangeXmlAttrValueUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ChangeXmlAttrValueUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            XmlAttribute currentAttr;
            if (migration == null) {
                ChangeXmlAttrValueUsageInfo.$$$reportNull$$$0(2);
            }
            if ((currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlAttribute.class, (boolean)false)) == null) {
                return null;
            }
            PsiFile file = element.getContainingFile();
            assert (file instanceof XmlFile);
            currentAttr.setValue(this.myEntry.myNewAttrValue);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeXmlAttrValueUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeXmlAttrUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.AttributeMigrationEntry myEntry;

        ChangeXmlAttrUsageInfo(@NotNull PsiElement element, @NotNull AppCompatMigrationEntry.AttributeMigrationEntry entry) {
            if (element == null) {
                ChangeXmlAttrUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ChangeXmlAttrUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            XmlAttribute currentAttr;
            if (migration == null) {
                ChangeXmlAttrUsageInfo.$$$reportNull$$$0(2);
            }
            if ((currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlAttribute.class, (boolean)false)) == null || !currentAttr.getLocalName().equals(this.myEntry.myOldAttributeName)) {
                return element;
            }
            PsiFile file = element.getContainingFile();
            assert (file instanceof XmlFile);
            if (StringUtil.isEmpty((String)this.myEntry.myNewNamespace)) {
                currentAttr.setName(this.myEntry.myNewAttributeName);
            } else {
                String prefixUsed = AndroidResourceUtil.ensureNamespaceImported((XmlFile)file, this.myEntry.myNewNamespace, null);
                currentAttr.setName(prefixUsed + ":" + this.myEntry.myNewAttributeName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeXmlAttrUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeXmlTagUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.XmlTagMigrationEntry myEntry;

        ChangeXmlTagUsageInfo(@NotNull PsiElement element, @NotNull AppCompatMigrationEntry.XmlTagMigrationEntry entry) {
            if (element == null) {
                ChangeXmlTagUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ChangeXmlTagUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            XmlTag xmlTag;
            if (migration == null) {
                ChangeXmlTagUsageInfo.$$$reportNull$$$0(2);
            }
            if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlTag.class, (boolean)false)) == null || !xmlTag.getLocalName().equals(this.myEntry.myOldTagName)) {
                return element;
            }
            PsiFile file = element.getContainingFile();
            assert (file instanceof XmlFile);
            if (!StringUtil.isEmpty((String)this.myEntry.myNewNamespace)) {
                String prefixUsed = AndroidResourceUtil.ensureNamespaceImported((XmlFile)file, this.myEntry.myNewNamespace, null);
                xmlTag.setName(prefixUsed + ":" + this.myEntry.myNewTagName);
            } else {
                xmlTag.setName(this.myEntry.myNewTagName);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeXmlTagUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ReplaceMethodUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry myEntry;

        ReplaceMethodUsageInfo(@NotNull PsiReference element, @NotNull AppCompatMigrationEntry.ReplaceMethodCallMigrationEntry entry) {
            if (element == null) {
                ReplaceMethodUsageInfo.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                ReplaceMethodUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration psiMigration) {
            PsiElement element;
            if (psiMigration == null) {
                ReplaceMethodUsageInfo.$$$reportNull$$$0(2);
            }
            if (!((element = this.getElement()) instanceof PsiReference) || !this.isValid()) {
                return null;
            }
            PsiReference reference2 = (PsiReference)element;
            PsiClass psiClass = AndroidRefactoringUtil.findOrCreateClass(this.getProject(), psiMigration, this.myEntry.myNewClassName);
            String methodFragment = this.myEntry.myNewMethodName;
            if (!(element instanceof PsiReferenceExpression) || ((PsiReferenceExpression)element).getQualifierExpression() == null) {
                return null;
            }
            PsiMethodCallExpression oldMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)reference2.getElement(), PsiMethodCallExpression.class);
            if (oldMethodCall == null) {
                return null;
            }
            PsiExpressionList argList = oldMethodCall.getArgumentList();
            PsiExpression qualifierExpression = ((PsiReferenceExpression)element).getQualifierExpression();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            String methodCallText = "Foo." + methodFragment + "()";
            PsiMethodCallExpression call = (PsiMethodCallExpression)factory.createExpressionFromText(methodCallText, null);
            PsiExpressionList newArgList = call.getArgumentList();
            PsiExpression[] prevExpressions = argList.getExpressions();
            if (prevExpressions.length == 0) {
                newArgList.add((PsiElement)qualifierExpression);
            } else {
                for (int i2 = 0; i2 < prevExpressions.length; ++i2) {
                    PsiExpression arg = prevExpressions[i2];
                    if (this.myEntry.myQualifierParamIndex == i2) {
                        newArgList.add((PsiElement)qualifierExpression);
                    }
                    newArgList.add((PsiElement)arg);
                }
            }
            ((PsiReferenceExpression)call.getMethodExpression().getQualifierExpression()).bindToElement((PsiElement)psiClass);
            return oldMethodCall.replace((PsiElement)call);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMigration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ReplaceMethodUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeCustomViewUsageInfo
    extends MigrateToAppCompatUsageInfo {
        private final String mySuggestedSuperClass;

        ChangeCustomViewUsageInfo(@NotNull PsiElement element, @NotNull String suggestedSuperClass) {
            if (element == null) {
                ChangeCustomViewUsageInfo.$$$reportNull$$$0(0);
            }
            if (suggestedSuperClass == null) {
                ChangeCustomViewUsageInfo.$$$reportNull$$$0(1);
            }
            super(element);
            this.mySuggestedSuperClass = suggestedSuperClass;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            if (migration == null) {
                ChangeCustomViewUsageInfo.$$$reportNull$$$0(2);
            }
            PsiClass psiClass = AndroidRefactoringUtil.findOrCreateClass(this.getProject(), migration, this.mySuggestedSuperClass);
            PsiElement element = this.getElement();
            assert (element != null);
            if (!element.isValid()) {
                return null;
            }
            PsiReference reference2 = element.getReference();
            if (reference2 != null) {
                return reference2.bindToElement((PsiElement)psiClass);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggestedSuperClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeCustomViewUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeThemeUsageInfo
    extends ChangeStyleUsageInfo {
        ChangeThemeUsageInfo(@NotNull XmlAttributeValue element, @NotNull String fromValue, @NotNull String toValue) {
            if (element == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(0);
            }
            if (fromValue == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(1);
            }
            if (toValue == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(2);
            }
            super((PsiElement)element, fromValue, toValue);
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            XmlAttributeValue attributeValue;
            if (migration == null) {
                ChangeThemeUsageInfo.$$$reportNull$$$0(3);
            }
            if ((attributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttributeValue.class, (boolean)false)) == null) {
                return null;
            }
            String value2 = attributeValue.getValue();
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlAttribute.class, (boolean)true);
            if (attribute != null && value2 != null && value2.equals(this.myFromValue)) {
                attribute.setValue(this.myToValue);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeThemeUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeStyleUsageInfo
    extends MigrateToAppCompatUsageInfo {
        protected final String myFromValue;
        protected final String myToValue;

        ChangeStyleUsageInfo(@NotNull PsiElement element, @NotNull String fromValue, @NotNull String toValue) {
            if (element == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(0);
            }
            if (fromValue == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(1);
            }
            if (toValue == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(2);
            }
            super(element);
            this.myFromValue = fromValue;
            this.myToValue = toValue;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            XmlAttributeValue attributeValue;
            PsiElement element;
            XmlTag tag;
            if (migration == null) {
                ChangeStyleUsageInfo.$$$reportNull$$$0(3);
            }
            if ((tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(element = this.getElement()), XmlTag.class, (boolean)false)) == null) {
                return null;
            }
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class, (boolean)false);
            XmlAttributeValue xmlAttributeValue = attributeValue = attribute == null ? null : attribute.getValueElement();
            if (attribute != null && attributeValue != null) {
                tag.setAttribute(attribute.getName(), this.myToValue);
            } else {
                XmlTagValue tagValue = tag.getValue();
                tagValue.setText(this.myToValue);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromValue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toValue";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeStyleUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class PackageMigrationUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.PackageMigrationEntry mapEntry;

        public PackageMigrationUsageInfo(@NotNull UsageInfo info, @NotNull AppCompatMigrationEntry.PackageMigrationEntry mapEntry) {
            if (info == null) {
                PackageMigrationUsageInfo.$$$reportNull$$$0(0);
            }
            if (mapEntry == null) {
                PackageMigrationUsageInfo.$$$reportNull$$$0(1);
            }
            super(info.getElement());
            this.mapEntry = mapEntry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            if (migration == null) {
                PackageMigrationUsageInfo.$$$reportNull$$$0(2);
            }
            if (this.mapEntry.myOldName.equals(this.mapEntry.myNewName)) {
                return null;
            }
            PsiPackage aPackage = AndroidRefactoringUtil.findOrCreatePackage(this.getProject(), migration, this.mapEntry.myNewName);
            PsiElement element = this.getElement();
            if (element == null || !element.isValid()) {
                return element;
            }
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                return referenceElement.bindToElement((PsiElement)aPackage);
            }
            ProperTextRange range = this.getRangeInElement();
            for (PsiReference reference2 : element.getReferences()) {
                if (reference2 == null) continue;
                if (reference2 instanceof JavaClassReference) {
                    JavaClassReference classReference = (JavaClassReference)reference2;
                    if (!classReference.getRangeInElement().equals((Object)range)) continue;
                    return classReference.bindToElement((PsiElement)aPackage);
                }
                if (reference2.getElement() instanceof XmlTag) {
                    XmlTag ref = (XmlTag)reference2.getElement();
                    String localName = ref.getLocalName();
                    if (!localName.startsWith(this.mapEntry.myOldName)) continue;
                    String newName2 = localName.replace(this.mapEntry.myOldName, this.mapEntry.myNewName);
                    ref.setName(newName2);
                    continue;
                }
                if (reference2.getElement() instanceof XmlAttributeValue) {
                    XmlAttribute attribute;
                    String oldValue;
                    PsiElement parent = reference2.getElement().getParent();
                    if (!(parent instanceof XmlAttribute) || !(oldValue = StringUtil.notNullize((String)(attribute = (XmlAttribute)parent).getValue())).startsWith(this.mapEntry.myOldName)) continue;
                    attribute.setValue(oldValue.replace(this.mapEntry.myOldName, this.mapEntry.myNewName));
                    continue;
                }
                if (!MigrateToAppCompatUtil.isKotlinSimpleNameReference(reference2) || element.getParent() == null || !element.getParent().getText().equals(this.mapEntry.myOldName)) continue;
                return reference2.bindToElement((PsiElement)aPackage);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapEntry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$PackageMigrationUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ClassMigrationUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.ClassMigrationEntry mapEntry;

        ClassMigrationUsageInfo(@NotNull UsageInfo info, @NotNull AppCompatMigrationEntry.ClassMigrationEntry mapEntry) {
            if (info == null) {
                ClassMigrationUsageInfo.$$$reportNull$$$0(0);
            }
            if (mapEntry == null) {
                ClassMigrationUsageInfo.$$$reportNull$$$0(1);
            }
            super(info.getElement());
            this.mapEntry = mapEntry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration psiMigration) {
            if (psiMigration == null) {
                ClassMigrationUsageInfo.$$$reportNull$$$0(2);
            }
            if (this.mapEntry.myOldName.equals(this.mapEntry.myNewName)) {
                return null;
            }
            PsiClass aClass = AndroidRefactoringUtil.findOrCreateClass(this.getProject(), psiMigration, this.mapEntry.myNewName);
            PsiElement element = this.getElement();
            if (element == null || !element.isValid()) {
                return element;
            }
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                return referenceElement.bindToElement((PsiElement)aClass);
            }
            if (element instanceof XmlAttributeValue) {
                XmlAttributeValue value2 = (XmlAttributeValue)element;
                XmlAttribute attribute = (XmlAttribute)value2.getParent();
                if (this.mapEntry.myOldName.equals(value2.getValue())) {
                    attribute.setValue(this.mapEntry.myNewName);
                }
            } else {
                ProperTextRange range = this.getRangeInElement();
                for (PsiReference reference2 : element.getReferences()) {
                    if (reference2 instanceof JavaClassReference) {
                        JavaClassReference classReference = (JavaClassReference)reference2;
                        if (!classReference.getRangeInElement().equals((Object)range)) continue;
                        return classReference.bindToElement((PsiElement)aClass);
                    }
                    if (reference2 != null && reference2.getElement() instanceof XmlTag) {
                        XmlTag ref = (XmlTag)reference2.getElement();
                        String localName = ref.getLocalName();
                        if (!this.mapEntry.myOldName.equals(localName)) continue;
                        ref.setName(this.mapEntry.myNewName);
                        continue;
                    }
                    if (reference2 == null || !MigrateToAppCompatUtil.isKotlinSimpleNameReference(reference2)) continue;
                    return reference2.bindToElement((PsiElement)aClass);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapEntry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMigration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ClassMigrationUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeMethodUsageInfo
    extends MigrateToAppCompatUsageInfo {
        final AppCompatMigrationEntry.MethodMigrationEntry myEntry;

        ChangeMethodUsageInfo(PsiReference ref, @NotNull AppCompatMigrationEntry.MethodMigrationEntry entry) {
            if (entry == null) {
                ChangeMethodUsageInfo.$$$reportNull$$$0(0);
            }
            super(ref);
            this.myEntry = entry;
        }

        @Override
        public PsiElement applyChange(@NotNull PsiMigration migration) {
            PsiElement element;
            if (migration == null) {
                ChangeMethodUsageInfo.$$$reportNull$$$0(1);
            }
            if ((element = this.getElement()) instanceof PsiReference && this.isValid()) {
                PsiReference reference2 = (PsiReference)element;
                String newName2 = this.myEntry.myNewMethodName;
                return reference2.handleElementRename(newName2);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "migration";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/refactoring/MigrateToAppCompatUsageInfo$ChangeMethodUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

