/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxMigrationParserKt;
import com.android.support.MigrationParserVisitor;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.refactoring.AndroidRefactoringUtil;
import org.jetbrains.android.refactoring.AppCompatMigrationEntry;
import org.jetbrains.android.refactoring.MigrateToAndroidxProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J/\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u001c\u0010!\u001a\u0004\u0018\u00010\"*\u0010\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010%0#H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\"*\u00020'H\u0002R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006("}, d2={"Lorg/jetbrains/android/refactoring/MigrateToAndroidxHandler;", "Lcom/intellij/refactoring/RefactoringActionHandler;", "showWarningDialog", "", "callSyncAfterMigration", "checkPrerequisites", "(ZZZ)V", "getCallSyncAfterMigration", "()Z", "setCallSyncAfterMigration", "(Z)V", "getCheckPrerequisites", "setCheckPrerequisites", "getShowWarningDialog", "setShowWarningDialog", "checkRefactoringPrerequisites", "project", "Lcom/intellij/openapi/project/Project;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "parseMigrationMap", "", "Lorg/jetbrains/android/refactoring/AppCompatMigrationEntry;", "findBuildSdk", "Lcom/android/sdklib/AndroidVersion;", "Lkotlin/Pair;", "Lcom/intellij/openapi/module/Module;", "Lcom/android/tools/idea/gradle/dsl/api/GradleBuildModel;", "toAndroidVersion", "", "intellij.android.core"})
public final class MigrateToAndroidxHandler
implements RefactoringActionHandler {
    private boolean showWarningDialog;
    private boolean callSyncAfterMigration;
    private boolean checkPrerequisites;

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file, @Nullable DataContext dataContext) {
        PsiElement[] psiElementArray;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (file == null) {
            psiElementArray = new PsiElement[]{};
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = (PsiElement)file;
        }
        this.invoke(project, psiElementArray, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)elements, (String)"elements");
        if (this.checkPrerequisites && !this.checkRefactoringPrerequisites(project)) {
            return;
        }
        Function0 runProcessor2 = (Function0)new Function0<Unit>(this, project){
            final /* synthetic */ MigrateToAndroidxHandler this$0;
            final /* synthetic */ Project $project;

            public final void invoke() {
                MigrateToAndroidxProcessor processor;
                MigrateToAndroidxProcessor $receiver = processor = new MigrateToAndroidxProcessor(this.$project, MigrateToAndroidxHandler.access$parseMigrationMap(this.this$0), null, this.this$0.getCallSyncAfterMigration(), 4, null);
                boolean bl = false;
                $receiver.setPreviewUsages(true);
                $receiver.run();
            }
            {
                this.this$0 = migrateToAndroidxHandler;
                this.$project = project;
                super(0);
            }
        };
        if (this.showWarningDialog) {
            AndroidRefactoringUtil.offerToCreateBackupAndRun(project, "Migrate to AndroidX", (Function0<Unit>)runProcessor2);
        } else {
            runProcessor2.invoke();
        }
    }

    private final AndroidVersion toAndroidVersion(@NotNull String $receiver) {
        return AndroidTargetHash.getPlatformVersion((String)$receiver);
    }

    private final AndroidVersion findBuildSdk(@NotNull Pair<? extends Module, ? extends GradleBuildModel> $receiver) {
        Object object = (GradleBuildModel)$receiver.getSecond();
        AndroidVersion modelVersion = object != null && (object = object.android()) != null && (object = object.compileSdkVersion()) != null && (object = object.toString()) != null ? this.toAndroidVersion((String)object) : null;
        Object object2 = modelVersion;
        if (object2 == null) {
            AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance((Module)$receiver.getFirst());
            object2 = androidModuleInfo != null ? androidModuleInfo.getBuildSdkVersion() : null;
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final boolean checkRefactoringPrerequisites(Project project) {
        boolean supportedGradleVersion;
        boolean bl;
        String gradleVersionString;
        Object object;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        void $receiver$iv$iv2;
        void $receiver$iv2;
        Iterable $receiver$iv$iv3;
        void $receiver$iv$iv$iv;
        void $receiver$iv3;
        ProjectBuildModel projectBuildModel = ProjectBuildModel.get(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectBuildModel, (String)"ProjectBuildModel.get(project)");
        ProjectBuildModel buildModel = projectBuildModel;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] moduleArray2 = moduleArray;
        void var5_4 = $receiver$iv3;
        Collection destination$iv$iv = new ArrayList();
        void var8_9 = $receiver$iv$iv$iv = $receiver$iv$iv3;
        int n = ((void)var8_9).length;
        for (int j = 0; j < n; ++j) {
            Pair pair;
            void var11_15;
            void var12_27;
            void it = var12_27 = (var11_15 = var8_9[j]);
            boolean bl2 = false;
            if (TuplesKt.to((Object)it, (Object)buildModel.getModuleBuildModel((Module)it)) == null) continue;
            Pair it$iv$iv = pair;
            destination$iv$iv.add(it$iv$iv);
        }
        List moduleModels = (List)destination$iv$iv;
        $receiver$iv$iv3 = moduleModels;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        Iterable $receiver$iv$iv$iv2 = $receiver$iv$iv2;
        Iterator iterator = $receiver$iv$iv$iv2.iterator();
        while (iterator.hasNext()) {
            AndroidVersion bl2;
            Object element$iv$iv$iv;
            Object t = element$iv$iv$iv = iterator.next();
            Pair pair = (Pair)t;
            boolean bl3 = false;
            if (this.findBuildSdk((Pair<? extends Module, ? extends GradleBuildModel>)pair) == null) continue;
            AndroidVersion it$iv$iv = bl2;
            destination$iv$iv2.add(it$iv$iv);
        }
        AndroidVersion highestCompileSdkVersion = (AndroidVersion)CollectionsKt.lastOrNull((List)CollectionsKt.sorted((Iterable)((List)destination$iv$iv2)));
        boolean supportedCompileSdk = highestCompileSdkVersion != null ? new AndroidVersion(28).compareTo(highestCompileSdkVersion) <= 0 || highestCompileSdkVersion.getCodename() != null : true;
        $receiver$iv$iv$iv2 = $receiver$iv = (Iterable)moduleModels;
        Collection destination$iv$iv3 = new ArrayList();
        void $receiver$iv$iv$iv3 = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv3.iterator();
        while (iterator2.hasNext()) {
            GradleBuildModel $i$a$1$let;
            Object t;
            Object element$iv$iv = t = iterator2.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl4 = false;
            if ((GradleBuildModel)it.getSecond() == null) continue;
            GradleBuildModel it$iv$iv = $i$a$1$let;
            destination$iv$iv3.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            GradleBuildModel gradleBuildModel = (GradleBuildModel)t;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            object = gradleBuildModel.buildscript().dependencies();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            DependenciesModel dependenciesModel = (DependenciesModel)t;
            boolean bl6 = false;
            Iterable list$iv$iv = dependenciesModel.artifacts();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList();
        for (Object t : $receiver$iv$iv) {
            ArtifactDependencyModel artifactDependencyModel = (ArtifactDependencyModel)t;
            boolean bl7 = false;
            if (!(Intrinsics.areEqual((Object)artifactDependencyModel.name().forceString(), (Object)"gradle") && Intrinsics.areEqual((Object)artifactDependencyModel.group().forceString(), (Object)"com.android.tools.build"))) continue;
            destination$iv$iv3.add(t);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            ArtifactDependencyModel artifactDependencyModel = (ArtifactDependencyModel)t;
            collection = destination$iv$iv3;
            boolean bl8 = false;
            object = artifactDependencyModel.version().getValue(GradlePropertyModel.STRING_TYPE);
            collection.add(object);
        }
        String string = gradleVersionString = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv3));
        if (string != null && !StringsKt.startsWith$default((CharSequence)string, (char)'$', (boolean)false, (int)2, null)) {
            GradleVersion gradleVersion = GradleVersion.tryParse((String)gradleVersionString);
            bl = gradleVersion != null ? gradleVersion.isAtLeastIncludingPreviews(3, 2, 0) : false;
        } else {
            bl = supportedGradleVersion = true;
        }
        if (supportedCompileSdk && supportedGradleVersion) {
            return true;
        }
        String warningContent = (!supportedCompileSdk ? "You need to have compileSdk set to at least 28 in your module build.gradle to migrate to AndroidX." : "") + (!supportedGradleVersion ? "The gradle plugin version in your project build.gradle file needs to be set to at least com.android.tools.build:gradle:3.2.0 in order to migrate to AndroidX." : "");
        Messages.showErrorDialog((String)warningContent, (String)"Unable to migrate to AndroidX");
        return false;
    }

    private final List<AppCompatMigrationEntry> parseMigrationMap() {
        List classesAndCoordinates = new ArrayList();
        List packages = new ArrayList();
        AndroidxMigrationParserKt.parseMigrationFile((MigrationParserVisitor)new MigrationParserVisitor(classesAndCoordinates, packages){
            final /* synthetic */ List $classesAndCoordinates;
            final /* synthetic */ List $packages;

            public void visitClass(@NotNull String old, @NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"new");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.ClassMigrationEntry(old, string));
            }

            public void visitPackage(@NotNull String old, @NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"new");
                this.$packages.add(new AppCompatMigrationEntry.PackageMigrationEntry(old, string));
            }

            public void visitGradleCoordinate(@NotNull String oldGroupName, @NotNull String oldArtifactName, @NotNull String newGroupName, @NotNull String newArtifactName, @NotNull String newBaseVersion) {
                Intrinsics.checkParameterIsNotNull((Object)oldGroupName, (String)"oldGroupName");
                Intrinsics.checkParameterIsNotNull((Object)oldArtifactName, (String)"oldArtifactName");
                Intrinsics.checkParameterIsNotNull((Object)newGroupName, (String)"newGroupName");
                Intrinsics.checkParameterIsNotNull((Object)newArtifactName, (String)"newArtifactName");
                Intrinsics.checkParameterIsNotNull((Object)newBaseVersion, (String)"newBaseVersion");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.GradleDependencyMigrationEntry(oldGroupName, oldArtifactName, newGroupName, newArtifactName, newBaseVersion));
            }

            public void visitGradleCoordinateUpgrade(@NotNull String groupName, @NotNull String artifactName, @NotNull String newBaseVersion) {
                Intrinsics.checkParameterIsNotNull((Object)groupName, (String)"groupName");
                Intrinsics.checkParameterIsNotNull((Object)artifactName, (String)"artifactName");
                Intrinsics.checkParameterIsNotNull((Object)newBaseVersion, (String)"newBaseVersion");
                this.$classesAndCoordinates.add(new AppCompatMigrationEntry.UpdateGradleDepedencyVersionMigrationEntry(groupName, artifactName, newBaseVersion));
            }
            {
                this.$classesAndCoordinates = $captured_local_variable$0;
                this.$packages = $captured_local_variable$1;
            }
        });
        List $receiver$iv = packages;
        if ($receiver$iv.size() > 1) {
            List list = $receiver$iv;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    AppCompatMigrationEntry.PackageMigrationEntry it = (AppCompatMigrationEntry.PackageMigrationEntry)b;
                    boolean bl = false;
                    it = (AppCompatMigrationEntry.PackageMigrationEntry)a;
                    Comparable comparable = Integer.valueOf(it.myOldName.length());
                    bl = false;
                    Integer n = it.myOldName.length();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)list, (Comparator)comparator2);
        }
        classesAndCoordinates.addAll(packages);
        return classesAndCoordinates;
    }

    public final boolean getShowWarningDialog() {
        return this.showWarningDialog;
    }

    public final void setShowWarningDialog(boolean bl) {
        this.showWarningDialog = bl;
    }

    public final boolean getCallSyncAfterMigration() {
        return this.callSyncAfterMigration;
    }

    public final void setCallSyncAfterMigration(boolean bl) {
        this.callSyncAfterMigration = bl;
    }

    public final boolean getCheckPrerequisites() {
        return this.checkPrerequisites;
    }

    public final void setCheckPrerequisites(boolean bl) {
        this.checkPrerequisites = bl;
    }

    public MigrateToAndroidxHandler(boolean showWarningDialog, boolean callSyncAfterMigration, boolean checkPrerequisites) {
        this.showWarningDialog = showWarningDialog;
        this.callSyncAfterMigration = callSyncAfterMigration;
        this.checkPrerequisites = checkPrerequisites;
    }

    public /* synthetic */ MigrateToAndroidxHandler(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        if ((n & 4) != 0) {
            bl3 = true;
        }
        this(bl, bl2, bl3);
    }

    public MigrateToAndroidxHandler() {
        this(false, false, false, 7, null);
    }

    public static final /* synthetic */ List access$parseMigrationMap(MigrateToAndroidxHandler $this) {
        return $this.parseMigrationMap();
    }
}

