/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.android.ide.common.repository.GradleCoordinate;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.SmartHashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.android.refactoring.MigrateToAppCompatUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppCompatMigrationEntry {
    public static final int CHANGE_CLASS = 1;
    public static final int CHANGE_METHOD = 2;
    public static final int CHANGE_THEME_AND_STYLE = 3;
    public static final int CHANGE_CUSTOM_VIEW_SUPERCLASS = 4;
    public static final int REPLACE_METHOD = 5;
    public static final int CHANGE_TAG = 6;
    public static final int CHANGE_ATTR = 7;
    public static final int CHANGE_ATTR_VALUE = 8;
    public static final int CHANGE_PACKAGE = 9;
    public static final int CHANGE_GRADLE_DEPENDENCY = 10;
    public static final int UPGRADE_GRADLE_DEPENDENCY_VERSION = 11;
    protected final int myType;

    public AppCompatMigrationEntry(int type) {
        this.myType = type;
    }

    public int getType() {
        return this.myType;
    }

    static class UpdateGradleDepedencyVersionMigrationEntry
    extends GradleMigrationEntry {
        public UpdateGradleDepedencyVersionMigrationEntry(@NotNull String groupName, @NotNull String artifactName, @NotNull String newBaseVersion) {
            if (groupName == null) {
                UpdateGradleDepedencyVersionMigrationEntry.$$$reportNull$$$0(0);
            }
            if (artifactName == null) {
                UpdateGradleDepedencyVersionMigrationEntry.$$$reportNull$$$0(1);
            }
            if (newBaseVersion == null) {
                UpdateGradleDepedencyVersionMigrationEntry.$$$reportNull$$$0(2);
            }
            super(11, groupName, artifactName, newBaseVersion);
        }

        @Override
        @NotNull
        public Pair<String, String> compactKey() {
            Pair pair = Pair.create((Object)this.getNewGroupName(), (Object)this.getNewArtifactName());
            if (pair == null) {
                UpdateGradleDepedencyVersionMigrationEntry.$$$reportNull$$$0(3);
            }
            return pair;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBaseVersion";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$UpdateGradleDepedencyVersionMigrationEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$UpdateGradleDepedencyVersionMigrationEntry";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compactKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class GradleDependencyMigrationEntry
    extends GradleMigrationEntry {
        @NotNull
        private final String myOldGroupName;
        @NotNull
        private final String myOldArtifactName;

        public GradleDependencyMigrationEntry(@NotNull String oldGroupName, @NotNull String oldArtifactName, @NotNull String newGroupName, @NotNull String newArtifactName, @NotNull String newBaseVersion) {
            if (oldGroupName == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(0);
            }
            if (oldArtifactName == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(1);
            }
            if (newGroupName == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(2);
            }
            if (newArtifactName == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(3);
            }
            if (newBaseVersion == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(4);
            }
            super(10, newGroupName, newArtifactName, newBaseVersion);
            this.myOldGroupName = oldGroupName;
            this.myOldArtifactName = oldArtifactName;
        }

        @Override
        @NotNull
        public Pair<String, String> compactKey() {
            Pair pair = Pair.create((Object)this.myOldGroupName, (Object)this.myOldArtifactName);
            if (pair == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(5);
            }
            return pair;
        }

        @NotNull
        public String getOldArtifactName() {
            String string = this.myOldArtifactName;
            if (string == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getOldGroupName() {
            String string = this.myOldGroupName;
            if (string == null) {
                GradleDependencyMigrationEntry.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldGroupName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldArtifactName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newGroupName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newArtifactName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBaseVersion";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$GradleDependencyMigrationEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$GradleDependencyMigrationEntry";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compactKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldArtifactName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldGroupName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class GradleMigrationEntry
    extends AppCompatMigrationEntry {
        @NotNull
        private final String myNewGroupName;
        @NotNull
        private final String myNewArtifactName;
        @NotNull
        private final String myNewBaseVersion;

        public GradleMigrationEntry(int type, @NotNull String newGroupName, @NotNull String newArtifactName, @NotNull String newBaseVersion) {
            if (newGroupName == null) {
                GradleMigrationEntry.$$$reportNull$$$0(0);
            }
            if (newArtifactName == null) {
                GradleMigrationEntry.$$$reportNull$$$0(1);
            }
            if (newBaseVersion == null) {
                GradleMigrationEntry.$$$reportNull$$$0(2);
            }
            super(type);
            this.myNewGroupName = newGroupName;
            this.myNewArtifactName = newArtifactName;
            this.myNewBaseVersion = newBaseVersion;
        }

        @NotNull
        public abstract Pair<String, String> compactKey();

        @NotNull
        public String toCompactNotation(@NotNull String withVersion) {
            GradleCoordinate baseVersion;
            if (withVersion == null) {
                GradleMigrationEntry.$$$reportNull$$$0(3);
            }
            String newVersionString = this.getNewBaseVersion();
            GradleCoordinate newVersion = GradleCoordinate.parseVersionOnly((String)withVersion);
            String useVersion = GradleCoordinate.COMPARE_PLUS_HIGHER.compare(newVersion, baseVersion = GradleCoordinate.parseVersionOnly((String)newVersionString)) < 0 ? newVersionString : withVersion;
            String string = new GradleCoordinate(this.getNewGroupName(), this.getNewArtifactName(), useVersion).toString();
            if (string == null) {
                GradleMigrationEntry.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getNewGroupName() {
            String string = this.myNewGroupName;
            if (string == null) {
                GradleMigrationEntry.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getNewArtifactName() {
            String string = this.myNewArtifactName;
            if (string == null) {
                GradleMigrationEntry.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getNewBaseVersion() {
            String string = this.myNewBaseVersion;
            if (string == null) {
                GradleMigrationEntry.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newGroupName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newArtifactName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newBaseVersion";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "withVersion";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$GradleMigrationEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$GradleMigrationEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toCompactNotation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewGroupName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewArtifactName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewBaseVersion";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "toCompactNotation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ReplaceMethodCallMigrationEntry
    extends MethodMigrationEntry {
        final int myQualifierParamIndex;

        ReplaceMethodCallMigrationEntry(String oldClassName, String oldMethodName, String newClassName, String newMethodName, int qualifierParamIndex) {
            super(5, oldClassName, oldMethodName, newClassName, newMethodName);
            this.myQualifierParamIndex = qualifierParamIndex;
        }
    }

    static class MethodMigrationEntry
    extends AppCompatMigrationEntry {
        final String myOldClassName;
        final String myOldMethodName;
        final String myNewMethodName;
        final String myNewClassName;

        MethodMigrationEntry(String oldClassName, String oldMethodName, String newClassName, String newMethodName) {
            this(2, oldClassName, oldMethodName, newClassName, newMethodName);
        }

        protected MethodMigrationEntry(int type, String oldClassName, String oldMethodName, String newClassName, String newMethodName) {
            super(type);
            this.myOldClassName = oldClassName;
            this.myOldMethodName = oldMethodName;
            this.myNewClassName = newClassName;
            this.myNewMethodName = newMethodName;
        }
    }

    static class PackageMigrationEntry
    extends AppCompatMigrationEntry {
        final String myOldName;
        final String myNewName;

        public PackageMigrationEntry(@NotNull String oldName, @NotNull String newName2) {
            if (oldName == null) {
                PackageMigrationEntry.$$$reportNull$$$0(0);
            }
            if (newName2 == null) {
                PackageMigrationEntry.$$$reportNull$$$0(1);
            }
            super(9);
            this.myOldName = oldName;
            this.myNewName = newName2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$PackageMigrationEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ClassMigrationEntry
    extends AppCompatMigrationEntry {
        final String myOldName;
        final String myNewName;

        public ClassMigrationEntry(@NotNull String oldName, @NotNull String newName2) {
            if (oldName == null) {
                ClassMigrationEntry.$$$reportNull$$$0(0);
            }
            if (newName2 == null) {
                ClassMigrationEntry.$$$reportNull$$$0(1);
            }
            super(1);
            this.myOldName = oldName;
            this.myNewName = newName2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/refactoring/AppCompatMigrationEntry$ClassMigrationEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class AttributeValueMigrationEntry
    extends XmlElementMigration {
        final String myOldAttrValue;
        final String myNewAttrValue;
        final String myAttributeName;
        final String myNamespace;
        final int myFlags;
        final Set<String> myTagNames;

        public AttributeValueMigrationEntry(String oldAttrValue, String newAttrValue, String attributeName, String namespace, int flags, String ... tagNames) {
            super(8);
            this.myOldAttrValue = oldAttrValue;
            this.myNewAttrValue = newAttrValue;
            this.myAttributeName = attributeName;
            this.myNamespace = namespace;
            this.myFlags = flags;
            this.myTagNames = new SmartHashSet(Arrays.asList(tagNames));
        }

        @Override
        public int getFlags() {
            return this.myFlags;
        }

        @Override
        public Set<String> applicableTagNames() {
            return this.myTagNames;
        }

        @Override
        public UsageInfo apply(XmlTag tag) {
            XmlAttribute attr;
            if (this.myTagNames.contains(tag.getName()) && (attr = tag.getAttribute(this.myAttributeName, this.myNamespace)) != null && StringUtil.equals((CharSequence)this.myOldAttrValue, (CharSequence)attr.getValue())) {
                return new MigrateToAppCompatUsageInfo.ChangeXmlAttrValueUsageInfo((PsiElement)attr.getValueElement(), this);
            }
            return null;
        }
    }

    static class AttributeMigrationEntry
    extends XmlElementMigration {
        final String myOldAttributeName;
        final String myNewAttributeName;
        final String myNewNamespace;
        final String myOldNamespace;
        private final int myFlags;
        private final Set<String> myTagNames;

        public AttributeMigrationEntry(String oldAttributeName, String oldNamespace, String newAttributeName, String newNamespace, int flags, String ... tagNames) {
            super(7);
            this.myOldAttributeName = oldAttributeName;
            this.myOldNamespace = oldNamespace;
            this.myNewAttributeName = newAttributeName;
            this.myNewNamespace = newNamespace;
            this.myFlags = flags;
            this.myTagNames = new SmartHashSet(Arrays.asList(tagNames));
        }

        @Override
        public int getFlags() {
            return this.myFlags;
        }

        @Override
        public Set<String> applicableTagNames() {
            return this.myTagNames;
        }

        @Override
        public UsageInfo apply(XmlTag tag) {
            XmlAttribute attr;
            if (this.myTagNames.contains(tag.getName()) && (attr = tag.getAttribute(this.myOldAttributeName, this.myOldNamespace)) != null) {
                return new MigrateToAppCompatUsageInfo.ChangeXmlAttrUsageInfo((PsiElement)attr.getNameElement(), this);
            }
            return null;
        }
    }

    static class XmlTagMigrationEntry
    extends XmlElementMigration {
        final String myOldTagName;
        final String myOldNamespace;
        final String myNewTagName;
        final String myNewNamespace;
        final int myFlags;

        public XmlTagMigrationEntry(String oldTagName, @Nullable String oldNamespace, String newTagName, @Nullable String newNamespace, int flags) {
            super(6);
            this.myOldTagName = oldTagName;
            this.myOldNamespace = oldNamespace;
            this.myNewTagName = newTagName;
            this.myNewNamespace = newNamespace;
            this.myFlags = flags;
        }

        @Override
        public int getFlags() {
            return this.myFlags;
        }

        @Override
        public Set<String> applicableTagNames() {
            return Sets.newHashSet((Object[])new String[]{this.myOldTagName});
        }

        @Override
        public UsageInfo apply(XmlTag tag) {
            if (StringUtil.equals((CharSequence)tag.getLocalName(), (CharSequence)this.myOldTagName) && StringUtil.equals((CharSequence)tag.getNamespace(), (CharSequence)this.myOldNamespace)) {
                return new MigrateToAppCompatUsageInfo.ChangeXmlTagUsageInfo((PsiElement)tag, this);
            }
            return null;
        }
    }

    static abstract class XmlElementMigration
    extends AppCompatMigrationEntry {
        public static final int FLAG_LAYOUT = 1;
        public static final int FLAG_MENU = 2;
        public static final int FLAG_STYLE = 4;

        public XmlElementMigration(int type) {
            super(type);
        }

        public abstract int getFlags();

        public abstract Set<String> applicableTagNames();

        public abstract UsageInfo apply(XmlTag var1);

        public boolean isMenuOperation() {
            return (this.getFlags() & 2) == 2;
        }

        public boolean isLayoutOperation() {
            return (this.getFlags() & 1) == 1;
        }

        public boolean isStyleOperation() {
            return (this.getFlags() & 4) == 4;
        }
    }
}

