/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/android/refactoring/AndroidResourceReferenceInCodeUsageTypeProvider;", "Lcom/intellij/usages/impl/rules/UsageTypeProvider;", "()V", "getUsageType", "Lcom/intellij/usages/impl/rules/UsageType;", "element", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.android.core"})
public final class AndroidResourceReferenceInCodeUsageTypeProvider
implements UsageTypeProvider {
    private static final UsageType RESOURCE_REFERENCE_IN_CODE;
    private static final UsageType PERMISSION_REFERENCE_IN_CODE;
    public static final Companion Companion;

    @Nullable
    public UsageType getUsageType(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psiElement = element;
        if (!(psiElement instanceof PsiReferenceExpression)) {
            psiElement = null;
        }
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement;
        if (psiReferenceExpression == null) {
            return null;
        }
        PsiReferenceExpression referenceExpression = psiReferenceExpression;
        AndroidFacet androidFacet = AndroidFacet.getInstance(element);
        if (androidFacet == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)androidFacet), (String)"AndroidFacet.getInstance(element) ?: return null");
        AndroidFacet facet = androidFacet;
        AndroidResourceUtil.MyReferredResourceFieldInfo fieldInfo = AndroidResourceUtil.getReferredResourceOrManifestField(facet, referenceExpression, false);
        return fieldInfo == null ? null : (fieldInfo.isFromManifest() ? PERMISSION_REFERENCE_IN_CODE : RESOURCE_REFERENCE_IN_CODE);
    }

    static {
        Companion = new Companion(null);
        RESOURCE_REFERENCE_IN_CODE = new UsageType("Resource reference in code");
        PERMISSION_REFERENCE_IN_CODE = new UsageType("Permission reference in code");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/android/refactoring/AndroidResourceReferenceInCodeUsageTypeProvider$Companion;", "", "()V", "PERMISSION_REFERENCE_IN_CODE", "Lcom/intellij/usages/impl/rules/UsageType;", "RESOURCE_REFERENCE_IN_CODE", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

