/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomManager;
import org.jetbrains.android.dom.converters.AndroidResourceReferenceBase;
import org.jetbrains.android.dom.layout.LayoutDomFileDescription;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.refactoring.AndroidBaseXmlRefactoringAction;
import org.jetbrains.android.refactoring.AndroidInlineTestConfig;
import org.jetbrains.android.refactoring.AndroidInlineUtil;
import org.jetbrains.android.refactoring.StyleUsageData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.android.util.ProjectBasedErrorReporter;
import org.jetbrains.annotations.NotNull;

public class AndroidInlineStyleReferenceAction
extends AndroidBaseXmlRefactoringAction {
    public static final String ACTION_ID = "AndroidInlineStyleReferenceAction";
    private final AndroidInlineTestConfig myTestConfig;

    AndroidInlineStyleReferenceAction(AndroidInlineTestConfig testConfig) {
        this.myTestConfig = testConfig;
    }

    public AndroidInlineStyleReferenceAction() {
        this.myTestConfig = null;
    }

    @Override
    protected void doRefactorForTags(@NotNull Project project, @NotNull XmlTag[] tags2) {
        DomElement domElement;
        if (project == null) {
            AndroidInlineStyleReferenceAction.$$$reportNull$$$0(0);
        }
        if (tags2 == null) {
            AndroidInlineStyleReferenceAction.$$$reportNull$$$0(1);
        }
        assert (tags2.length == 1);
        XmlTag tag = tags2[0];
        PsiFile file = tag.getContainingFile();
        if (file == null) {
            return;
        }
        StyleUsageData usageData = AndroidInlineUtil.getStyleUsageData(tag);
        if (usageData == null) {
            return;
        }
        AndroidResourceReferenceBase reference2 = usageData.getReference();
        String title = AndroidBundle.message("android.inline.style.title", new Object[0]);
        PsiElement[] styleElements = reference2.computeTargetElements();
        if (styleElements.length == 0) {
            AndroidUtils.reportError(project, "Cannot find style by reference '" + reference2.getValue() + "'", title);
            return;
        }
        if (styleElements.length > 1) {
            AndroidUtils.reportError(project, RefactoringBundle.getCannotRefactorMessage((String)"Ambiguous style reference."), title);
            return;
        }
        PsiElement styleElement = styleElements[0];
        XmlTag styleTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)styleElement, XmlTag.class);
        DomElement domElement2 = domElement = styleTag != null ? DomManager.getDomManager((Project)project).getDomElement(styleTag) : null;
        if (!(domElement instanceof Style)) {
            AndroidUtils.reportError(project, "Cannot find style by reference '" + reference2.getValue() + "'", title);
            return;
        }
        Style style = (Style)domElement;
        String styleName = style.getName().getStringValue();
        if (styleName == null) {
            AndroidUtils.reportError(project, RefactoringBundle.getCannotRefactorMessage((String)"Style name is not specified."), title);
            return;
        }
        AndroidInlineUtil.doInlineStyleDeclaration(project, new AndroidInlineUtil.MyStyleData(styleName, style, styleElement), usageData, new ProjectBasedErrorReporter(project), this.myTestConfig);
    }

    @Override
    protected boolean isEnabledForTags(@NotNull XmlTag[] tags2) {
        if (tags2 == null) {
            AndroidInlineStyleReferenceAction.$$$reportNull$$$0(2);
        }
        return tags2.length == 1 && AndroidInlineUtil.getStyleUsageData(tags2[0]) != null;
    }

    @Override
    protected boolean isMyFile(PsiFile file) {
        DomFileDescription description = DomManager.getDomManager((Project)file.getProject()).getDomFileDescription((XmlFile)file);
        return description instanceof LayoutDomFileDescription || description instanceof ResourcesDomFileDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/refactoring/AndroidInlineStyleReferenceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactorForTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledForTags";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

