/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRegisterComponentAction
extends AbstractIntentionAction
implements HighPriorityAction {
    abstract boolean isAvailable(@NotNull PsiClass var1, @NotNull Manifest var2);

    abstract void invoke(@NotNull PsiClass var1, @NotNull Manifest var2);

    public final void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) throws IncorrectOperationException {
        PsiFile manifestFile;
        Manifest manifest;
        PsiClass psiClass;
        if (project == null) {
            AbstractRegisterComponentAction.$$$reportNull$$$0(0);
        }
        PsiClass psiClass2 = psiClass = editor2 == null ? null : AbstractRegisterComponentAction.extractClass(editor2, file);
        if (psiClass == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        Manifest manifest2 = manifest = facet == null ? null : facet.getManifest();
        if (manifest == null) {
            return;
        }
        XmlElement element = manifest.getXmlElement();
        PsiFile psiFile = manifestFile = element == null ? null : element.getContainingFile();
        if (manifestFile == null) {
            return;
        }
        new WriteCommandAction.Simple(project, new PsiFile[]{file, manifestFile}){

            protected void run() throws Throwable {
                AbstractRegisterComponentAction.this.invoke(psiClass, manifest);
            }
        }.execute();
    }

    public final boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file) {
        PsiClass psiClass;
        if (project == null) {
            AbstractRegisterComponentAction.$$$reportNull$$$0(1);
        }
        PsiClass psiClass2 = psiClass = editor2 == null ? null : AbstractRegisterComponentAction.extractClass(editor2, file);
        if (psiClass == null) {
            return false;
        }
        int elementOffset = editor2.getCaretModel().getOffset();
        PsiElement lBrace = psiClass.getLBrace();
        if (lBrace == null || elementOffset >= lBrace.getTextOffset()) {
            return false;
        }
        PsiModifierList modifierList = psiClass.getModifierList();
        if (psiClass.getQualifiedName() == null || modifierList == null || !modifierList.hasExplicitModifier("public")) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return false;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null) {
            return false;
        }
        return this.isAvailable(psiClass, manifest);
    }

    @Nullable
    public static PsiClass extractClass(@Nullable Editor editor2, @Nullable PsiFile file) {
        if (editor2 == null || file == null) {
            return null;
        }
        int elementOffset = editor2.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(elementOffset);
        if (element == null) {
            return null;
        }
        return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/android/intentions/AbstractRegisterComponentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

