/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import org.jetbrains.android.dom.AndroidDomElement;
import org.jetbrains.android.dom.AndroidXmlExtension;
import org.jetbrains.android.dom.converters.AndroidPackageConverter;
import org.jetbrains.android.dom.converters.AndroidPermissionConverter;
import org.jetbrains.android.dom.converters.ConstantFieldConverter;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.dom.converters.ResourceReferenceConverter;
import org.jetbrains.android.dom.resources.DeclareStyleableNameConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidDomInspection
extends BasicDomElementsInspection<AndroidDomElement> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.AndroidDomInspection");

    public AndroidDomInspection() {
        super(AndroidDomElement.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AndroidBundle.message("android.inspections.group.name", new Object[0]);
        if (string == null) {
            AndroidDomInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = AndroidBundle.message("android.inspections.dom.name", new Object[0]);
        if (string == null) {
            AndroidDomInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("AndroidDomInspection" == null) {
            AndroidDomInspection.$$$reportNull$$$0(2);
        }
        return "AndroidDomInspection";
    }

    protected boolean shouldCheckResolveProblems(GenericDomValue value2) {
        Converter realConverter = WrappingConverter.getDeepestConverter((Converter)value2.getConverter(), (GenericDomValue)value2);
        return (!(realConverter instanceof ResourceReferenceConverter) || !AndroidDomInspection.isInTestFile(value2)) && !(realConverter instanceof AndroidPackageConverter) && !(realConverter instanceof DeclareStyleableNameConverter) && !(realConverter instanceof OnClickConverter) && !(realConverter instanceof ConstantFieldConverter) && !(realConverter instanceof AndroidPermissionConverter);
    }

    private static boolean isInTestFile(GenericDomValue value2) {
        AndroidFacet facet;
        Module module;
        VirtualFile virtualFile;
        PsiFile psiFile = value2.getXmlTag().getContainingFile();
        return psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)psiFile.getProject())) != null && (facet = AndroidFacet.getInstance(module)) != null && IdeaSourceProvider.isTestFile(facet, virtualFile);
    }

    protected void checkChildren(DomElement element, Consumer<? super DomElement> visitor) {
        XmlElement xmlElement = element.getXmlElement();
        if (xmlElement instanceof XmlTag) {
            for (DomElement child : DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true)) {
                XmlElement element1 = child.getXmlElement();
                if (element1 == null) {
                    LOG.error("No XML element for DomElement " + child + " of class " + child.getClass().getName() + "; parent=" + element);
                    continue;
                }
                if (!element1.isPhysical()) continue;
                visitor.consume((Object)child);
            }
            for (AbstractDomChildrenDescription description : element.getGenericInfo().getChildrenDescriptions()) {
                if (description.getAnnotation(Required.class) == null) continue;
                for (DomElement child : description.getValues(element)) {
                    if (child.exists()) continue;
                    String name = child.getXmlElementName();
                    String namespaceKey = child.getXmlElementNamespaceKey();
                    if (namespaceKey != null) {
                        name = namespaceKey + ':' + name;
                    }
                    if (AndroidXmlExtension.isAaptAttributeDefined((XmlTag)xmlElement, name)) continue;
                    visitor.consume((Object)child);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/android/inspections/AndroidDomInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

