/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.model.AndroidModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeaSourceProvider {
    public static Function<IdeaSourceProvider, List<VirtualFile>> MANIFEST_PROVIDER = provider -> {
        VirtualFile manifestFile = provider.getManifestFile();
        return manifestFile == null ? Collections.emptyList() : Collections.singletonList(manifestFile);
    };
    public static Function<IdeaSourceProvider, List<VirtualFile>> RES_PROVIDER = provider -> Lists.newArrayList(provider.getResDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JAVA_PROVIDER = provider -> Lists.newArrayList(provider.getJavaDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> RESOURCES_PROVIDER = provider -> Lists.newArrayList(provider.getResourcesDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> AIDL_PROVIDER = provider -> Lists.newArrayList(provider.getAidlDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_PROVIDER = provider -> Lists.newArrayList(provider.getJniDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> JNI_LIBS_PROVIDER = provider -> Lists.newArrayList(provider.getJniLibsDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> ASSETS_PROVIDER = provider -> Lists.newArrayList(provider.getAssetsDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> RENDERSCRIPT_PROVIDER = provider -> Lists.newArrayList(provider.getRenderscriptDirectories());
    public static Function<IdeaSourceProvider, List<VirtualFile>> SHADERS_PROVIDER = provider -> Lists.newArrayList(provider.getShadersDirectories());

    private IdeaSourceProvider() {
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull SourceProvider provider) {
        if (provider == null) {
            IdeaSourceProvider.$$$reportNull$$$0(0);
        }
        Gradle gradle = new Gradle(provider);
        if (gradle == null) {
            IdeaSourceProvider.$$$reportNull$$$0(1);
        }
        return gradle;
    }

    @NotNull
    private static List<IdeaSourceProvider> createAll(@NotNull List<SourceProvider> providers) {
        if (providers == null) {
            IdeaSourceProvider.$$$reportNull$$$0(2);
        }
        ArrayList ideaProviders = Lists.newArrayList();
        for (SourceProvider provider : providers) {
            ideaProviders.add(IdeaSourceProvider.create(provider));
        }
        ArrayList arrayList = ideaProviders;
        if (arrayList == null) {
            IdeaSourceProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static IdeaSourceProvider create(@NotNull AndroidFacet facet) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(4);
        }
        Legacy legacy = new Legacy(facet);
        if (legacy == null) {
            IdeaSourceProvider.$$$reportNull$$$0(5);
        }
        return legacy;
    }

    @NotNull
    public abstract String getName();

    @Nullable
    public abstract VirtualFile getManifestFile();

    @NotNull
    public abstract Collection<VirtualFile> getJavaDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getResourcesDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getAidlDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getRenderscriptDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getJniDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getJniLibsDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getResDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getAssetsDirectories();

    @NotNull
    public abstract Collection<VirtualFile> getShadersDirectories();

    @NotNull
    public static List<IdeaSourceProvider> getCurrentSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(6);
        }
        if (!facet.requiresAndroidModel()) {
            List<IdeaSourceProvider> list = Collections.singletonList(facet.getMainIdeaSourceProvider());
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null) {
            List<IdeaSourceProvider> list = IdeaSourceProvider.createAll(androidModel.getActiveSourceProviders());
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<IdeaSourceProvider> list = Collections.emptyList();
        if (list == null) {
            IdeaSourceProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public static List<IdeaSourceProvider> getCurrentTestSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(10);
        }
        if (!facet.requiresAndroidModel()) {
            List<IdeaSourceProvider> list = Collections.emptyList();
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(11);
            }
            return list;
        }
        AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
        if (androidModel != null) {
            List<IdeaSourceProvider> list = IdeaSourceProvider.createAll(androidModel.getTestSourceProviders());
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<IdeaSourceProvider> list = Collections.emptyList();
        if (list == null) {
            IdeaSourceProvider.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private Collection<VirtualFile> getAllSourceFolders() {
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(this.getJavaDirectories());
        srcDirectories.addAll(this.getResDirectories());
        srcDirectories.addAll(this.getAidlDirectories());
        srcDirectories.addAll(this.getRenderscriptDirectories());
        srcDirectories.addAll(this.getAssetsDirectories());
        srcDirectories.addAll(this.getJniDirectories());
        srcDirectories.addAll(this.getJniLibsDirectories());
        ArrayList arrayList = srcDirectories;
        if (arrayList == null) {
            IdeaSourceProvider.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<File> getAllSourceFolders(@NotNull SourceProvider provider) {
        if (provider == null) {
            IdeaSourceProvider.$$$reportNull$$$0(15);
        }
        ArrayList srcDirectories = Lists.newArrayList();
        srcDirectories.addAll(provider.getJavaDirectories());
        srcDirectories.addAll(provider.getResDirectories());
        srcDirectories.addAll(provider.getAidlDirectories());
        srcDirectories.addAll(provider.getRenderscriptDirectories());
        srcDirectories.addAll(provider.getAssetsDirectories());
        srcDirectories.addAll(provider.getCDirectories());
        srcDirectories.addAll(provider.getCppDirectories());
        srcDirectories.addAll(provider.getJniLibsDirectories());
        ArrayList arrayList = srcDirectories;
        if (arrayList == null) {
            IdeaSourceProvider.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public boolean containsFile(@NotNull VirtualFile file) {
        if (file == null) {
            IdeaSourceProvider.$$$reportNull$$$0(17);
        }
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        if (file.equals(this.getManifestFile())) {
            return true;
        }
        for (VirtualFile container : srcDirectories) {
            if (!container.exists()) continue;
            if (VfsUtilCore.isAncestor((VirtualFile)container, (VirtualFile)file, (boolean)false)) {
                return true;
            }
            if (!file.equals(container.getParent())) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainedBy(@NotNull SourceProvider provider, @NotNull File targetFolder) {
        if (provider == null) {
            IdeaSourceProvider.$$$reportNull$$$0(18);
        }
        if (targetFolder == null) {
            IdeaSourceProvider.$$$reportNull$$$0(19);
        }
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        for (File container : srcDirectories) {
            if (VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)targetFolder, (File)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsFile(@NotNull SourceProvider provider, @NotNull File file) {
        if (provider == null) {
            IdeaSourceProvider.$$$reportNull$$$0(20);
        }
        if (file == null) {
            IdeaSourceProvider.$$$reportNull$$$0(21);
        }
        Collection<File> srcDirectories = IdeaSourceProvider.getAllSourceFolders(provider);
        if (FileUtil.filesEqual((File)provider.getManifestFile(), (File)file)) {
            return true;
        }
        for (File container : srcDirectories) {
            File parent = container.getParentFile();
            if (parent != null && parent.isDirectory() && FileUtil.filesEqual((File)parent, (File)file)) {
                return true;
            }
            if (!container.exists() || !VfsUtilCore.isAncestor((File)container, (File)file, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainedBy(@NotNull VirtualFile targetFolder) {
        if (targetFolder == null) {
            IdeaSourceProvider.$$$reportNull$$$0(22);
        }
        Collection<VirtualFile> srcDirectories = this.getAllSourceFolders();
        for (VirtualFile container : srcDirectories) {
            if (!container.exists() || !VfsUtilCore.isAncestor((VirtualFile)targetFolder, (VirtualFile)container, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<SourceProvider> getAllSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(23);
        }
        if (!facet.requiresAndroidModel() || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            List<SourceProvider> list = Collections.singletonList(facet.getMainSourceProvider());
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<SourceProvider> list = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel().getAllSourceProviders();
        if (list == null) {
            IdeaSourceProvider.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public static List<IdeaSourceProvider> getAllIdeaSourceProviders(@NotNull AndroidFacet facet) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(26);
        }
        if (!facet.requiresAndroidModel() || ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() == null) {
            List<IdeaSourceProvider> list = Collections.singletonList(facet.getMainIdeaSourceProvider());
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(27);
            }
            return list;
        }
        List<IdeaSourceProvider> list = IdeaSourceProvider.createAll(IdeaSourceProvider.getAllSourceProviders(facet));
        if (list == null) {
            IdeaSourceProvider.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    public static List<IdeaSourceProvider> getIdeaSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable IdeaSourceProvider defaultIdeaSourceProvider) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(29);
        }
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getAllIdeaSourceProviders(facet)) {
                if (!provider.containsFile(targetFolder) && !provider.isContainedBy(targetFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultIdeaSourceProvider != null) {
            sourceProviderList.add(defaultIdeaSourceProvider);
        }
        ArrayList arrayList = sourceProviderList;
        if (arrayList == null) {
            IdeaSourceProvider.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @NotNull
    public static List<SourceProvider> getSourceProvidersForFile(@NotNull AndroidFacet facet, @Nullable VirtualFile targetFolder, @Nullable SourceProvider defaultSourceProvider) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(31);
        }
        ArrayList sourceProviderList = Lists.newArrayList();
        if (targetFolder != null) {
            File targetIoFolder = VfsUtilCore.virtualToIoFile((VirtualFile)targetFolder);
            for (SourceProvider provider : IdeaSourceProvider.getAllSourceProviders(facet)) {
                if (!IdeaSourceProvider.containsFile(provider, targetIoFolder) && !IdeaSourceProvider.isContainedBy(provider, targetIoFolder)) continue;
                sourceProviderList.add(provider);
            }
        }
        if (sourceProviderList.isEmpty() && defaultSourceProvider != null) {
            sourceProviderList.add(defaultSourceProvider);
        }
        ArrayList arrayList = sourceProviderList;
        if (arrayList == null) {
            IdeaSourceProvider.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    public static boolean isTestFile(@NotNull AndroidFacet facet, @NotNull VirtualFile candidate) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(33);
        }
        if (candidate == null) {
            IdeaSourceProvider.$$$reportNull$$$0(34);
        }
        for (IdeaSourceProvider sourceProvider : IdeaSourceProvider.getCurrentTestSourceProviders(facet)) {
            if (!sourceProvider.containsFile(candidate)) continue;
            return true;
        }
        return false;
    }

    public static boolean isManifestFile(@NotNull AndroidFacet facet, @NotNull VirtualFile candidate) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(35);
        }
        if (candidate == null) {
            IdeaSourceProvider.$$$reportNull$$$0(36);
        }
        if (facet.requiresAndroidModel()) {
            for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
                if (!candidate.equals(provider.getManifestFile())) continue;
                return true;
            }
            return false;
        }
        return candidate.equals(facet.getMainIdeaSourceProvider().getManifestFile());
    }

    @NotNull
    public static List<VirtualFile> getManifestFiles(@NotNull AndroidFacet facet) {
        if (facet == null) {
            IdeaSourceProvider.$$$reportNull$$$0(37);
        }
        VirtualFile main = facet.getMainIdeaSourceProvider().getManifestFile();
        if (!facet.requiresAndroidModel()) {
            List<Object> list = main != null ? Collections.singletonList(main) : Collections.emptyList();
            if (list == null) {
                IdeaSourceProvider.$$$reportNull$$$0(38);
            }
            return list;
        }
        ArrayList files2 = Lists.newArrayList();
        for (IdeaSourceProvider provider : IdeaSourceProvider.getCurrentSourceProviders(facet)) {
            VirtualFile manifest = provider.getManifestFile();
            if (manifest == null) continue;
            files2.add(manifest);
        }
        ArrayList arrayList = files2;
        if (arrayList == null) {
            IdeaSourceProvider.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/IdeaSourceProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFolder";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/IdeaSourceProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAll";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSourceProviders";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTestSourceProviders";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSourceFolders";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSourceProviders";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIdeaSourceProviders";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeaSourceProvidersForFile";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProvidersForFile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentSourceProviders";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTestSourceProviders";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAllSourceFolders";
                break;
            }
            case 17: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 18: 
            case 19: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isContainedBy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAllSourceProviders";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAllIdeaSourceProviders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getIdeaSourceProvidersForFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProvidersForFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isTestFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isManifestFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getManifestFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Legacy
    extends IdeaSourceProvider {
        @NotNull
        private final AndroidFacet myFacet;

        private Legacy(@NotNull AndroidFacet facet) {
            if (facet == null) {
                Legacy.$$$reportNull$$$0(0);
            }
            this.myFacet = facet;
        }

        @Override
        @NotNull
        public String getName() {
            if ("" == null) {
                Legacy.$$$reportNull$$$0(1);
            }
            return "";
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            Module module = this.myFacet.getModule();
            VirtualFile file = AndroidRootUtil.getFileByRelativeModulePath(module, this.myFacet.getProperties().MANIFEST_FILE_RELATIVE_PATH, true);
            if (file != null) {
                return file;
            }
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (contentRoots.length == 1) {
                return contentRoots[0].findChild("AndroidManifest.xml");
            }
            return null;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            Module module = this.myFacet.getModule();
            HashSet dirs = new HashSet();
            Collections.addAll(dirs, ModuleRootManager.getInstance((Module)module).getContentRoots());
            HashSet hashSet = dirs;
            if (hashSet == null) {
                Legacy.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                Legacy.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            VirtualFile dir = AndroidRootUtil.getAidlGenDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                Legacy.$$$reportNull$$$0(4);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            VirtualFile dir = AndroidRootUtil.getRenderscriptGenDir(this.myFacet);
            assert (dir != null);
            Set<VirtualFile> set = Collections.singleton(dir);
            if (set == null) {
                Legacy.$$$reportNull$$$0(5);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                Legacy.$$$reportNull$$$0(6);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                Legacy.$$$reportNull$$$0(7);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            String resRelPath = this.myFacet.getProperties().RES_FOLDER_RELATIVE_PATH;
            VirtualFile dir = AndroidRootUtil.getFileByRelativeModulePath(this.myFacet.getModule(), resRelPath, true);
            if (dir != null) {
                Set<VirtualFile> set = Collections.singleton(dir);
                if (set == null) {
                    Legacy.$$$reportNull$$$0(8);
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                Legacy.$$$reportNull$$$0(9);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            VirtualFile dir = AndroidRootUtil.getAssetsDir(this.myFacet);
            Set<Object> set = dir == null ? Collections.emptySet() : Collections.singleton(dir);
            if (set == null) {
                Legacy.$$$reportNull$$$0(10);
            }
            return set;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                Legacy.$$$reportNull$$$0(11);
            }
            return set;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Legacy that = (Legacy)o;
            return this.myFacet.equals((Object)that.myFacet);
        }

        public int hashCode() {
            return this.myFacet.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facet";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/facet/IdeaSourceProvider$Legacy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/facet/IdeaSourceProvider$Legacy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJavaDirectories";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourcesDirectories";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAidlDirectories";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderscriptDirectories";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJniDirectories";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJniLibsDirectories";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResDirectories";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAssetsDirectories";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShadersDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Gradle
    extends IdeaSourceProvider {
        private final SourceProvider myProvider;
        private VirtualFile myManifestFile;
        private File myManifestIoFile;

        private Gradle(@NotNull SourceProvider provider) {
            if (provider == null) {
                Gradle.$$$reportNull$$$0(0);
            }
            this.myProvider = provider;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myProvider.getName();
            if (string == null) {
                Gradle.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @Nullable
        public VirtualFile getManifestFile() {
            File manifestFile = this.myProvider.getManifestFile();
            if (this.myManifestFile == null || !FileUtil.filesEqual((File)manifestFile, (File)this.myManifestIoFile)) {
                this.myManifestIoFile = manifestFile;
                this.myManifestFile = VfsUtil.findFileByIoFile((File)manifestFile, (boolean)false);
            }
            return this.myManifestFile;
        }

        private static Collection<VirtualFile> convertFileSet(@NotNull Collection<File> fileSet) {
            if (fileSet == null) {
                Gradle.$$$reportNull$$$0(2);
            }
            ArrayList result2 = Lists.newArrayListWithCapacity((int)fileSet.size());
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (File file : fileSet) {
                VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
                if (virtualFile == null) continue;
                result2.add(virtualFile);
            }
            return result2;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJavaDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getJavaDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(3);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResourcesDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getResourcesDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAidlDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getAidlDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(5);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getRenderscriptDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getRenderscriptDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(6);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniDirectories() {
            java.util.HashSet jniDirectories = Sets.newHashSet();
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCDirectories()));
            jniDirectories.addAll(Gradle.convertFileSet(this.myProvider.getCppDirectories()));
            java.util.HashSet hashSet = jniDirectories;
            if (hashSet == null) {
                Gradle.$$$reportNull$$$0(7);
            }
            return hashSet;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getJniLibsDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getJniLibsDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(8);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getResDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getResDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(9);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getAssetsDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getAssetsDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(10);
            }
            return collection;
        }

        @Override
        @NotNull
        public Collection<VirtualFile> getShadersDirectories() {
            Collection<VirtualFile> collection = Gradle.convertFileSet(this.myProvider.getShadersDirectories());
            if (collection == null) {
                Gradle.$$$reportNull$$$0(11);
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Gradle that = (Gradle)o;
            if (!this.myProvider.getName().equals(that.getName())) {
                return false;
            }
            return this.myProvider.getManifestFile().getPath().equals(that.myProvider.getManifestFile().getPath());
        }

        public int hashCode() {
            return this.myProvider.getManifestFile().getPath().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/facet/IdeaSourceProvider$Gradle";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/facet/IdeaSourceProvider$Gradle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJavaDirectories";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResourcesDirectories";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAidlDirectories";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRenderscriptDirectories";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJniDirectories";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJniLibsDirectories";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResDirectories";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAssetsDirectories";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShadersDirectories";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convertFileSet";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

