/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import java.util.List;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidFacetType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.LegacySourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class AndroidFacet
extends Facet<AndroidFacetConfiguration> {
    public static final FacetTypeId<AndroidFacet> ID = new FacetTypeId("android");
    public static final String NAME = "Android";
    private SourceProvider myMainSourceSet;
    private IdeaSourceProvider myMainIdeaSourceSet;

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            AndroidFacet.$$$reportNull$$$0(1);
        }
        return (AndroidFacet)modelsProvider.getModifiableFacetModel(module).getFacetByType(ID);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull VirtualFile file, @NotNull Project project) {
        Module module;
        if (file == null) {
            AndroidFacet.$$$reportNull$$$0(2);
        }
        if (project == null) {
            AndroidFacet.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) == null) {
            return null;
        }
        return AndroidFacet.getInstance(module);
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull ConvertContext context) {
        if (context == null) {
            AndroidFacet.$$$reportNull$$$0(4);
        }
        return AndroidFacet.findAndroidFacet(context.getModule());
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull PsiElement element) {
        if (element == null) {
            AndroidFacet.$$$reportNull$$$0(5);
        }
        return AndroidFacet.findAndroidFacet(AndroidPsiUtils.getModuleSafely(element));
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull DomElement element) {
        if (element == null) {
            AndroidFacet.$$$reportNull$$$0(6);
        }
        return AndroidFacet.findAndroidFacet(element.getModule());
    }

    @Nullable
    private static AndroidFacet findAndroidFacet(@Nullable Module module) {
        return module != null ? AndroidFacet.getInstance(module) : null;
    }

    @Nullable
    public static AndroidFacet getInstance(@NotNull Module module) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(7);
        }
        return !module.isDisposed() ? (AndroidFacet)FacetManager.getInstance((Module)module).getFacetByType(ID) : null;
    }

    public AndroidFacet(@NotNull Module module, @NotNull String name, @NotNull AndroidFacetConfiguration configuration) {
        if (module == null) {
            AndroidFacet.$$$reportNull$$$0(8);
        }
        if (name == null) {
            AndroidFacet.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            AndroidFacet.$$$reportNull$$$0(10);
        }
        super((FacetType)AndroidFacet.getFacetType(), module, name, (FacetConfiguration)configuration, null);
        configuration.setFacet(this);
    }

    public boolean requiresAndroidModel() {
        return !this.getProperties().ALLOW_USER_CONFIGURATION && ApkFacet.getInstance(this.getModule()) == null;
    }

    @NotNull
    public SourceProvider getMainSourceProvider() {
        AndroidModel model = ((AndroidFacetConfiguration)this.getConfiguration()).getModel();
        if (model != null) {
            SourceProvider sourceProvider = model.getDefaultSourceProvider();
            if (sourceProvider == null) {
                AndroidFacet.$$$reportNull$$$0(11);
            }
            return sourceProvider;
        }
        if (this.myMainSourceSet == null) {
            this.myMainSourceSet = new LegacySourceProvider(this);
        }
        SourceProvider sourceProvider = this.myMainSourceSet;
        if (sourceProvider == null) {
            AndroidFacet.$$$reportNull$$$0(12);
        }
        return sourceProvider;
    }

    @NotNull
    public IdeaSourceProvider getMainIdeaSourceProvider() {
        if (!this.requiresAndroidModel()) {
            if (this.myMainIdeaSourceSet == null) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(this);
            }
        } else {
            SourceProvider mainSourceSet = this.getMainSourceProvider();
            if (this.myMainIdeaSourceSet == null || mainSourceSet != this.myMainSourceSet) {
                this.myMainIdeaSourceSet = IdeaSourceProvider.create(mainSourceSet);
            }
        }
        IdeaSourceProvider ideaSourceProvider = this.myMainIdeaSourceSet;
        if (ideaSourceProvider == null) {
            AndroidFacet.$$$reportNull$$$0(13);
        }
        return ideaSourceProvider;
    }

    @Deprecated
    @NotNull
    public List<VirtualFile> getAllResourceDirectories() {
        List<VirtualFile> list = ResourceFolderManager.getInstance(this).getFolders();
        if (list == null) {
            AndroidFacet.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void disposeFacet() {
        ((AndroidFacetConfiguration)this.getConfiguration()).disposeFacet();
    }

    @Nullable
    public Manifest getManifest() {
        VirtualFile manifestFile = this.getMainIdeaSourceProvider().getManifestFile();
        return manifestFile != null ? AndroidUtils.loadDomElement(this.getModule(), manifestFile, Manifest.class) : null;
    }

    @NotNull
    public static AndroidFacetType getFacetType() {
        AndroidFacetType androidFacetType = (AndroidFacetType)FacetTypeRegistry.getInstance().findFacetType(ID);
        if (androidFacetType == null) {
            AndroidFacet.$$$reportNull$$$0(15);
        }
        return androidFacetType;
    }

    @NotNull
    public JpsAndroidModuleProperties getProperties() {
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)this.getConfiguration()).getState();
        assert (state != null);
        JpsAndroidModuleProperties jpsAndroidModuleProperties = state;
        if (jpsAndroidModuleProperties == null) {
            AndroidFacet.$$$reportNull$$$0(16);
        }
        return jpsAndroidModuleProperties;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/facet/AndroidFacet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/facet/AndroidFacet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSourceProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainIdeaSourceProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllResourceDirectories";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

