/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.exportSignedPackage;

import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.instantapp.InstantApps;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SystemProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.compiler.artifact.ApkSigningSettingsForm;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizard;
import org.jetbrains.android.exportSignedPackage.ExportSignedPackageWizardStep;
import org.jetbrains.android.exportSignedPackage.GenerateSignedApkSettings;
import org.jetbrains.android.exportSignedPackage.GradleSigningInfo;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUiUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class KeystoreStep
extends ExportSignedPackageWizardStep
implements ApkSigningSettingsForm {
    public static final String MODULE_PROPERTY = "ExportedModule";
    static final String KEY_STORE_PASSWORD_KEY = "KEY_STORE_PASSWORD";
    static final String KEY_PASSWORD_KEY = "KEY_PASSWORD";
    private JPanel myContentPanel;
    private JButton myCreateKeyStoreButton;
    private JBCheckBox myExportKeysCheckBox;
    private HyperlinkLabel myGoogleAppSigningLabel;
    private JPasswordField myKeyStorePasswordField;
    private JPasswordField myKeyPasswordField;
    private TextFieldWithBrowseButton.NoPathCompletion myKeyAliasField;
    private JTextField myKeyStorePathField;
    private JButton myLoadKeyStoreButton;
    private JBCheckBox myRememberPasswordCheckBox;
    JComboBox myModuleCombo;
    private JPanel myGradlePanel;
    private HyperlinkLabel myCloseAndUpdateLink;
    private JBLabel myKeyStorePathLabel;
    private JBLabel myKeyStorePasswordLabel;
    private JBLabel myKeyAliasLabel;
    private JBLabel myKeyPasswordLabel;
    private JPanel myExportKeyPanel;
    JBLabel myExportKeyPathLabel;
    TextFieldWithBrowseButton myExportKeyPathField;
    private final ExportSignedPackageWizard myWizard;
    private final boolean myUseGradleForSigning;
    AndroidFacet mySelection;
    final List<AndroidFacet> myFacets;

    public KeystoreStep(@NotNull ExportSignedPackageWizard wizard, boolean useGradleForSigning, @NotNull List<AndroidFacet> facets) {
        if (wizard == null) {
            KeystoreStep.$$$reportNull$$$0(0);
        }
        if (facets == null) {
            KeystoreStep.$$$reportNull$$$0(1);
        }
        this.myWizard = wizard;
        this.myFacets = facets;
        this.myUseGradleForSigning = useGradleForSigning;
        this.$$$setupUI$$$();
        final Project project = wizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        this.myKeyStorePathField.setText(settings.KEY_STORE_PATH);
        this.myKeyAliasField.setText(settings.KEY_ALIAS);
        this.myRememberPasswordCheckBox.setSelected(settings.REMEMBER_PASSWORDS);
        if (settings.REMEMBER_PASSWORDS) {
            String keyPasswordKey;
            String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, settings.KEY_STORE_PATH, null);
            String password = KeystoreStep.retrievePassword(KeyStorePasswordRequestor.class, keyStorePasswordKey);
            if (password != null) {
                this.myKeyStorePasswordField.setText(password);
            }
            if ((password = KeystoreStep.retrievePassword(KeyPasswordRequestor.class, keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, settings.KEY_STORE_PATH, settings.KEY_ALIAS))) != null) {
                this.myKeyPasswordField.setText(password);
            }
        }
        this.myModuleCombo.setRenderer(new ListCellRendererWrapper<AndroidFacet>(){

            public void customize(JList list, AndroidFacet value2, int index, boolean selected, boolean hasFocus) {
                if (value2 == null) {
                    return;
                }
                Module module = value2.getModule();
                this.setText(module.getName());
                this.setIcon(ModuleType.get((Module)module).getIcon());
            }
        });
        this.myCloseAndUpdateLink.setHyperlinkText(AndroidBundle.message("android.export.package.bundle.gradle.update", new Object[0]));
        this.myCloseAndUpdateLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (DynamicAppUtils.promptUserForGradleUpdate(project)) {
                    KeystoreStep.this.myWizard.close(1);
                }
            }
        });
        this.myGradlePanel.setVisible(false);
        this.myModuleCombo.addActionListener(e -> this.updateSelection((AndroidFacet)((Object)((Object)this.myModuleCombo.getSelectedItem()))));
        this.myExportKeysCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeystoreStep.this.myExportKeyPathLabel.setVisible(KeystoreStep.this.myExportKeysCheckBox.isSelected());
                KeystoreStep.this.myExportKeyPathField.setVisible(KeystoreStep.this.myExportKeysCheckBox.isSelected());
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myExportKeyPathField.addBrowseFolderListener("Select Encrypted Key Destination Folder", null, this.myWizard.getProject(), descriptor);
        VirtualFile desktopDir = KeystoreStep.getDesktopDirectory();
        if (desktopDir != null) {
            this.myExportKeyPathField.setText(desktopDir.getPath());
        }
        AndroidUiUtil.initSigningSettingsForm(project, this);
    }

    public void _init() {
        super._init();
        boolean isBundle = this.myWizard.getTargetType().equals("bundle");
        this.updateModuleDropdown(isBundle);
        if (isBundle) {
            GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(this.myWizard.getProject());
            this.myExportKeysCheckBox.setSelected(settings.EXPORT_PRIVATE_KEY);
            this.myGoogleAppSigningLabel.setHyperlinkText("Google Play App Signing");
            this.myGoogleAppSigningLabel.setHyperlinkTarget("https://support.google.com/googleplay/android-developer/answer/7384423");
            this.myGoogleAppSigningLabel.setCursor(Cursor.getPredefinedCursor(12));
            this.myExportKeysCheckBox.setVisible(true);
            this.myGoogleAppSigningLabel.setVisible(true);
            this.myExportKeyPathLabel.setVisible(this.myExportKeysCheckBox.isVisible() && this.myExportKeysCheckBox.isSelected());
            this.myExportKeyPathField.setVisible(this.myExportKeysCheckBox.isVisible() && this.myExportKeysCheckBox.isSelected());
        } else {
            this.myExportKeysCheckBox.setVisible(false);
            this.myGoogleAppSigningLabel.setVisible(false);
            this.myExportKeyPathLabel.setVisible(false);
            this.myExportKeyPathField.setVisible(false);
        }
    }

    private void updateModuleDropdown(boolean isBundle) {
        List<AndroidFacet> facets = isBundle ? this.filteredFacets(this.myFacets) : this.myFacets;
        this.myModuleCombo.setEnabled(facets.size() > 1);
        if (!facets.isEmpty()) {
            String moduleName;
            if (this.mySelection == null && (moduleName = PropertiesComponent.getInstance((Project)this.myWizard.getProject()).getValue(MODULE_PROPERTY)) != null) {
                for (AndroidFacet facet : facets) {
                    if (!moduleName.equals(facet.getModule().getName())) continue;
                    this.mySelection = facet;
                    break;
                }
            }
            if (!facets.contains((Object)this.mySelection)) {
                this.mySelection = facets.get(0);
            }
            this.myModuleCombo.setModel(new CollectionComboBoxModel(facets, (Object)this.mySelection));
            this.updateSelection(this.mySelection);
        }
    }

    private List<AndroidFacet> filteredFacets(List<AndroidFacet> facets) {
        return facets.stream().filter(f -> !InstantApps.isInstantAppApplicationModule(f.getModule())).collect(Collectors.toList());
    }

    private void updateSelection(@Nullable AndroidFacet selectedItem) {
        this.mySelection = selectedItem;
        this.showGradleError(!this.isGradleValid(this.myWizard.getTargetType()));
    }

    private boolean isGradleValid(@Nullable String targetType) {
        if (!targetType.equals("bundle")) {
            return true;
        }
        if (this.mySelection == null) {
            return true;
        }
        return DynamicAppUtils.supportsBundleTask(this.mySelection.getModule());
    }

    private void showGradleError(boolean showError) {
        this.myKeyStorePasswordField.setVisible(!showError);
        this.myKeyPasswordField.setVisible(!showError);
        this.myKeyAliasField.setVisible(!showError);
        this.myKeyStorePathField.setVisible(!showError);
        this.myCreateKeyStoreButton.setVisible(!showError);
        this.myLoadKeyStoreButton.setVisible(!showError);
        this.myRememberPasswordCheckBox.setVisible(!showError);
        this.myKeyStorePasswordLabel.setVisible(!showError);
        this.myKeyPasswordLabel.setVisible(!showError);
        this.myKeyAliasLabel.setVisible(!showError);
        this.myKeyStorePathLabel.setVisible(!showError);
        this.myExportKeyPanel.setVisible(!showError);
        this.myExportKeyPathLabel.setVisible(!showError);
        this.myExportKeyPathField.setVisible(!showError);
        this.myGradlePanel.setVisible(showError);
    }

    private static String retrievePassword(@NotNull Class<?> primaryRequestor, @NotNull String key) {
        PasswordSafe passwordSafe;
        String password;
        if (primaryRequestor == null) {
            KeystoreStep.$$$reportNull$$$0(2);
        }
        if (key == null) {
            KeystoreStep.$$$reportNull$$$0(3);
        }
        if ((password = (passwordSafe = PasswordSafe.getInstance()).getPassword(CredentialAttributesKt.CredentialAttributes(primaryRequestor, (String)key))) == null) {
            password = passwordSafe.getPassword(CredentialAttributesKt.CredentialAttributes(KeystoreStep.class, (String)key));
        }
        return password;
    }

    private static void updateSavedPassword(@NotNull Class<?> primaryRequestor, @NotNull String key, @Nullable String value2) {
        if (primaryRequestor == null) {
            KeystoreStep.$$$reportNull$$$0(4);
        }
        if (key == null) {
            KeystoreStep.$$$reportNull$$$0(5);
        }
        PasswordSafe passwordSafe = PasswordSafe.getInstance();
        passwordSafe.set(CredentialAttributesKt.CredentialAttributes(primaryRequestor, (String)key), value2 == null ? null : new Credentials(key, value2));
        passwordSafe.set(CredentialAttributesKt.CredentialAttributes(KeystoreStep.class, (String)key), null);
    }

    static String makePasswordKey(@NotNull String prefix, @NotNull String keyStorePath, @Nullable String keyAlias2) {
        if (prefix == null) {
            KeystoreStep.$$$reportNull$$$0(6);
        }
        if (keyStorePath == null) {
            KeystoreStep.$$$reportNull$$$0(7);
        }
        return prefix + "__" + keyStorePath + (keyAlias2 != null ? "__" + keyAlias2 : "");
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myKeyStorePathField.getText().isEmpty()) {
            return this.myKeyStorePathField;
        }
        if (this.myKeyStorePasswordField.getPassword().length == 0) {
            return this.myKeyStorePasswordField;
        }
        if (this.myKeyAliasField.getText().isEmpty()) {
            return this.myKeyAliasField;
        }
        if (this.myKeyPasswordField.getPassword().length == 0) {
            return this.myKeyPasswordField;
        }
        return null;
    }

    public JComponent getComponent() {
        return this.myContentPanel;
    }

    @Override
    public String getHelpId() {
        return "reference.android.reference.extract.signed.package.specify.keystore";
    }

    @Override
    protected void commitForNext() throws CommitStepException {
        boolean rememberPasswords;
        if (!this.isGradleValid(this.myWizard.getTargetType())) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.bundle.gradle.error", new Object[0]));
        }
        String keyStoreLocation = this.myKeyStorePathField.getText().trim();
        if (keyStoreLocation.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.keystore.location.error", new Object[0]));
        }
        char[] keyStorePassword = this.myKeyStorePasswordField.getPassword();
        if (keyStorePassword.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.store.password.error", new Object[0]));
        }
        String keyAlias2 = this.myKeyAliasField.getText().trim();
        if (keyAlias2.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.alias.error", new Object[0]));
        }
        char[] keyPassword2 = this.myKeyPasswordField.getPassword();
        if (keyPassword2.length == 0) {
            throw new CommitStepException(AndroidBundle.message("android.export.package.specify.key.password.error", new Object[0]));
        }
        if (this.myUseGradleForSigning) {
            this.myWizard.setGradleSigningInfo(new GradleSigningInfo(keyStoreLocation, keyStorePassword, keyAlias2, keyPassword2));
        } else {
            KeyStore keyStore = this.loadKeyStore(new File(keyStoreLocation));
            if (keyStore == null) {
                throw new CommitStepException(AndroidBundle.message("android.export.package.keystore.error.title", new Object[0]));
            }
            this.loadKeyAndSaveToWizard(keyStore, keyAlias2, keyPassword2);
        }
        String keyFolder = this.myExportKeyPathField.getText().trim();
        if (keyFolder.isEmpty()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.missing.destination", this.myWizard.getTargetType()));
        }
        File f = new File(keyFolder);
        if (!f.isDirectory() || !f.canWrite()) {
            throw new CommitStepException(AndroidBundle.message("android.apk.sign.gradle.invalid.destination", new Object[0]));
        }
        Project project = this.myWizard.getProject();
        GenerateSignedApkSettings settings = GenerateSignedApkSettings.getInstance(project);
        settings.KEY_STORE_PATH = keyStoreLocation;
        settings.KEY_ALIAS = keyAlias2;
        settings.REMEMBER_PASSWORDS = rememberPasswords = this.myRememberPasswordCheckBox.isSelected();
        if (this.myWizard.getTargetType().equals("bundle")) {
            boolean exportPrivateKey;
            settings.EXPORT_PRIVATE_KEY = exportPrivateKey = this.myExportKeysCheckBox.isSelected();
            this.myWizard.setExportPrivateKey(exportPrivateKey);
        }
        String keyStorePasswordKey = KeystoreStep.makePasswordKey(KEY_STORE_PASSWORD_KEY, keyStoreLocation, null);
        String keyPasswordKey = KeystoreStep.makePasswordKey(KEY_PASSWORD_KEY, keyStoreLocation, keyAlias2);
        KeystoreStep.updateSavedPassword(KeyStorePasswordRequestor.class, keyStorePasswordKey, rememberPasswords ? new String(keyStorePassword) : null);
        KeystoreStep.updateSavedPassword(KeyPasswordRequestor.class, keyPasswordKey, rememberPasswords ? new String(keyPassword2) : null);
        this.myWizard.setFacet(this.getSelectedFacet());
        this.myWizard.setExportKeyPath(keyFolder);
    }

    private KeyStore loadKeyStore(File keystoreFile) throws CommitStepException {
        KeyStore keyStore;
        char[] password = this.myKeyStorePasswordField.getPassword();
        FileInputStream fis = null;
        AndroidUtils.checkPassword(password);
        if (!keystoreFile.isFile()) {
            throw new CommitStepException(AndroidBundle.message("android.cannot.find.file.error", keystoreFile.getPath()));
        }
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(keystoreFile);
            keyStore.load(fis, password);
        }
        catch (Exception e) {
            throw new CommitStepException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            Arrays.fill(password, '\u0000');
        }
        return keyStore;
    }

    private void loadKeyAndSaveToWizard(KeyStore keyStore, String alias, char[] keyPassword2) throws CommitStepException {
        KeyStore.PrivateKeyEntry entry;
        try {
            assert (keyStore != null);
            entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, new KeyStore.PasswordProtection(keyPassword2));
        }
        catch (Exception e) {
            throw new CommitStepException("Error: " + e.getMessage());
        }
        if (entry == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        PrivateKey privateKey = entry.getPrivateKey();
        Certificate certificate = entry.getCertificate();
        if (privateKey == null || certificate == null) {
            throw new CommitStepException(AndroidBundle.message("android.extract.package.cannot.find.key.error", alias));
        }
        this.myWizard.setPrivateKey(privateKey);
        this.myWizard.setCertificate((X509Certificate)certificate);
    }

    private AndroidFacet getSelectedFacet() {
        return (AndroidFacet)((Object)this.myModuleCombo.getSelectedItem());
    }

    @Override
    public JButton getLoadKeyStoreButton() {
        return this.myLoadKeyStoreButton;
    }

    @Override
    public JTextField getKeyStorePathField() {
        return this.myKeyStorePathField;
    }

    @Override
    public JPanel getPanel() {
        return this.myContentPanel;
    }

    @Override
    public JButton getCreateKeyStoreButton() {
        return this.myCreateKeyStoreButton;
    }

    @Override
    public JPasswordField getKeyStorePasswordField() {
        return this.myKeyStorePasswordField;
    }

    @Override
    public TextFieldWithBrowseButton getKeyAliasField() {
        return this.myKeyAliasField;
    }

    @Override
    public JPasswordField getKeyPasswordField() {
        return this.myKeyPasswordField;
    }

    JBCheckBox getExportKeysCheckBox() {
        return this.myExportKeysCheckBox;
    }

    @Nullable
    private static VirtualFile getDesktopDirectory() {
        String path;
        File desktop = new File(SystemProperties.getUserHome(), "Desktop");
        if (!desktop.isDirectory() && SystemInfo.hasXdgOpen() && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-user-dir", "DESKTOP"}))) != null) {
            desktop = new File(path);
        }
        return desktop.isDirectory() ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(desktop) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryRequestor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyStorePath";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/exportSignedPackage/KeystoreStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "retrievePassword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSavedPassword";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "makePasswordKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel2;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JBCheckBox jBCheckBox2;
        JButton jButton;
        JButton jButton2;
        JTextField jTextField;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JPasswordField jPasswordField;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JPasswordField jPasswordField2;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Module");
        jLabel.setDisplayedMnemonic('M');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel3.add((Component)jSeparator, new GridConstraints(1, 0, 1, 2, 0, 1, 6, 0, new Dimension(-1, 1), new Dimension(-1, 24), new Dimension(-1, 1)));
        this.myKeyStorePathLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Key store path");
        jBLabel5.setDisplayedMnemonic('K');
        jBLabel5.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyStorePasswordLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Key store password");
        jBLabel4.setDisplayedMnemonic('P');
        jBLabel4.setDisplayedMnemonicIndex(10);
        jPanel3.add((Component)jBLabel4, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyStorePasswordField = jPasswordField2 = new JPasswordField();
        jPanel3.add((Component)jPasswordField2, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyAliasLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Key alias");
        jBLabel3.setDisplayedMnemonic('E');
        jBLabel3.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jBLabel3, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Key password");
        jBLabel2.setDisplayedMnemonic('W');
        jBLabel2.setDisplayedMnemonicIndex(8);
        jPanel3.add((Component)jBLabel2, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeyPasswordField = jPasswordField = new JPasswordField();
        jPanel3.add((Component)jPasswordField, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myKeyAliasField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel3.add((Component)noPathCompletion, new GridConstraints(6, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myKeyStorePathField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myCreateKeyStoreButton = jButton2 = new JButton();
        jButton2.setText("Create new...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLoadKeyStoreButton = jButton = new JButton();
        jButton.setText("Choose existing...");
        jButton.setMnemonic('H');
        jButton.setDisplayedMnemonicIndex(1);
        jPanel4.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myRememberPasswordCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Remember passwords");
        jBCheckBox2.setMnemonic('R');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExportKeyPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(9, 1, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myExportKeysCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.bundle.key.export"));
        jPanel2.add((Component)jBCheckBox, "West");
        this.myGoogleAppSigningLabel = hyperlinkLabel2 = new HyperlinkLabel();
        hyperlinkLabel2.setIconTextGap(2);
        hyperlinkLabel2.setVisible(true);
        jPanel2.add((Component)hyperlinkLabel2, "Center");
        this.myGradlePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(false);
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setIcon(new ImageIcon(this.getClass().getResource("/studio/icons/common/warning-inline.png")));
        this.$$$loadLabelText$$$((JLabel)jBLabel6, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.export.package.bundle.gradle.error"));
        jPanel.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCloseAndUpdateLink = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setVisible(true);
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 6, 0, null, null, null, 4));
        this.myExportKeyPathLabel = jBLabel = new JBLabel();
        jBLabel.setText("Encrypted key export path");
        jPanel3.add((Component)jBLabel, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myExportKeyPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(10, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
        jBLabel5.setLabelFor(jTextField);
        jBLabel4.setLabelFor(jPasswordField2);
        jBLabel3.setLabelFor((Component)noPathCompletion);
        jBLabel2.setLabelFor(jPasswordField);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class KeyPasswordRequestor {
        private KeyPasswordRequestor() {
        }
    }

    private static class KeyStorePasswordRequestor {
        private KeyStorePasswordRequestor() {
        }
    }
}

