/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.manifest;

import com.android.builder.model.ProductFlavor;
import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStrings;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.res.aar.ProtoXmlPullParser;
import com.android.tools.idea.util.FileExtensions;
import com.android.utils.XmlUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.android.dom.manifest.CompatibleScreensScreen;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class AndroidManifestUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getPackageNameFromManifestFile(@NotNull PathString manifestFile) throws IOException {
        if (manifestFile == null) {
            AndroidManifestUtils.$$$reportNull$$$0(0);
        }
        try (InputStream stream = FileExtensions.buffered(PathStrings.inputStream((PathString)manifestFile));){
            String string = AndroidManifestUtils.getPackageName(stream);
            return string;
        }
        catch (XmlPullParserException e) {
            throw new IOException("File " + manifestFile + " has invalid format");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getPackageNameFromResApk(@NotNull ZipFile resApk) throws IOException {
        ZipEntry zipEntry;
        if (resApk == null) {
            AndroidManifestUtils.$$$reportNull$$$0(1);
        }
        if ((zipEntry = resApk.getEntry("AndroidManifest.xml")) == null) {
            throw new IOException("\"AndroidManifest.xml\" not found in " + resApk.getName());
        }
        try (BufferedInputStream stream = new BufferedInputStream(resApk.getInputStream(zipEntry));){
            String string = AndroidManifestUtils.getPackageName(stream);
            return string;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Invalid AndroidManifest.xml in " + resApk.getName());
        }
    }

    private static String getPackageName(@NotNull InputStream stream) throws XmlPullParserException, IOException {
        ProtoXmlPullParser parser;
        if (stream == null) {
            AndroidManifestUtils.$$$reportNull$$$0(2);
        }
        stream.mark(1);
        if (XmlUtils.isProtoXml((InputStream)stream)) {
            parser = new ProtoXmlPullParser();
        } else {
            parser = new KXmlParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        }
        parser.setInput(stream, null);
        if (parser.nextTag() == 2) {
            return parser.getAttributeValue(null, "package");
        }
        return null;
    }

    @Nullable
    public static String getPackageName(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            AndroidManifestUtils.$$$reportNull$$$0(3);
        }
        return (String)CachedValuesManager.getManager((Project)androidFacet.getModule().getProject()).getCachedValue((UserDataHolder)androidFacet, () -> {
            Manifest manifest = androidFacet.getManifest();
            if (manifest == null) {
                return CachedValueProvider.Result.create(null, (Object[])new Object[]{ModificationTracker.EVER_CHANGED});
            }
            String packageName = (String)manifest.getPackage().getValue();
            return CachedValueProvider.Result.create((Object)StringUtil.nullize((String)packageName, (boolean)true), (Object[])new Object[]{manifest.getXmlTag()});
        });
    }

    @Nullable
    public static String getTestPackageName(@NotNull AndroidFacet androidFacet) {
        String applicationId2;
        AndroidModuleModel moduleModel;
        if (androidFacet == null) {
            AndroidManifestUtils.$$$reportNull$$$0(4);
        }
        if ((moduleModel = AndroidModuleModel.get(androidFacet)) == null) {
            return null;
        }
        ProductFlavor flavor = moduleModel.getSelectedVariant().getMergedFlavor();
        String testApplicationId2 = flavor.getTestApplicationId();
        if (testApplicationId2 != null) {
            return testApplicationId2;
        }
        String string = applicationId2 = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).isLibraryProject() ? AndroidManifestUtils.getPackageName(androidFacet) : flavor.getApplicationId();
        if (StringUtil.isNotEmpty((String)applicationId2)) {
            return applicationId2 + ".test";
        }
        return null;
    }

    public static boolean isRequiredAttribute(@NotNull XmlName attrName, @NotNull DomElement element) {
        if (attrName == null) {
            AndroidManifestUtils.$$$reportNull$$$0(5);
        }
        if (element == null) {
            AndroidManifestUtils.$$$reportNull$$$0(6);
        }
        if (element instanceof CompatibleScreensScreen && "http://schemas.android.com/apk/res/android".equals(attrName.getNamespaceKey())) {
            String localName = attrName.getLocalName();
            return "screenSize".equals(localName) || "screenDensity".equals(localName);
        }
        return false;
    }

    @Nullable
    public static Collection<String> getCustomPermissions(@NotNull AndroidFacet androidFacet) {
        Manifest manifest;
        if (androidFacet == null) {
            AndroidManifestUtils.$$$reportNull$$$0(7);
        }
        if ((manifest = androidFacet.getManifest()) == null) {
            return null;
        }
        return manifest.getPermissions().stream().map(permission -> (String)permission.getName().getValue()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    public static Collection<String> getCustomPermissionGroups(@NotNull AndroidFacet androidFacet) {
        Manifest manifest;
        if (androidFacet == null) {
            AndroidManifestUtils.$$$reportNull$$$0(8);
        }
        if ((manifest = androidFacet.getManifest()) == null) {
            return null;
        }
        return manifest.getPermissionGroups().stream().map(group -> group.getName()).map(name -> (String)name.getValue()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private AndroidManifestUtils() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resApk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/dom/manifest/AndroidManifestUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameFromManifestFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameFromResApk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTestPackageName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRequiredAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomPermissions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomPermissionGroups";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

