/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.utils.OffsetTrackingDecodedXmlValue;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.android.dom.converters.DataBindingConverter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingVariableTypeConverter
extends DataBindingConverter {
    public String getErrorMessage(@Nullable String type, @NotNull ConvertContext context) {
        PsiTypeElement typeElement;
        if (context == null) {
            DataBindingVariableTypeConverter.$$$reportNull$$$0(0);
        }
        if ((typeElement = DataBindingVariableTypeConverter.createTypeElement(type, context)) != null) {
            PsiType unresolved = DataBindingVariableTypeConverter.findUnresolvedType(typeElement.getType());
            if (unresolved == null) {
                return null;
            }
            type = unresolved.getPresentableText();
        }
        return super.getErrorMessage(type, context);
    }

    @Override
    @Nullable
    public PsiElement fromString(@Nullable @NonNls String type, @NotNull ConvertContext context) {
        if (context == null) {
            DataBindingVariableTypeConverter.$$$reportNull$$$0(1);
        }
        if (type == null) {
            return null;
        }
        PsiElement element = super.fromString(type, context);
        if (element != null) {
            return element;
        }
        PsiTypeElement typeElement = DataBindingVariableTypeConverter.createTypeElement(type, context);
        if (typeElement != null && DataBindingVariableTypeConverter.findUnresolvedType(typeElement.getType()) != null) {
            return null;
        }
        return typeElement;
    }

    @Nullable
    private static PsiTypeElement createTypeElement(@Nullable @NonNls String type, @NotNull ConvertContext context) {
        if (context == null) {
            DataBindingVariableTypeConverter.$$$reportNull$$$0(2);
        }
        if (type == null) {
            return null;
        }
        DataBindingInfo dataBindingInfo = DataBindingVariableTypeConverter.getDataBindingInfo(context);
        if ((type = DataBindingUtil.getQualifiedType(type, dataBindingInfo, false)) == null) {
            return null;
        }
        Project project = context.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiJavaParserFacade parser = facade.getParserFacade();
        try {
            return parser.createTypeElementFromText(type, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static PsiType findUnresolvedType(@NotNull PsiType psiType) {
        if (psiType == null) {
            DataBindingVariableTypeConverter.$$$reportNull$$$0(3);
        }
        final PsiType[] result2 = new PsiType[1];
        psiType.accept((PsiTypeVisitor)new DataBindingUtil.ClassReferenceVisitor(){

            @Override
            public void visitClassReference(PsiClassReferenceType classType) {
                PsiClassType rawType;
                if (result2[0] == null && (rawType = classType.rawType()).resolve() == null) {
                    result2[0] = rawType;
                }
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<PsiElement> value2, final PsiElement element, final ConvertContext context) {
        PsiType psiType;
        assert (element instanceof XmlAttributeValue);
        XmlAttributeValue attrValue = (XmlAttributeValue)element;
        final OffsetTrackingDecodedXmlValue decodedValue = new OffsetTrackingDecodedXmlValue((CharSequence)attrValue.getValue());
        String typeStr = decodedValue.getDecodedCharacters().toString();
        final ArrayList<PsiReferenceBase.Immediate> result2 = new ArrayList<PsiReferenceBase.Immediate>();
        final int valueOffset = attrValue.getValueTextRange().getStartOffset() - attrValue.getTextRange().getStartOffset();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            psiType = parser.createTypeFromText(typeStr, null);
        }
        catch (IncorrectOperationException e) {
            if (PsiReference.EMPTY_ARRAY == null) {
                DataBindingVariableTypeConverter.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        if (psiType instanceof PsiPrimitiveType) {
            result2.add(new PsiReferenceBase.Immediate(element, true, element));
        } else {
            psiType.accept((PsiTypeVisitor)new DataBindingUtil.ClassReferenceVisitor(){

                @Override
                public void visitClassReference(PsiClassReferenceType classReference) {
                    PsiJavaCodeReferenceElement reference2 = classReference.getReference();
                    int offset = reference2.getTextRange().getStartOffset();
                    offset = decodedValue.getEncodedOffset(offset);
                    DataBindingConverter.createReferences(element, DataBindingVariableTypeConverter.getName(reference2), true, valueOffset + offset, context, result2);
                }
            });
        }
        PsiReference[] psiReferenceArray = result2.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            DataBindingVariableTypeConverter.$$$reportNull$$$0(5);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static String getName(PsiJavaCodeReferenceElement reference2) {
        return reference2.isQualified() ? reference2.getQualifiedName() : reference2.getReferenceName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/DataBindingVariableTypeConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/DataBindingVariableTypeConverter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTypeElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUnresolvedType";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

