/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceDialogUtils {
    @Nullable
    public static SourceProvider getSourceProvider(@Nullable JComboBox combo) {
        Object selectedItem;
        if (combo != null && combo.isVisible() && (selectedItem = combo.getSelectedItem()) instanceof ApiComboBoxItem) {
            return (SourceProvider)((ApiComboBoxItem)selectedItem).getData();
        }
        return null;
    }

    @Nullable
    public static PsiDirectory getResourceDirectory(@Nullable SourceProvider sourceProvider, @NotNull Module module, boolean create2) {
        VirtualFile res;
        AndroidFacet facet;
        if (module == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceProvider != null) {
            final PsiManager manager = PsiManager.getInstance((Project)module.getProject());
            for (final File file : sourceProvider.getResDirectories()) {
                PsiDirectory dir;
                if (create2 && !file.exists()) {
                    PsiDirectory dir2 = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                        public PsiDirectory compute() {
                            return DirectoryUtil.mkdirs((PsiManager)manager, (String)FileUtil.toSystemIndependentName((String)file.getPath()));
                        }
                    });
                    if (dir2 == null) continue;
                    return dir2;
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (virtualFile == null || (dir = manager.findDirectory(virtualFile)) == null) continue;
                return dir;
            }
        }
        if ((facet = AndroidFacet.getInstance(module)) != null && (res = ResourceFolderManager.getInstance(facet).getPrimaryFolder()) != null) {
            return PsiManager.getInstance((Project)module.getProject()).findDirectory(res);
        }
        return null;
    }

    public static void updateSourceSetCombo(@NotNull JComponent label, @NotNull JComboBox combo, @Nullable AndroidFacet facet) {
        if (label == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(1);
        }
        if (combo == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(2);
        }
        if (facet != null && facet.requiresAndroidModel() && ((AndroidFacetConfiguration)facet.getConfiguration()).getModel() != null) {
            List<SourceProvider> providers = IdeaSourceProvider.getAllSourceProviders(facet);
            DefaultComboBoxModel<ApiComboBoxItem<SourceProvider>> model = new DefaultComboBoxModel<ApiComboBoxItem<SourceProvider>>();
            for (SourceProvider sourceProvider : providers) {
                model.addElement(new ApiComboBoxItem<SourceProvider>(sourceProvider, sourceProvider.getName(), 0, 0));
            }
            combo.setModel(model);
            label.setVisible(true);
            combo.setVisible(true);
        } else {
            label.setVisible(false);
            combo.setVisible(false);
        }
    }

    @Nullable
    private static VirtualFile getResFolderParent(@NotNull LocalResourceManager manager, @NotNull VirtualFile file) {
        if (manager == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(3);
        }
        if (file == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(4);
        }
        for (VirtualFile current = file; current != null; current = current.getParent()) {
            if (!current.isDirectory() || !manager.isResourceDir(current)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public static PsiDirectory findResourceDirectory(@NotNull DataContext dataContext) {
        VirtualFile resFolder;
        LocalResourceManager manager;
        Module module;
        AbstractProjectViewPane pane;
        Project project;
        if (dataContext == null) {
            CreateResourceDialogUtils.$$$reportNull$$$0(5);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) != null && (pane = ProjectView.getInstance((Project)project).getCurrentProjectViewPane()) instanceof AndroidProjectViewPane) {
            return null;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (file != null && (module = (Module)LangDataKeys.MODULE.getData(dataContext)) != null && (manager = LocalResourceManager.getInstance(module)) != null && (resFolder = CreateResourceDialogUtils.getResFolderParent(manager, file)) != null) {
            return AndroidPsiUtils.getPsiDirectorySafely(module.getProject(), resFolder);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/actions/CreateResourceDialogUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getResourceDirectory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourceSetCombo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getResFolderParent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findResourceDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

