/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.xml.util.XmlTagUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.AndroidGotoRelatedProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLineMarkerProvider
implements LineMarkerProvider {
    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result2) {
        if (elements == null) {
            AndroidLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            AndroidLineMarkerProvider.$$$reportNull$$$0(1);
        }
        for (PsiElement element : elements) {
            LineMarkerInfo info = AndroidLineMarkerProvider.doGetLineMarkerInfo(element);
            if (info == null) continue;
            result2.add(info);
        }
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            AndroidLineMarkerProvider.$$$reportNull$$$0(2);
        }
        return null;
    }

    private static LineMarkerInfo doGetLineMarkerInfo(PsiElement element) {
        MyMarkerInfo info = AndroidLineMarkerProvider.getMarkerInfo(element);
        if (info == null) {
            return null;
        }
        PsiElement anchor = info.myElement;
        String tooltip = info.myTooltip;
        return new LineMarkerInfo(anchor, anchor.getTextOffset(), info.myIcon, 11, (Function)new ConstantFunction((Object)tooltip), (GutterIconNavigationHandler)new MyNavigationHandler(info));
    }

    @Nullable
    private static MyMarkerInfo getMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            AndroidLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if (!(element instanceof XmlFile) && !(element instanceof PsiJavaFile)) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return null;
        }
        if (element instanceof PsiJavaFile) {
            PsiClass aClass;
            PsiIdentifier nameIdentifier;
            PsiClass[] classes = ((PsiJavaFile)element).getClasses();
            if (classes.length == 1 && (nameIdentifier = (aClass = classes[0]).getNameIdentifier()) != null) {
                Computable<List<GotoRelatedItem>> computable = AndroidGotoRelatedProvider.getLazyItemsForClass(aClass, facet, true);
                return computable != null ? new MyMarkerInfo((PsiElement)nameIdentifier, computable, "Related XML file", AllIcons.FileTypes.Xml) : null;
            }
        } else {
            PsiElement anchor;
            XmlTag rootTag = ((XmlFile)element).getRootTag();
            Computable<List<GotoRelatedItem>> computable = AndroidGotoRelatedProvider.getLazyItemsForXmlFile((XmlFile)element, facet);
            Object object = anchor = rootTag != null ? XmlTagUtil.getStartTagNameElement((XmlTag)rootTag) : element;
            if (anchor != null) {
                return computable != null ? new MyMarkerInfo(anchor, computable, "Related context Java file", AllIcons.Nodes.Class) : null;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getMarkerInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final MyMarkerInfo myInfo;

        private MyNavigationHandler(MyMarkerInfo info) {
            this.myInfo = info;
        }

        public void navigate(MouseEvent e, PsiElement elt) {
            List<GotoRelatedItem> items2 = this.doComputeItems();
            if (items2.size() == 1) {
                items2.get(0).navigate();
            } else {
                NavigationUtil.getRelatedItemsPopup(items2, (String)"Go to Related Files").show(new RelativePoint(e));
            }
        }

        @NotNull
        public List<GotoRelatedItem> doComputeItems() {
            List<GotoRelatedItem> list = this.myInfo.compute();
            if (list == null) {
                MyNavigationHandler.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/AndroidLineMarkerProvider$MyNavigationHandler", "doComputeItems"));
        }
    }

    private static class MyMarkerInfo {
        final PsiElement myElement;
        final String myTooltip;
        final Icon myIcon;
        private final Computable<List<GotoRelatedItem>> myComputable;

        private MyMarkerInfo(@NotNull PsiElement element, @NotNull Computable<List<GotoRelatedItem>> computable, @NotNull String tooltip, @NotNull Icon icon) {
            if (element == null) {
                MyMarkerInfo.$$$reportNull$$$0(0);
            }
            if (computable == null) {
                MyMarkerInfo.$$$reportNull$$$0(1);
            }
            if (tooltip == null) {
                MyMarkerInfo.$$$reportNull$$$0(2);
            }
            if (icon == null) {
                MyMarkerInfo.$$$reportNull$$$0(3);
            }
            this.myElement = element;
            this.myComputable = computable;
            this.myTooltip = tooltip;
            this.myIcon = icon;
        }

        public List<GotoRelatedItem> compute() {
            return (List)this.myComputable.compute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "computable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tooltip";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/android/AndroidLineMarkerProvider$MyMarkerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

