/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.lang.aidl.AidlFileType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import icons.AndroidArtworkIcons;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFileTemplateProvider
implements FileTemplateGroupDescriptorFactory {
    @NonNls
    public static final String REMOTE_INTERFACE_TEMPLATE = "Remote_Interface.aidl";
    @NonNls
    public static final String ANDROID_MANIFEST_TEMPLATE = "AndroidManifest.xml";
    @NonNls
    public static final String VALUE_RESOURCE_FILE_TEMPLATE = "valueResourceFile.xml";
    @NonNls
    public static final String RESOURCE_FILE_TEMPLATE = "resourceFile.xml";
    @NonNls
    public static final String LAYOUT_RESOURCE_FILE_TEMPLATE = "layoutResourceFile.xml";
    @NonNls
    public static final String LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE = "layoutResourceFile_vertical.xml";
    @NonNls
    public static final String NAVIGATION_RESOURCE_FILE_TEMPLATE = "navigationResourceFile.xml";
    @NonNls
    public static final String ACTIVITY = "Activity.java";
    @NonNls
    public static final String FRAGMENT = "Fragment.java";
    @NonNls
    public static final String APPLICATION = "Application.java";
    @NonNls
    public static final String SERVICE = "Service.java";
    @NonNls
    public static final String BROADCAST_RECEIVER = "Broadcast_Receiver.java";
    @NonNls
    public static final String DEFAULT_PROPERTIES_TEMPLATE = "default.properties";

    public FileTemplateGroupDescriptor getFileTemplatesDescriptor() {
        FileTemplateGroupDescriptor group = new FileTemplateGroupDescriptor("Android", AndroidArtworkIcons.Icons.Android);
        group.addTemplate(new FileTemplateDescriptor(ANDROID_MANIFEST_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(VALUE_RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(LAYOUT_RESOURCE_VERTICAL_FILE_TEMPLATE, StdFileTypes.XML.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(ACTIVITY, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(FRAGMENT, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(APPLICATION, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(SERVICE, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(BROADCAST_RECEIVER, StdFileTypes.JAVA.getIcon()));
        group.addTemplate(new FileTemplateDescriptor(REMOTE_INTERFACE_TEMPLATE, AidlFileType.INSTANCE.getIcon()));
        return group;
    }

    @Nullable
    public static PsiElement createFromTemplate(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String templateName, @NotNull String fileName, @NotNull Properties properties) throws Exception {
        if (project == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(0);
        }
        if (rootDir == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(1);
        }
        if (templateName == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(4);
        }
        rootDir.refresh(false, false);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(rootDir);
        if (directory != null) {
            return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, properties);
        }
        return null;
    }

    @Nullable
    public static PsiElement createFromTemplate(@NotNull Project project, @NotNull VirtualFile rootDir, @NotNull String templateName, @NotNull String fileName) throws Exception {
        if (project == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(5);
        }
        if (rootDir == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(6);
        }
        if (templateName == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(8);
        }
        return AndroidFileTemplateProvider.createFromTemplate(project, rootDir, templateName, fileName, FileTemplateManager.getInstance((Project)project).getDefaultProperties());
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, @NotNull PsiDirectory directory, Properties properties) throws Exception {
        if (directory == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(9);
        }
        FileTemplateManager manager = FileTemplateManager.getInstance((Project)directory.getProject());
        FileTemplate template = manager.getJ2eeTemplate(templateName);
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)properties, (PsiDirectory)directory);
    }

    public static PsiElement createFromTemplate(String templateName, String fileName, @NotNull PsiDirectory directory) throws Exception {
        if (directory == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(10);
        }
        return AndroidFileTemplateProvider.createFromTemplate(templateName, fileName, directory, FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties());
    }

    @NotNull
    public static String getFileNameByNewElementName(@NotNull String name) {
        if (name == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(11);
        }
        if (!FileUtilRt.extensionEquals((String)name, (String)"xml")) {
            name = name + ".xml";
        }
        String string = name;
        if (string == null) {
            AndroidFileTemplateProvider.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/AndroidFileTemplateProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/AndroidFileTemplateProvider";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameByNewElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameByNewElementName";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

