/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.awt.Color;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidColorAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        ResourceType type;
        AndroidPsiUtils.ResourceReferenceType referenceType;
        if (element == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof XmlTag) {
            XmlTag tag = (XmlTag)element;
            String tagName = tag.getName();
            if (ResourceType.COLOR.getName().equals(tagName) || ResourceType.DRAWABLE.getName().equals(tagName) || ResourceType.MIPMAP.getName().equals(tagName)) {
                DomElement domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag);
                if (domElement instanceof ResourceElement || ApplicationManager.getApplication().isUnitTestMode()) {
                    String value2 = tag.getValue().getText().trim();
                    AndroidColorAnnotator.annotateXml(element, holder, value2);
                }
            } else if ("item".equals(tagName)) {
                XmlTagValue value3 = tag.getValue();
                String text = value3.getText();
                AndroidColorAnnotator.annotateXml(element, holder, text);
            }
        } else if (element instanceof XmlAttributeValue) {
            XmlAttributeValue v = (XmlAttributeValue)element;
            String value4 = v.getValue();
            if (value4 == null || value4.isEmpty()) {
                return;
            }
            AndroidColorAnnotator.annotateXml(element, holder, value4);
        } else if (element instanceof PsiReferenceExpression && (referenceType = AndroidPsiUtils.getResourceReferenceType(element)) != AndroidPsiUtils.ResourceReferenceType.NONE && ((type = AndroidPsiUtils.getResourceType(element)) == ResourceType.COLOR || type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP)) {
            String name = AndroidPsiUtils.getResourceName(element);
            AndroidColorAnnotator.annotateResourceReference(type, holder, element, name, referenceType == AndroidPsiUtils.ResourceReferenceType.FRAMEWORK);
        }
    }

    private static void annotateXml(PsiElement element, AnnotationHolder holder, String value2) {
        if (value2.startsWith("#")) {
            PsiFile file = element.getContainingFile();
            if (file != null && AndroidResourceUtil.isInResourceSubdirectory(file, null)) {
                if (element instanceof XmlTag) {
                    Annotation annotation = holder.createInfoAnnotation(element, null);
                    annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, null));
                } else {
                    assert (element instanceof XmlAttributeValue);
                    Color color = ResourceHelper.parseColor(value2);
                    if (color != null) {
                        Annotation annotation = holder.createInfoAnnotation(element, null);
                        annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, null));
                    }
                }
            }
        } else if (value2.startsWith("@color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value2.substring("@color/".length()), false);
        } else if (value2.startsWith("@android:color/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.COLOR, holder, element, value2.substring("@android:color/".length()), true);
        } else if (value2.startsWith("@drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value2.substring("@drawable/".length()), false);
        } else if (value2.startsWith("@android:drawable/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.DRAWABLE, holder, element, value2.substring("@android:drawable/".length()), true);
        } else if (value2.startsWith("@mipmap/")) {
            AndroidColorAnnotator.annotateResourceReference(ResourceType.MIPMAP, holder, element, value2.substring("@mipmap/".length()), false);
        }
    }

    private static void annotateResourceReference(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull String name, boolean isFramework) {
        ResourceResolver resourceResolver;
        Module module;
        if (type == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(3);
        }
        if (element == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(4);
        }
        if (name == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return;
        }
        PsiFile file = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)element, PsiFile.class);
        if (file == null) {
            return;
        }
        Configuration configuration = AndroidAnnotatorUtil.pickConfiguration(facet, module, file);
        if (configuration == null) {
            return;
        }
        ResourceValue value2 = AndroidAnnotatorUtil.findResourceValue(type, name, isFramework, module, configuration);
        if (value2 != null && (resourceResolver = configuration.getResourceResolver()) != null) {
            AndroidColorAnnotator.annotateResourceValue(type, holder, element, value2, resourceResolver, facet);
        }
    }

    private static void annotateResourceValue(@NotNull ResourceType type, @NotNull AnnotationHolder holder, @NotNull PsiElement element, @NotNull ResourceValue value2, @NotNull ResourceResolver resourceResolver, @NotNull AndroidFacet facet) {
        if (type == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(7);
        }
        if (element == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(9);
        }
        if (resourceResolver == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(10);
        }
        if (facet == null) {
            AndroidColorAnnotator.$$$reportNull$$$0(11);
        }
        Project project = element.getProject();
        if (type == ResourceType.COLOR) {
            Color color = ResourceHelper.resolveColor((RenderResources)resourceResolver, value2, project);
            if (color != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new AndroidAnnotatorUtil.ColorRenderer(element, color));
            }
        } else {
            VirtualFile iconFile;
            assert (type == ResourceType.DRAWABLE || type == ResourceType.MIPMAP);
            VirtualFile file = ResourceHelper.resolveDrawable((RenderResources)resourceResolver, value2, project);
            if (file != null && file.getPath().endsWith(".xml")) {
                file = AndroidAnnotatorUtil.pickBitmapFromXml(file, resourceResolver, project, facet, value2);
            }
            if ((iconFile = AndroidAnnotatorUtil.pickBestBitmap(file)) != null) {
                Annotation annotation = holder.createInfoAnnotation(element, null);
                annotation.setGutterIconRenderer((GutterIconRenderer)new com.android.tools.idea.rendering.GutterIconRenderer(resourceResolver, element, iconFile));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceResolver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/android/AndroidColorAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateResourceReference";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateResourceValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

