/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.model;

import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.InvalidationListener;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.ObservableOptional;
import com.android.tools.idea.observable.expressions.bool.BooleanExpression;
import com.android.tools.idea.observable.expressions.bool.BooleanExpressions;
import com.android.tools.idea.observable.ui.EnabledProperty;
import com.android.tools.idea.observable.ui.VisibleProperty;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModelWizardDialog
extends DialogWrapper
implements ModelWizard.WizardListener {
    private CancellationPolicy myCancellationPolicy;
    @NotNull
    private ModelWizard myWizard;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    @Nullable
    private CustomLayout myCustomLayout;
    @Nullable
    private URL myHelpUrl;

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{new StepActionWrapper()};
        if (actionArray == null) {
            ModelWizardDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard, @NotNull String title, @Nullable CustomLayout customLayout, @Nullable Project project, @Nullable URL helpUrl, @NotNull DialogWrapper.IdeModalityType modalityType, @NotNull CancellationPolicy cancellationPolicy) {
        if (wizard == null) {
            ModelWizardDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ModelWizardDialog.$$$reportNull$$$0(2);
        }
        if (modalityType == null) {
            ModelWizardDialog.$$$reportNull$$$0(3);
        }
        if (cancellationPolicy == null) {
            ModelWizardDialog.$$$reportNull$$$0(4);
        }
        super(project, true, modalityType);
        this.myCancellationPolicy = CancellationPolicy.ALWAYS_CAN_CANCEL;
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.init(wizard, title, customLayout, helpUrl, cancellationPolicy);
    }

    public ModelWizardDialog(@NotNull ModelWizard wizard, @NotNull String title, @NotNull Component parent, @Nullable CustomLayout customLayout, @Nullable URL helpUrl, @NotNull CancellationPolicy cancellationPolicy) {
        if (wizard == null) {
            ModelWizardDialog.$$$reportNull$$$0(5);
        }
        if (title == null) {
            ModelWizardDialog.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            ModelWizardDialog.$$$reportNull$$$0(7);
        }
        if (cancellationPolicy == null) {
            ModelWizardDialog.$$$reportNull$$$0(8);
        }
        super(parent, true);
        this.myCancellationPolicy = CancellationPolicy.ALWAYS_CAN_CANCEL;
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.init(wizard, title, customLayout, helpUrl, cancellationPolicy);
    }

    private void init(@NotNull ModelWizard wizard, @NotNull String title, @Nullable CustomLayout customLayout, @Nullable URL helpUrl, @NotNull CancellationPolicy cancellationPolicy) {
        if (wizard == null) {
            ModelWizardDialog.$$$reportNull$$$0(9);
        }
        if (title == null) {
            ModelWizardDialog.$$$reportNull$$$0(10);
        }
        if (cancellationPolicy == null) {
            ModelWizardDialog.$$$reportNull$$$0(11);
        }
        Disposer.register((Disposable)this.getDisposable(), (Disposable)wizard);
        this.myWizard = wizard;
        this.myWizard.addResultListener(this);
        this.myCustomLayout = customLayout;
        this.myHelpUrl = helpUrl;
        this.myCancellationPolicy = cancellationPolicy;
        this.setTitle(title);
        this.init();
        if (customLayout != null) {
            Disposer.register((Disposable)wizard, (Disposable)customLayout);
        }
    }

    protected void dispose() {
        super.dispose();
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
        this.myWizard.removeResultListener(this);
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            ModelWizardDialog.$$$reportNull$$$0(12);
        }
        return dialogStyle;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel wizardContent = this.myWizard.getContentPanel();
        JPanel jPanel = this.myCustomLayout == null ? wizardContent : this.myCustomLayout.decorate(this.myWizard.getTitleHeader(), wizardContent);
        if (jPanel == null) {
            ModelWizardDialog.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    protected void doHelpAction() {
        if (this.getHelpAction().isEnabled()) {
            assert (this.myHelpUrl != null);
            BrowserUtil.browse((URL)this.myHelpUrl);
        }
    }

    public void doCancelAction() {
        this.myWizard.cancel();
    }

    public void doOKAction() {
    }

    @Override
    public void onWizardFinished(@NotNull ModelWizard.WizardResult result2) {
        if (result2 == null) {
            ModelWizardDialog.$$$reportNull$$$0(14);
        }
        if (result2.isFinished()) {
            super.doOKAction();
        } else {
            super.doCancelAction();
        }
    }

    @Override
    public void onWizardAdvanceError(@NotNull Exception e) {
        if (e == null) {
            ModelWizardDialog.$$$reportNull$$$0(15);
        }
        DialogEarthquakeShaker.shake((Window)this.getWindow());
    }

    @NotNull
    protected Action[] createActions() {
        NextAction nextAction = new NextAction();
        PreviousAction prevAction = new PreviousAction();
        FinishAction finishAction = new FinishAction();
        CancelAction cancelAction = new CancelAction(this.myCancellationPolicy);
        this.getHelpAction().setEnabled(this.myHelpUrl != null);
        if (this.myHelpUrl == null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{cancelAction, prevAction, nextAction, finishAction};
                if (actionArray == null) {
                    ModelWizardDialog.$$$reportNull$$$0(16);
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{prevAction, nextAction, cancelAction, finishAction};
            if (actionArray == null) {
                ModelWizardDialog.$$$reportNull$$$0(17);
            }
            return actionArray;
        }
        if (SystemInfo.isMac) {
            Action[] actionArray = new Action[]{this.getHelpAction(), cancelAction, prevAction, nextAction, finishAction};
            if (actionArray == null) {
                ModelWizardDialog.$$$reportNull$$$0(18);
            }
            return actionArray;
        }
        Action[] actionArray = new Action[]{prevAction, nextAction, cancelAction, finishAction, this.getHelpAction()};
        if (actionArray == null) {
            ModelWizardDialog.$$$reportNull$$$0(19);
        }
        return actionArray;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myWizard.getPreferredFocusComponent();
    }

    protected JButton createJButtonForAction(Action action2) {
        JButton button = super.createJButtonForAction(action2);
        if (action2 instanceof ModelWizardDialogAction) {
            ModelWizardDialogAction wizardAction = (ModelWizardDialogAction)((Object)action2);
            this.myBindings.bind(new EnabledProperty(button), wizardAction.shouldBeEnabled());
            this.myBindings.bind(new VisibleProperty(button), wizardAction.shouldBeVisible());
            this.myListeners.receiveAndFire(wizardAction.shouldBeDefault(), isDefault -> {
                JRootPane rootPane = this.getRootPane();
                if (rootPane != null && isDefault.booleanValue()) {
                    rootPane.setDefaultButton(button);
                }
            });
        }
        return button;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/wizard/model/ModelWizardDialog";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityType";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationPolicy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/wizard/model/ModelWizardDialog";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onWizardFinished";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onWizardAdvanceError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class StepActionWrapper
    extends ModelWizardDialogAction {
        private final BoolValueProperty myEnabled;
        private final ObservableOptional<Action> myExtraAction;
        private PropertyChangeListener myActionListener;

        @Override
        @NotNull
        public ObservableBool shouldBeVisible() {
            ObservableBool observableBool = this.myExtraAction.isPresent();
            if (observableBool == null) {
                StepActionWrapper.$$$reportNull$$$0(0);
            }
            return observableBool;
        }

        StepActionWrapper() {
            super("");
            this.myEnabled = new BoolValueProperty(false);
            this.myExtraAction = ModelWizardDialog.this.myWizard.getExtraAction();
            InvalidationListener extraActionChangedListener = new InvalidationListener(){
                Action myActiveAction = null;

                @Override
                public void onInvalidated(@NotNull ObservableValue<?> sender) {
                    if (sender == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (this.myActiveAction != null && StepActionWrapper.this.myActionListener != null) {
                        this.myActiveAction.removePropertyChangeListener(StepActionWrapper.this.myActionListener);
                    }
                    this.myActiveAction = (Action)StepActionWrapper.this.myExtraAction.getValueOrNull();
                    if (this.myActiveAction != null) {
                        StepActionWrapper.this.putValue("Name", this.myActiveAction.getValue("Name"));
                        StepActionWrapper.this.myActionListener = evt -> {
                            if ("enabled".equals(evt.getPropertyName())) {
                                StepActionWrapper.this.myEnabled.set((Boolean)evt.getNewValue());
                            }
                        };
                        this.myActiveAction.addPropertyChangeListener(StepActionWrapper.this.myActionListener);
                        StepActionWrapper.this.myEnabled.set(this.myActiveAction.isEnabled());
                    } else {
                        StepActionWrapper.this.myActionListener = null;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sender", "com/android/tools/idea/wizard/model/ModelWizardDialog$StepActionWrapper$1", "onInvalidated"));
                }
            };
            this.myExtraAction.addListener(extraActionChangedListener);
            extraActionChangedListener.onInvalidated(this.myExtraAction);
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            BoolValueProperty boolValueProperty = this.myEnabled;
            if (boolValueProperty == null) {
                StepActionWrapper.$$$reportNull$$$0(1);
            }
            return boolValueProperty;
        }

        protected void doAction(ActionEvent e) {
            assert (((Optional)this.myExtraAction.get()).isPresent());
            this.myExtraAction.getValue().actionPerformed(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/wizard/model/ModelWizardDialog$StepActionWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeVisible";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeEnabled";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class CancelAction
    extends ModelWizardDialogAction {
        private final CancellationPolicy myCancellationPolicy;

        private CancelAction(CancellationPolicy cancellationPolicy) {
            if (cancellationPolicy == null) {
                CancelAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"button.cancel", (Object[])new Object[0]));
            this.myCancellationPolicy = cancellationPolicy;
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.doCancelAction();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            switch (this.myCancellationPolicy) {
                case CAN_CANCEL_UNTIL_CAN_FINISH: {
                    ObservableBool observableBool = BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep().and(ModelWizardDialog.this.myWizard.canGoForward()));
                    if (observableBool == null) {
                        CancelAction.$$$reportNull$$$0(1);
                    }
                    return observableBool;
                }
            }
            ObservableBool observableBool = BooleanExpression.ALWAYS_TRUE;
            if (observableBool == null) {
                CancelAction.$$$reportNull$$$0(2);
            }
            return observableBool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancellationPolicy";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/wizard/model/ModelWizardDialog$CancelAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/wizard/model/ModelWizardDialog$CancelAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeEnabled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class FinishAction
    extends ModelWizardDialogAction {
        FinishAction() {
            super(IdeBundle.message((String)"button.finish", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.onLastStep().and(ModelWizardDialog.this.myWizard.canGoForward());
            if (observableBool == null) {
                FinishAction.$$$reportNull$$$0(0);
            }
            return observableBool;
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.onLastStep();
            if (observableBool == null) {
                FinishAction.$$$reportNull$$$0(1);
            }
            return observableBool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/wizard/model/ModelWizardDialog$FinishAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeDefault";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class PreviousAction
    extends ModelWizardDialogAction {
        PreviousAction() {
            super(IdeBundle.message((String)"button.wizard.previous", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goBack();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.canGoBack();
            if (observableBool == null) {
                PreviousAction.$$$reportNull$$$0(0);
            }
            return observableBool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/model/ModelWizardDialog$PreviousAction", "shouldBeEnabled"));
        }
    }

    private final class NextAction
    extends ModelWizardDialogAction {
        NextAction() {
            super(IdeBundle.message((String)"button.wizard.next", (Object[])new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            ModelWizardDialog.this.myWizard.goForward();
        }

        @Override
        @NotNull
        public ObservableBool shouldBeEnabled() {
            ObservableBool observableBool = ModelWizardDialog.this.myWizard.canGoForward().and(BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep()));
            if (observableBool == null) {
                NextAction.$$$reportNull$$$0(0);
            }
            return observableBool;
        }

        @Override
        @NotNull
        public ObservableBool shouldBeDefault() {
            ObservableBool observableBool = BooleanExpressions.not(ModelWizardDialog.this.myWizard.onLastStep());
            if (observableBool == null) {
                NextAction.$$$reportNull$$$0(1);
            }
            return observableBool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/android/tools/idea/wizard/model/ModelWizardDialog$NextAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeEnabled";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeDefault";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private abstract class ModelWizardDialogAction
    extends DialogWrapper.DialogWrapperAction {
        ModelWizardDialogAction(String name) {
            if (name == null) {
                ModelWizardDialogAction.$$$reportNull$$$0(0);
            }
            super((DialogWrapper)ModelWizardDialog.this, name);
        }

        @NotNull
        public abstract ObservableBool shouldBeEnabled();

        @NotNull
        public ObservableBool shouldBeVisible() {
            ObservableBool observableBool = BooleanExpression.ALWAYS_TRUE;
            if (observableBool == null) {
                ModelWizardDialogAction.$$$reportNull$$$0(1);
            }
            return observableBool;
        }

        @NotNull
        public ObservableBool shouldBeDefault() {
            ObservableBool observableBool = BooleanExpression.ALWAYS_FALSE;
            if (observableBool == null) {
                ModelWizardDialogAction.$$$reportNull$$$0(2);
            }
            return observableBool;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/wizard/model/ModelWizardDialog$ModelWizardDialogAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/wizard/model/ModelWizardDialog$ModelWizardDialogAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeVisible";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "shouldBeDefault";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface CustomLayout
    extends Disposable {
        @NotNull
        public JPanel decorate(@NotNull ModelWizard.TitleHeader var1, @NotNull JPanel var2);

        public Dimension getDefaultPreferredSize();

        public Dimension getDefaultMinSize();
    }

    public static enum CancellationPolicy {
        ALWAYS_CAN_CANCEL,
        CAN_CANCEL_UNTIL_CAN_FINISH;

    }
}

