/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.dynamic;

import com.android.tools.adtui.ImageComponent;
import com.android.tools.idea.wizard.WizardConstants;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WizardStepHeaderPanel
extends JPanel {
    @NotNull
    String myTitle = "Title Label";
    @Nullable
    String myDescription;
    @Nullable
    Icon myWizardIcon;
    @Nullable
    Icon myStepIcon;
    @Nullable
    private JLabel myTitleLabel;
    @NotNull
    private ComponentHolder<String, JLabel> myDescriptionLabel = new LabelHolder();
    @NotNull
    private ComponentHolder<Icon, ImageComponent> myWizardIconComponent = new ImageComponentHolder();
    @NotNull
    private ComponentHolder<Icon, ImageComponent> myStepIconComponent = new ImageComponentHolder();

    public WizardStepHeaderPanel() {
        this.setBorder(new EmptyBorder(WizardConstants.STUDIO_WIZARD_INSETS));
        this.setForeground(Color.WHITE);
        this.setBackground((Color)WizardConstants.ANDROID_NPW_HEADER_COLOR);
        this.updateHeader();
    }

    private static GridConstraints createHeaderLabelGridConstraints(int row, int column, int anchor) {
        return new GridConstraints(row, column, 1, 1, anchor, 1, 6, 0, null, null, null);
    }

    public static WizardStepHeaderPanel create(@Nullable Disposable parent, @NotNull JBColor headerColor, @Nullable Icon wizardIcon, @Nullable Icon stepIcon, @NotNull String title, @Nullable String description) {
        if (headerColor == null) {
            WizardStepHeaderPanel.$$$reportNull$$$0(0);
        }
        if (title == null) {
            WizardStepHeaderPanel.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            parent = ApplicationManager.getApplication();
        }
        WizardStepHeaderPanel panel2 = new WizardStepHeaderPanel();
        panel2.setBackground((Color)headerColor);
        panel2.setTitle(title);
        panel2.setDescription(description);
        panel2.setStepIcon(stepIcon);
        panel2.setWizardIcon(wizardIcon);
        PropertyChangeListener listener2 = propertyChangeEvent -> {
            JBColor.setDark((boolean)UIUtil.isUnderDarcula());
            panel2.setBackground((Color)headerColor);
            Font font = UIManager.getFont("Label.font");
            panel2.myTitleLabel.setFont(new Font(font.getFontName(), font.getStyle(), 24));
        };
        UIManager.addPropertyChangeListener(listener2);
        Disposer.register((Disposable)parent, () -> UIManager.removePropertyChangeListener(listener2));
        return panel2;
    }

    public void setTitle(@Nullable String title) {
        this.myTitle = StringUtil.notNullize((String)title, (String)"Title Label");
        this.updateHeader();
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
        this.updateHeader();
    }

    public void setStepIcon(@Nullable Icon stepIcon) {
        this.myStepIcon = stepIcon;
        this.updateHeader();
    }

    public void setWizardIcon(@Nullable Icon wizardIcon) {
        this.myWizardIcon = wizardIcon;
        this.updateHeader();
    }

    private void updateHeader() {
        boolean updateLayout = false;
        if (this.myTitleLabel == null) {
            this.myTitleLabel = new JLabel(this.myTitle);
            updateLayout = true;
        }
        this.myTitleLabel.setText(this.myTitle);
        if (updateLayout |= this.myDescriptionLabel.updateValue(StringUtil.nullize((String)this.myDescription, (boolean)true)) || this.myWizardIconComponent.updateValue(this.myWizardIcon) || this.myStepIconComponent.updateValue(this.myStepIcon)) {
            int rows = this.myDescriptionLabel.getComponent() == null ? 1 : 2;
            int columns = 1 + (this.myWizardIconComponent.getComponent() == null ? 0 : 1) + (this.myStepIconComponent.getComponent() == null ? 0 : 1);
            for (Component component : this.getComponents()) {
                this.remove(component);
            }
            this.setLayout((LayoutManager)new GridLayoutManager(rows, columns, new Insets(18, 0, 12, 0), 2, 2));
            int currentColumn = this.addIconIfExists(this.myWizardIconComponent.getComponent(), 0, rows) ? 1 : 0;
            this.addLabels(this.myTitleLabel, this.myDescriptionLabel.getComponent(), currentColumn);
            this.addIconIfExists(this.myStepIconComponent.getComponent(), currentColumn + 1, rows);
        }
    }

    private void addLabels(@NotNull JLabel titleLabel, @Nullable JLabel descriptionLabel, int column) {
        if (titleLabel == null) {
            WizardStepHeaderPanel.$$$reportNull$$$0(2);
        }
        boolean hasDescription = descriptionLabel != null;
        int anchor = hasDescription ? 10 : 8;
        titleLabel.setForeground(this.getForeground());
        titleLabel.setFont(titleLabel.getFont().deriveFont(JBUI.scale((float)24.0f)));
        this.add((Component)titleLabel, WizardStepHeaderPanel.createHeaderLabelGridConstraints(0, column, anchor));
        if (hasDescription) {
            descriptionLabel.setForeground(this.getForeground());
            this.add((Component)descriptionLabel, WizardStepHeaderPanel.createHeaderLabelGridConstraints(1, column, 9));
        }
    }

    private boolean addIconIfExists(@Nullable ImageComponent iconComponent, int column, int spanningRows) {
        if (iconComponent != null) {
            GridConstraints imageConstraints = new GridConstraints(0, column, spanningRows, 1, 9, 0, 0, 0, null, (Dimension)JBUI.size((int)60, (int)60), null);
            this.add((Component)iconComponent, imageConstraints);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerColor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titleLabel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/wizard/dynamic/WizardStepHeaderPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addLabels";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LabelHolder
    extends ComponentHolder<String, JLabel> {
        private LabelHolder() {
        }

        @Override
        protected void setValue(@NotNull JLabel component, @NotNull String value2) {
            if (component == null) {
                LabelHolder.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                LabelHolder.$$$reportNull$$$0(1);
            }
            component.setText(value2);
        }

        @Override
        @NotNull
        protected JLabel createComponent() {
            JLabel jLabel = new JLabel();
            if (jLabel == null) {
                LabelHolder.$$$reportNull$$$0(2);
            }
            return jLabel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/wizard/dynamic/WizardStepHeaderPanel$LabelHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/wizard/dynamic/WizardStepHeaderPanel$LabelHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImageComponentHolder
    extends ComponentHolder<Icon, ImageComponent> {
        private ImageComponentHolder() {
        }

        @Override
        protected void setValue(@NotNull ImageComponent component, @NotNull Icon value2) {
            if (component == null) {
                ImageComponentHolder.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                ImageComponentHolder.$$$reportNull$$$0(1);
            }
            component.setIcon(value2);
        }

        @Override
        @NotNull
        protected ImageComponent createComponent() {
            ImageComponent imageComponent = new ImageComponent();
            if (imageComponent == null) {
                ImageComponentHolder.$$$reportNull$$$0(2);
            }
            return imageComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/wizard/dynamic/WizardStepHeaderPanel$ImageComponentHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/wizard/dynamic/WizardStepHeaderPanel$ImageComponentHolder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ComponentHolder<V, C extends JComponent> {
        @Nullable
        private C myComponent;

        private ComponentHolder() {
        }

        public final boolean updateValue(@Nullable V value2) {
            boolean updateLayout;
            if (value2 == null) {
                updateLayout = this.myComponent != null;
                this.myComponent = null;
            } else {
                if (this.myComponent == null) {
                    updateLayout = true;
                    this.myComponent = this.createComponent();
                } else {
                    updateLayout = false;
                }
                this.setValue(this.myComponent, value2);
            }
            return updateLayout;
        }

        protected abstract void setValue(@NotNull C var1, @NotNull V var2);

        @NotNull
        protected abstract C createComponent();

        @Nullable
        public final C getComponent() {
            return this.myComponent;
        }
    }
}

