/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.io.FileOp;
import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.EmulatedProperties;
import com.android.sdklib.internal.avd.GpuMode;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdOptionsModel;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.InstallComponentsPath;
import com.android.tools.idea.welcome.wizard.deprecated.ProgressStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidVirtualDevice
extends InstallableComponent {
    public static final Logger LOG = Logger.getInstance(AndroidVirtualDevice.class);
    private static final String DEFAULT_DEVICE_ID = "Nexus 5X";
    private static final IdDisplay ID_ADDON_GOOGLE_API_IMG = IdDisplay.create((String)"google_apis", (String)"Google APIs");
    private static final IdDisplay ID_VENDOR_GOOGLE = IdDisplay.create((String)"google", (String)"Google LLC");
    private static final Storage DEFAULT_RAM_SIZE = new Storage(1536L, Storage.Unit.MiB);
    private static final Storage DEFAULT_HEAP_SIZE = new Storage(256L, Storage.Unit.MiB);
    private static final Set<String> ENABLED_HARDWARE = ImmutableSet.of((Object)"hw.accelerometer", (Object)"hw.audioInput", (Object)"hw.battery", (Object)"hw.gps", (Object)"hw.keyboard", (Object)"hw.sensors.orientation", (Object[])new String[]{"hw.sensors.proximity", "hw.sdCard", "hw.gpu.enabled"});
    private static final Set<String> DISABLED_HARDWARE = ImmutableSet.of((Object)"hw.dPad", (Object)"hw.mainKeys", (Object)"hw.trackBall", (Object)"snapshot.present");
    private ProgressStep myProgressStep;
    @Nullable
    private final AndroidVersion myLatestVersion;

    public AndroidVirtualDevice(@NotNull ScopedStateStore store, @NotNull Map<String, RemotePackage> remotePackages, boolean installUpdates, @NotNull FileOp fop) {
        if (store == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(0);
        }
        if (remotePackages == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(1);
        }
        if (fop == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(2);
        }
        super(store, "Android Virtual Device", "A preconfigured and optimized Android Virtual Device for app testing on the emulator. (Recommended)", installUpdates, fop);
        RemotePackage latestInfo = InstallComponentsPath.findLatestPlatform(remotePackages);
        this.myLatestVersion = latestInfo != null ? ((DetailsTypes.PlatformDetailsType)latestInfo.getTypeDetails()).getAndroidVersion() : null;
    }

    @NotNull
    private static Device getDevice(@NotNull File sdkPath) throws WizardException {
        if (sdkPath == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(3);
        }
        List<Device> devices = DeviceManagerConnection.getDeviceManagerConnection(sdkPath).getDevices();
        for (Device device : devices) {
            if (!Objects.equal((Object)device.getId(), (Object)DEFAULT_DEVICE_ID)) continue;
            Device device2 = device;
            if (device2 == null) {
                AndroidVirtualDevice.$$$reportNull$$$0(4);
            }
            return device2;
        }
        throw new WizardException(String.format("No device definition with \"%s\" ID found", DEFAULT_DEVICE_ID));
    }

    private SystemImageDescription getSystemImageDescription(AndroidSdkHandler sdkHandler) throws WizardException {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        Collection systemImages = sdkHandler.getSystemImageManager((ProgressIndicator)progress).lookup(ID_ADDON_GOOGLE_API_IMG, this.myLatestVersion, ID_VENDOR_GOOGLE);
        if (systemImages.isEmpty()) {
            throw new WizardException("Missing system image required for an AVD setup");
        }
        return new SystemImageDescription((ISystemImage)systemImages.iterator().next());
    }

    @Nullable
    @VisibleForTesting
    AvdInfo createAvd(@NotNull AvdManagerConnection connection, @NotNull AndroidSdkHandler sdkHandler) throws WizardException {
        if (connection == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(5);
        }
        if (sdkHandler == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(6);
        }
        Device d = AndroidVirtualDevice.getDevice(sdkHandler.getLocation());
        SystemImageDescription systemImageDescription = this.getSystemImageDescription(sdkHandler);
        String cardSize = EmulatedProperties.DEFAULT_INTERNAL_STORAGE.toIniString();
        File hardwareSkinPath = AvdWizardUtils.pathToUpdatedSkins(d.getDefaultHardware().getSkinFile(), systemImageDescription, this.myFileOp);
        String displayName = String.format("%1$s %2$s %3$s", d.getDisplayName(), systemImageDescription.getVersion(), systemImageDescription.getAbiType());
        displayName = connection.uniquifyDisplayName(displayName);
        String internalName = AvdWizardUtils.cleanAvdName(connection, displayName, true);
        Abi abi = Abi.getEnum((String)systemImageDescription.getAbiType());
        boolean useRanchu = AvdManagerConnection.doesSystemImageSupportQemu2(systemImageDescription, this.myFileOp);
        boolean supportsSmp = abi != null && abi.supportsMultipleCpuCores() && AvdWizardUtils.getMaxCpuCores() > 1;
        Map<String, String> settings = AndroidVirtualDevice.getAvdSettings(internalName, d);
        settings.put("avd.ini.displayname", displayName);
        if (useRanchu) {
            settings.put("hw.cpu.ncore", String.valueOf(supportsSmp ? AvdWizardUtils.getMaxCpuCores() : 1));
        }
        return connection.createOrUpdateAvd(null, internalName, d, systemImageDescription, ScreenOrientation.PORTRAIT, false, cardSize, hardwareSkinPath, settings, false, true);
    }

    private static Map<String, String> getAvdSettings(@NotNull String internalName, @NotNull Device device) {
        if (internalName == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(7);
        }
        if (device == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(8);
        }
        HashMap result2 = Maps.newHashMap();
        result2.put("hw.gpu.mode", GpuMode.AUTO.getGpuSetting());
        for (String key : ENABLED_HARDWARE) {
            result2.put(key, "yes");
        }
        for (String key : DISABLED_HARDWARE) {
            result2.put(key, "no");
        }
        for (String key : ImmutableSet.of((Object)"hw.camera.back", (Object)"hw.camera.front")) {
            result2.put(key, "emulated");
        }
        result2.put("hw.device.name", device.getDisplayName());
        result2.put("hw.device.manufacturer", device.getManufacturer());
        result2.put("runtime.network.latency", EmulatedProperties.DEFAULT_NETWORK_LATENCY.getAsParameter());
        result2.put("runtime.network.speed", EmulatedProperties.DEFAULT_NETWORK_SPEED.getAsParameter());
        result2.put("AvdId", internalName);
        result2.put("hw.lcd.density", String.valueOf(Density.XXHIGH.getDpiValue()));
        AndroidVirtualDevice.setStorageSizeKey(result2, "hw.ramSize", DEFAULT_RAM_SIZE, true);
        AndroidVirtualDevice.setStorageSizeKey(result2, "vm.heapSize", DEFAULT_HEAP_SIZE, true);
        AndroidVirtualDevice.setStorageSizeKey(result2, "disk.dataPartition.size", EmulatedProperties.DEFAULT_INTERNAL_STORAGE, false);
        return result2;
    }

    private static void setStorageSizeKey(Map<String, String> result2, String key, Storage size, boolean convertToMb) {
        result2.put(key, AvdOptionsModel.toIniString(size, convertToMb));
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ArrayList result2 = Lists.newArrayList();
        if (this.myLatestVersion != null) {
            result2.add(DetailsTypes.getAddonPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG));
            result2.add(DetailsTypes.getSysImgPath((IdDisplay)ID_VENDOR_GOOGLE, (AndroidVersion)this.myLatestVersion, (IdDisplay)ID_ADDON_GOOGLE_API_IMG, (String)"x86"));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(10);
        }
        this.myProgressStep = progressStep;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(11);
        }
        if (sdkHandler == null) {
            AndroidVirtualDevice.$$$reportNull$$$0(12);
        }
        this.myProgressStep.getProgressIndicator().setIndeterminate(true);
        this.myProgressStep.getProgressIndicator().setText("Creating Android virtual device");
        installContext.print("Creating Android virtual device\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        try {
            AvdInfo avd = this.createAvd(AvdManagerConnection.getAvdManagerConnection(sdkHandler), sdkHandler);
            if (avd == null) {
                throw new WizardException("Unable to create Android virtual device");
            }
            String successMessage = String.format("Android virtual device %s was successfully created\n", avd.getName());
            installContext.print(successMessage, ConsoleViewContentType.SYSTEM_OUTPUT);
        }
        catch (WizardException e) {
            LOG.error((Throwable)e);
            String failureMessage = String.format("Unable to create a virtual device: %s\n", e.getMessage());
            installContext.print(failureMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @Override
    protected boolean isSelectedByDefault() {
        SystemImageDescription desired;
        if (this.mySdkHandler == null) {
            return false;
        }
        try {
            desired = this.getSystemImageDescription(this.mySdkHandler);
        }
        catch (WizardException e) {
            return false;
        }
        AvdManagerConnection connection = AvdManagerConnection.getAvdManagerConnection(this.mySdkHandler);
        List<AvdInfo> avds = connection.getAvds(false);
        for (AvdInfo avd : avds) {
            if (!avd.getAbiType().equals(desired.getAbiType()) || !avd.getAndroidVersion().equals((Object)desired.getVersion())) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePackages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/welcome/install/AndroidVirtualDevice";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressStep";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/welcome/install/AndroidVirtualDevice";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevice";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredSdkPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDevice";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAvd";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAvdSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

