/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.android.ide.common.util.PathString;
import com.android.ide.common.util.PathStrings;
import com.android.tools.idea.util.VirtualFileSystemOpener;
import com.android.tools.idea.util.VirtualFileSystemOpenerKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0006\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u0007\u001a\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"buffered", "Ljava/io/InputStream;", "bufferedStream", "Lcom/android/ide/common/util/PathString;", "toIoFile", "Ljava/io/File;", "Lcom/intellij/openapi/vfs/VirtualFile;", "toLibraryRootVirtualFile", "refresh", "", "toPathString", "toVirtualFile", "intellij.android.core"})
@JvmName(name="FileExtensions")
public final class FileExtensions {
    @NotNull
    public static final File toIoFile(@NotNull VirtualFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        File file = VfsUtil.virtualToIoFile((VirtualFile)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"VfsUtil.virtualToIoFile(this)");
        return file;
    }

    @Nullable
    public static final VirtualFile toVirtualFile(@NotNull File $receiver, boolean refresh2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return VfsUtil.findFileByIoFile((File)$receiver, (boolean)refresh2);
    }

    @Nullable
    public static /* synthetic */ VirtualFile toVirtualFile$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FileExtensions.toVirtualFile(file, bl);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFile toLibraryRootVirtualFile(@NotNull File $receiver, boolean refresh2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        String url = VfsUtil.getUrlForLibraryRoot((File)$receiver);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
        VirtualFileManager virtualFileManager2 = virtualFileManager;
        return refresh2 ? virtualFileManager2.refreshAndFindFileByUrl(url) : virtualFileManager2.findFileByUrl(url);
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ VirtualFile toLibraryRootVirtualFile$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FileExtensions.toLibraryRootVirtualFile(file, bl);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFile toLibraryRootVirtualFile(@NotNull File $receiver) {
        return FileExtensions.toLibraryRootVirtualFile$default($receiver, false, 1, null);
    }

    @NotNull
    public static final InputStream bufferedStream(@NotNull PathString $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return FileExtensions.buffered(PathStrings.inputStream((PathString)$receiver));
    }

    @NotNull
    public static final InputStream buffered(@NotNull InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        InputStream inputStream = $receiver;
        return inputStream instanceof BufferedInputStream ? $receiver : (inputStream instanceof ByteArrayInputStream ? $receiver : (InputStream)new BufferedInputStream($receiver));
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFile toVirtualFile(@Nullable PathString $receiver, boolean refresh2) {
        if ($receiver == null) {
            return null;
        }
        VirtualFileSystemOpener.INSTANCE.mount();
        return VirtualFileSystemOpenerKt.toVirtualFile($receiver, refresh2);
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ VirtualFile toVirtualFile$default(PathString pathString, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FileExtensions.toVirtualFile(pathString, bl);
    }

    @JvmOverloads
    @Nullable
    public static final VirtualFile toVirtualFile(@Nullable PathString $receiver) {
        return FileExtensions.toVirtualFile$default($receiver, false, 1, null);
    }

    @NotNull
    public static final PathString toPathString(@NotNull VirtualFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        VirtualFileSystemOpener.INSTANCE.mount();
        VirtualFileSystem virtualFileSystem = $receiver.getFileSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileSystem, (String)"fileSystem");
        String string = virtualFileSystem.getProtocol();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileSystem.protocol");
        String string2 = $receiver.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        return new PathString(string, string2);
    }
}

