/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.api.Channel;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.SdkUpdaterConfigPanel;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.android.utils.FileUtils;
import com.android.utils.HtmlBuilder;
import com.android.utils.Pair;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkUpdaterConfigurable
implements SearchableConfigurable {
    private static final int ESTIMATED_ZIP_DECOMPRESSION_RATE = 4;
    private SdkUpdaterConfigPanel myPanel;
    private Channel myCurrentChannel;
    private Runnable myChannelChangedCallback;

    @NotNull
    public String getId() {
        if ("AndroidSdkUpdater" == null) {
            SdkUpdaterConfigurable.$$$reportNull$$$0(0);
        }
        return "AndroidSdkUpdater";
    }

    @Nls
    public String getDisplayName() {
        return "Android SDK Updater";
    }

    @Nullable
    public String getHelpTopic() {
        return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "r/studio-ui/sdk-manager.html";
    }

    @Nullable
    public JComponent createComponent() {
        this.myChannelChangedCallback = () -> {
            Channel channel = StudioSettingsController.getInstance().getChannel();
            if (this.myCurrentChannel == null) {
                this.myCurrentChannel = channel;
            }
            if (!Objects.equal((Object)channel, (Object)this.myCurrentChannel)) {
                this.myCurrentChannel = channel;
                this.myPanel.refresh(true);
            }
        };
        this.myPanel = new SdkUpdaterConfigPanel(this.myChannelChangedCallback, new StudioDownloader(), StudioSettingsController.getInstance(), this);
        JComponent component = this.myPanel.getComponent();
        component.addAncestorListener((AncestorListener)new AncestorListenerAdapter(){

            public void ancestorAdded(AncestorEvent event) {
                SdkUpdaterConfigurable.this.myChannelChangedCallback.run();
            }
        });
        return this.myPanel.getComponent();
    }

    AndroidSdkHandler getSdkHandler() {
        return AndroidSdkHandler.getInstance((File)this.myPanel.getSelectedSdkLocation());
    }

    RepoManager getRepoManager() {
        return this.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
    }

    public boolean isModified() {
        Configurable updatesConfigurable;
        if (this.myPanel.isModified()) {
            return true;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.myPanel.getComponent());
        Settings data = (Settings)Settings.KEY.getData(dataContext);
        if (data != null && (updatesConfigurable = data.find("preferences.updates")) != null) {
            return updatesConfigurable.isModified();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void apply() throws ConfigurationException {
        boolean sourcesModified = this.myPanel.areSourcesModified();
        this.myPanel.saveSources();
        ArrayList toDelete = Lists.newArrayList();
        HashMap requestedPackages = Maps.newHashMap();
        for (PackageNodeModel model : this.myPanel.getStates()) {
            if (model.getState() == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                if (!model.getPkg().hasLocal()) continue;
                toDelete.add(model.getPkg().getLocal());
                continue;
            }
            if (model.getState() != PackageNodeModel.SelectedState.INSTALLED || !model.getPkg().isUpdate() && model.getPkg().hasLocal()) continue;
            UpdatablePackage pkg = model.getPkg();
            requestedPackages.put(pkg.getRemote(), pkg);
        }
        boolean found = false;
        long spaceToBeFreedUp = 0L;
        long patchesDownloadSize = 0L;
        long fullInstallationsDownloadSize = 0L;
        HtmlBuilder messageToDelete = new HtmlBuilder();
        if (!toDelete.isEmpty()) {
            found = true;
            messageToDelete.add("The following components will be deleted: \n");
            messageToDelete.beginList();
            try {
                spaceToBeFreedUp = (Long)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SdkUpdaterConfigurable.getLocalInstallationSize(toDelete), "Gathering Package Information", true, null);
            }
            catch (ProcessCanceledException e) {
                throw new ConfigurationException("Installation was canceled.");
            }
            for (LocalPackage item : toDelete) {
                messageToDelete.listItem().add(item.getDisplayName()).add(", Revision: ").add(item.getVersion().toString());
            }
            messageToDelete.endList();
        }
        HtmlBuilder messageToInstall = new HtmlBuilder();
        if (!requestedPackages.isEmpty()) {
            found = true;
            messageToInstall.add("The following components will be installed: \n");
            messageToInstall.beginList();
            HashMultimap dependencies = HashMultimap.create();
            StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(this.getClass());
            RepositoryPackages packages = this.getRepoManager().getPackages();
            for (RemotePackage item : requestedPackages.keySet()) {
                List packageDependencies = InstallerUtil.computeRequiredPackages((Collection)ImmutableList.of((Object)item), (RepositoryPackages)packages, (ProgressIndicator)progress2);
                if (packageDependencies == null) {
                    Messages.showErrorDialog((Project)null, (String)("Unable to resolve dependencies for " + item.getDisplayName()), (String)"Dependency Error");
                    throw new ConfigurationException("Unable to resolve dependencies.");
                }
                for (RemotePackage dependency : packageDependencies) {
                    dependencies.put((Object)dependency, (Object)item);
                }
                messageToInstall.listItem().add(String.format("%1$s %2$s %3$s", item.getDisplayName(), item.getTypeDetails() instanceof DetailsTypes.ApiDetailsType ? "revision" : "version", item.getVersion()));
                Pair<Long, Boolean> itemDownloadSize = SdkUpdaterConfigurable.calculateDownloadSizeForPackage(item, packages);
                if (((Boolean)itemDownloadSize.getSecond()).booleanValue()) {
                    patchesDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
                    continue;
                }
                fullInstallationsDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
            }
            for (RemotePackage dependency : dependencies.keySet()) {
                if (requestedPackages.containsKey(dependency)) continue;
                HashSet requests = Sets.newHashSet((Iterable)dependencies.get((Object)dependency));
                requests.remove(dependency);
                if (requests.isEmpty()) continue;
                messageToInstall.listItem().add(dependency.getDisplayName()).add(" (Required by ");
                Iterator requestIterator = requests.iterator();
                messageToInstall.add(((RemotePackage)requestIterator.next()).getDisplayName());
                while (requestIterator.hasNext()) {
                    messageToInstall.add(", ").add(((RemotePackage)requestIterator.next()).getDisplayName());
                }
                messageToInstall.add(")");
                Pair<Long, Boolean> itemDownloadSize = SdkUpdaterConfigurable.calculateDownloadSizeForPackage(dependency, packages);
                if (((Boolean)itemDownloadSize.getSecond()).booleanValue()) {
                    patchesDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
                    continue;
                }
                fullInstallationsDownloadSize += ((Long)itemDownloadSize.getFirst()).longValue();
            }
            messageToInstall.endList();
        }
        if (found) {
            ModelWizardDialog dialog;
            Pair<HtmlBuilder, HtmlBuilder> diskUsageMessages = this.getDiskUsageMessages(fullInstallationsDownloadSize, patchesDownloadSize, spaceToBeFreedUp);
            HtmlBuilder message = new HtmlBuilder();
            message.openHtmlBody();
            if (diskUsageMessages.getSecond() != null) {
                message.addHtml(((HtmlBuilder)diskUsageMessages.getSecond()).getHtml());
            }
            message.addHtml(messageToDelete.getHtml());
            message.addHtml(messageToInstall.getHtml());
            message.addHtml(((HtmlBuilder)diskUsageMessages.getFirst()).getHtml());
            message.closeHtmlBody();
            if (!SdkUpdaterConfigurable.confirmChange(message)) throw new ConfigurationException("Installation was canceled.");
            if (!(requestedPackages.isEmpty() && toDelete.isEmpty() || (dialog = SdkQuickfixUtils.createDialogForPackages(this.myPanel.getComponent(), requestedPackages.values(), toDelete, true)) == null)) {
                dialog.show();
                for (RemotePackage remotePackage : requestedPackages.keySet()) {
                    PackageOperation installer = this.getRepoManager().getInProgressInstallOperation((RepoPackage)remotePackage);
                    if (installer == null) continue;
                    PackageOperation.StatusChangeListener listener2 = (installer1, progress) -> this.myPanel.getComponent().repaint();
                    installer.registerStateChangeListener(listener2);
                }
            }
            this.myPanel.refresh(sourcesModified);
            return;
        } else {
            this.myChannelChangedCallback.run();
        }
    }

    private static long getLocalInstallationSize(@NotNull Collection<LocalPackage> localPackages) {
        if (localPackages == null) {
            SdkUpdaterConfigurable.$$$reportNull$$$0(1);
        }
        long size = 0L;
        for (LocalPackage item : localPackages) {
            if (item == null) continue;
            for (File f : FileUtils.getAllFiles((File)item.getLocation())) {
                size += f.length();
            }
        }
        return size;
    }

    private static Pair<Long, Boolean> calculateDownloadSizeForPackage(@NotNull RemotePackage remotePackage, @NotNull RepositoryPackages packages) {
        Archive.PatchType patch;
        if (remotePackage == null) {
            SdkUpdaterConfigurable.$$$reportNull$$$0(2);
        }
        if (packages == null) {
            SdkUpdaterConfigurable.$$$reportNull$$$0(3);
        }
        LocalPackage localPackage = (LocalPackage)packages.getLocalPackages().get(remotePackage.getPath());
        Archive archive = remotePackage.getArchive();
        if (archive == null) {
            return Pair.of((Object)0L, (Object)false);
        }
        if (localPackage != null && (patch = archive.getPatch(localPackage.getVersion())) != null) {
            return Pair.of((Object)patch.getSize(), (Object)true);
        }
        return Pair.of((Object)archive.getComplete().getSize(), (Object)false);
    }

    private Pair<HtmlBuilder, HtmlBuilder> getDiskUsageMessages(long fullInstallationsDownloadSize, long patchesDownloadSize, long spaceToBeFreedUp) {
        long totalDownloadSize;
        HtmlBuilder message = new HtmlBuilder();
        message.add("Disk usage:\n");
        boolean issueDiskSpaceWarning = false;
        message.beginList();
        if (spaceToBeFreedUp > 0L) {
            message.listItem().add("Disk space that will be freed: " + new Storage(spaceToBeFreedUp).toUiString());
        }
        if ((totalDownloadSize = patchesDownloadSize + fullInstallationsDownloadSize) > 0L) {
            message.listItem().add("Estimated download size: " + new Storage(totalDownloadSize).toUiString());
            long tempDirUsageAfterDownload = patchesDownloadSize + 4L * fullInstallationsDownloadSize;
            message.listItem().add("Estimated disk space required in temp directory during installation: " + new Storage(tempDirUsageAfterDownload).toUiString());
            long sdkRootUsageAfterInstallation = 4L * fullInstallationsDownloadSize;
            message.listItem().add("Estimated disk space to be additionally occupied on SDK partition after installation: " + new Storage(sdkRootUsageAfterInstallation).toUiString());
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File sdkRoot = this.getSdkHandler().getLocation();
            long sdkRootUsableSpace = 0L;
            if (sdkRoot != null) {
                sdkRootUsableSpace = sdkRoot.getUsableSpace();
            }
            long tempDirUsableSpace = tempDir.getUsableSpace();
            if (sdkRoot == null || sdkRootUsableSpace == tempDirUsableSpace) {
                message.listItem().add("Currently available disk space: " + new Storage(tempDirUsableSpace).toUiString());
            } else {
                message.listItem().add(String.format("Currently available disk space in SDK root (%1$s): %2$s", sdkRoot, new Storage(sdkRootUsableSpace).toUiString()));
                message.listItem().add(String.format("Currently available disk space in tmpdir (%1$s): %2$s", tempDir, new Storage(tempDirUsableSpace).toUiString()));
            }
            long totalSdkUsableSpace = sdkRootUsableSpace + spaceToBeFreedUp;
            issueDiskSpaceWarning = tempDirUsableSpace < tempDirUsageAfterDownload || sdkRoot != null && totalSdkUsableSpace < sdkRootUsageAfterInstallation;
        }
        message.endList();
        if (issueDiskSpaceWarning) {
            HtmlBuilder warningMessage = new HtmlBuilder();
            warningMessage.beginColor((Color)JBColor.RED).addBold("WARNING: There might be insufficient disk space to perform this operation. ").newline().newline().add("Estimated disk usage is presented below. ").add("Consider freeing up more disk space before proceeding. ").endColor().newline().newline();
            return Pair.of((Object)message, (Object)warningMessage);
        }
        return Pair.of((Object)message, null);
    }

    private static boolean confirmChange(HtmlBuilder message) {
        String[] options = new String[]{Messages.OK_BUTTON, Messages.CANCEL_BUTTON};
        Icon icon = AllIcons.General.Warning;
        return Messages.showIdeaMessageDialog(null, (String)message.getHtml(), (String)"Confirm Change", (String[])options, (int)0, (Icon)icon, null) == 0;
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        if (this.myPanel != null) {
            Disposer.dispose((Disposable)this.myPanel);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/updater/configure/SdkUpdaterConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPackages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePackage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/updater/configure/SdkUpdaterConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInstallationSize";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateDownloadSizeForPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

