/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.draw.DrawLassoUtil;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import java.awt.Graphics2D;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class MarqueeInteraction
extends Interaction {
    private MarqueeLayer myOverlay;
    private final SceneView mySceneView;

    public MarqueeInteraction(@NotNull SceneView surface) {
        if (surface == null) {
            MarqueeInteraction.$$$reportNull$$$0(0);
        }
        this.mySceneView = surface;
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        if (this.myOverlay == null) {
            return;
        }
        int xp = Math.min(x, this.myStartX);
        int yp = Math.min(y, this.myStartY);
        int w = Math.abs(x - this.myStartX);
        int h = Math.abs(y - this.myStartY);
        int ax = Coordinates.getAndroidXDip(this.mySceneView, xp);
        int ay = Coordinates.getAndroidYDip(this.mySceneView, yp);
        int aw = Coordinates.getAndroidDimensionDip(this.mySceneView, w);
        int ah = Coordinates.getAndroidDimensionDip(this.mySceneView, h);
        this.myOverlay.updateValues(xp, yp, w, h, x, y, aw, ah);
        List<SceneComponent> within = this.mySceneView.getScene().findWithin(ax, ay, aw, ah);
        List<NlComponent> result2 = within.stream().map(SceneComponent::getNlComponent).collect(Collectors.toList());
        this.mySceneView.getSelectionModel().setSelection(result2);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public List<Layer> createOverlays() {
        ColorSet colorSet = this.mySceneView.getColorSet();
        this.myOverlay = new MarqueeLayer(colorSet);
        return Collections.singletonList(this.myOverlay);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/uibuilder/surface/MarqueeInteraction", "<init>"));
    }

    private static class MarqueeLayer
    extends Layer {
        @NotNull
        ColorSet myColorSet;
        private int x;
        private int y;
        private int w;
        private int h;
        private int mouseX;
        private int mouseY;
        private int androidWidth;
        private int androidHeight;

        private MarqueeLayer(@NotNull ColorSet colorSet) {
            if (colorSet == null) {
                MarqueeLayer.$$$reportNull$$$0(0);
            }
            this.myColorSet = colorSet;
        }

        private void updateValues(int x, int y, int w, int h, int mouseX, int mouseY, int androidWidth, int androidHeight) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.androidWidth = androidWidth;
            this.androidHeight = androidHeight;
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                MarqueeLayer.$$$reportNull$$$0(1);
            }
            DrawLassoUtil.drawLasso(gc, this.myColorSet, this.x, this.y, this.w, this.h, this.mouseX, this.mouseY, this.androidWidth, this.androidHeight, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorSet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/MarqueeInteraction$MarqueeLayer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

