/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.SdkConstants;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragDropInteraction
extends Interaction {
    private final DesignSurface myDesignSurface;
    private final List<NlComponent> myDraggedComponents;
    private ViewGroupHandler myCurrentHandler;
    private DragHandler myDragHandler;
    private SceneComponent myDragReceiver;
    private DragType myType;
    private SceneView mySceneView;
    private DnDTransferItem myTransferItem;
    SceneComponent myCurrentViewgroup;
    private boolean myDoesAcceptDropAtLastPosition;
    private ViewGroupHandler myCachedHandler;
    private SceneComponent myCachedComponent;

    public DragDropInteraction(@NotNull DesignSurface designSurface, @NotNull List<NlComponent> dragged) {
        if (designSurface == null) {
            DragDropInteraction.$$$reportNull$$$0(0);
        }
        if (dragged == null) {
            DragDropInteraction.$$$reportNull$$$0(1);
        }
        this.myType = DragType.MOVE;
        this.myCurrentViewgroup = null;
        this.myDoesAcceptDropAtLastPosition = true;
        this.myDesignSurface = designSurface;
        this.myDraggedComponents = dragged;
    }

    public void setType(DragType type) {
        this.myType = type;
        if (this.myDragHandler != null) {
            this.myDragHandler.setDragType(type);
        }
    }

    public void setTransferItem(@NotNull DnDTransferItem item) {
        if (item == null) {
            DragDropInteraction.$$$reportNull$$$0(2);
        }
        this.myTransferItem = item;
    }

    @Nullable
    public DnDTransferItem getTransferItem() {
        return this.myTransferItem;
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.begin(x, y, modifiers);
        this.moveTo(x, y, modifiers, false);
        this.myDesignSurface.startDragDropInteraction();
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        super.update(x, y, modifiers);
        this.moveTo(x, y, modifiers, false);
    }

    public boolean acceptsDrop() {
        return this.myDoesAcceptDropAtLastPosition;
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        this.moveTo(x, y, modifiers, !canceled);
        this.mySceneView = this.myDesignSurface.getSceneView(x, y);
        if (this.mySceneView != null && this.myDragReceiver != null && !(canceled |= this.myDragHandler == null)) {
            this.mySceneView.getModel().notifyModified(NlModel.ChangeType.DND_END);
            this.mySceneView.getSelectionModel().clear();
            this.mySceneView.getSceneManager().update();
            this.myDragReceiver.updateTargets();
            this.mySceneView.getSelectionModel().setSelection(this.myDraggedComponents);
        }
        if (canceled && this.myDragHandler != null) {
            this.myDragHandler.cancel();
        }
        this.myDesignSurface.stopDragDropInteraction();
    }

    private void moveTo(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean commit) {
        String error;
        SceneComponent viewgroup;
        this.mySceneView = this.myDesignSurface.getSceneView(x, y);
        if (this.mySceneView == null) {
            return;
        }
        this.myDoesAcceptDropAtLastPosition = true;
        this.myDesignSurface.getLayeredPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
        int ax = Coordinates.getAndroidX(this.mySceneView, x);
        int ay = Coordinates.getAndroidY(this.mySceneView, y);
        Project project = this.mySceneView.getModel().getProject();
        ViewGroupHandler handler = this.findViewGroupHandlerAt(x, y);
        for (viewgroup = this.mySceneView.getScene().findComponent(SceneContext.get(this.mySceneView), Coordinates.getAndroidXDip(this.mySceneView, x), Coordinates.getAndroidYDip(this.mySceneView, y)); viewgroup != null && !NlComponentHelperKt.isOrHasSuperclass(viewgroup.getNlComponent(), "android.view.ViewGroup"); viewgroup = viewgroup.getParent()) {
        }
        if (handler != this.myCurrentHandler || this.myCurrentViewgroup != viewgroup) {
            if (this.myCurrentViewgroup != null) {
                this.myCurrentViewgroup.setDrawState(SceneComponent.DrawState.NORMAL);
            }
            this.myCurrentViewgroup = viewgroup;
            if (this.myCurrentViewgroup != null) {
                this.myCurrentViewgroup.setDrawState(SceneComponent.DrawState.DRAG);
            }
            if (this.myDragHandler != null) {
                this.myDragHandler.cancel();
                this.myDragHandler = null;
                this.mySceneView.getSurface().repaint();
            }
            this.myCurrentHandler = handler;
            if (this.myCurrentHandler != null) {
                assert (this.myDragReceiver != null);
                error = null;
                ViewHandlerManager viewHandlerManager = ViewHandlerManager.get(project);
                for (NlComponent component : this.myDraggedComponents) {
                    if (SdkConstants.CLASS_CONSTRAINT_LAYOUT_GUIDELINE.isEquals(component.getTagName()) && !(this.myCurrentHandler instanceof ConstraintLayoutHandler)) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getNlComponent().getTagName(), component.getTagName());
                        this.myDoesAcceptDropAtLastPosition = false;
                        break;
                    }
                    if (!this.myCurrentHandler.acceptsChild(this.myDragReceiver, component, ax, ay)) {
                        error = String.format("<%1$s> does not accept <%2$s> as a child", this.myDragReceiver.getNlComponent().getTagName(), component.getTagName());
                        this.myDoesAcceptDropAtLastPosition = false;
                        break;
                    }
                    ViewHandler viewHandler2 = viewHandlerManager.getHandler(component);
                    if (viewHandler2 == null || viewHandler2.acceptsParent(this.myDragReceiver.getNlComponent(), component)) continue;
                    error = String.format("<%1$s> does not accept <%2$s> as a parent", component.getTagName(), this.myDragReceiver.getNlComponent().getTagName());
                    this.myDoesAcceptDropAtLastPosition = false;
                    break;
                }
                if (error == null) {
                    this.myDragHandler = this.myCurrentHandler.createDragHandler(new ViewEditorImpl(this.mySceneView), this.myDragReceiver, this.myDraggedComponents, this.myType);
                    if (this.myDragHandler != null) {
                        this.myDragHandler.start(Coordinates.getAndroidXDip(this.mySceneView, this.myStartX), Coordinates.getAndroidYDip(this.mySceneView, this.myStartY), this.myStartMask);
                    }
                } else {
                    this.myCurrentHandler = null;
                }
            }
        }
        if (this.myDragHandler != null && this.myCurrentHandler != null) {
            error = this.myDragHandler.update(Coordinates.pxToDp(this.mySceneView, ax), Coordinates.pxToDp(this.mySceneView, ay), modifiers);
            ArrayList added = Lists.newArrayList();
            if (commit && error == null) {
                added.addAll(this.myDraggedComponents);
                NlModel model = this.mySceneView.getModel();
                InsertType insertType = model.determineInsertType(this.myType, this.myTransferItem, false);
                this.myDragHandler.commit(ax, ay, modifiers, insertType);
                model.notifyModified(NlModel.ChangeType.DND_COMMIT);
                this.myDesignSurface.getSelectionModel().setSelection(added);
                this.myDesignSurface.getLayeredPane().requestFocus();
            }
            this.mySceneView.getSurface().repaint();
        }
    }

    @Nullable
    private ViewGroupHandler findViewGroupHandlerAt(int x, int y) {
        SceneView sceneView = this.myDesignSurface.getSceneView(x, y);
        if (sceneView == null) {
            return null;
        }
        SceneComponent component = sceneView.getScene().findComponent(SceneContext.get(sceneView), Coordinates.getAndroidXDip(sceneView, x), Coordinates.getAndroidYDip(sceneView, y));
        if (component == null) {
            component = sceneView.getScene().getRoot();
        }
        if ((component = this.excludeDraggedComponents(component)) == this.myCachedComponent && this.myCachedHandler != null) {
            return this.myCachedHandler;
        }
        this.myCachedComponent = component;
        this.myCachedHandler = null;
        ViewHandlerManager handlerManager = ViewHandlerManager.get(sceneView.getModel().getFacet());
        while (component != null) {
            ViewHandler handler = handlerManager.getHandler(component.getNlComponent());
            if (handler instanceof ViewGroupHandler && this.acceptsDrop(component, (ViewGroupHandler)handler, x, y)) {
                this.myCachedHandler = (ViewGroupHandler)handlerManager.getHandler(component.getNlComponent());
                this.myDragReceiver = component;
                return this.myCachedHandler;
            }
            component = component.getParent();
        }
        return null;
    }

    @Nullable
    private SceneComponent excludeDraggedComponents(@Nullable SceneComponent component) {
        SceneComponent receiver = component;
        while (component != null) {
            if (this.myDraggedComponents.contains(component.getNlComponent())) {
                receiver = component.getParent();
            }
            component = component.getParent();
        }
        return receiver;
    }

    private boolean acceptsDrop(@NotNull SceneComponent parent, @NotNull ViewGroupHandler parentHandler, int x, int y) {
        if (parent == null) {
            DragDropInteraction.$$$reportNull$$$0(3);
        }
        if (parentHandler == null) {
            DragDropInteraction.$$$reportNull$$$0(4);
        }
        SceneView view = this.myDesignSurface.getSceneView(x, y);
        assert (view != null);
        ViewHandlerManager manager = ViewHandlerManager.get(view.getModel().getFacet());
        Predicate<NlComponent> acceptsChild = child -> parentHandler.acceptsChild(parent, (NlComponent)child, Coordinates.getAndroidX(view, x), Coordinates.getAndroidY(view, y));
        Predicate<NlComponent> acceptsParent = child -> {
            ViewHandler childHandler = manager.getHandler((NlComponent)child);
            return childHandler != null && childHandler.acceptsParent(parent.getNlComponent(), (NlComponent)child);
        };
        return this.myDraggedComponents.stream().allMatch(acceptsChild.and(acceptsParent));
    }

    @Override
    public List<Layer> createOverlays() {
        return Collections.singletonList(new DragLayer());
    }

    @NotNull
    public List<NlComponent> getDraggedComponents() {
        List<NlComponent> list = this.myDraggedComponents;
        if (list == null) {
            DragDropInteraction.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragged";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/DragDropInteraction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/DragDropInteraction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDraggedComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTransferItem";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDrop";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DragLayer
    extends Layer {
        DragLayer() {
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D gc) {
            if (gc == null) {
                DragLayer.$$$reportNull$$$0(0);
            }
            if (DragDropInteraction.this.myDragHandler != null) {
                DragDropInteraction.this.myDragHandler.paint(new NlGraphics(gc, DragDropInteraction.this.mySceneView));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gc", "com/android/tools/idea/uibuilder/surface/DragDropInteraction$DragLayer", "paint"));
        }
    }
}

