/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenHeightQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenRatioQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.ScreenWidthQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.uibuilder.graphics.NlConstants;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanvasResizeInteraction
extends Interaction {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final int MAX_ANDROID_SIZE = 1500;
    private static final String[] DEVICES_TO_SHOW = new String[]{"Nexus 5", "Nexus 6P", "Nexus 7", "Nexus 9", "Nexus 10"};
    @NotNull
    private final NlDesignSurface myDesignSurface;
    @NotNull
    private final ScreenView myScreenView;
    @NotNull
    private final Configuration myConfiguration;
    private final boolean isPreviewSurface;
    private final List<FolderConfiguration> myFolderConfigurations;
    private final UnavailableSizesLayer myUnavailableLayer;
    private final OrientationLayer myOrientationLayer;
    private final SizeBucketLayer mySizeBucketLayer;
    private final List<DeviceLayer> myDeviceLayers;
    private final Device myOriginalDevice;
    private final State myOriginalDeviceState;
    private final Map<Point, Device> myAndroidCoordinatesToDeviceMap;
    private final MergingUpdateQueue myUpdateQueue;
    private final int myMaxSize;
    private final Update myLayerUpdate;
    private final Update myPositionUpdate;
    private int myCurrentX;
    private int myCurrentY;

    public CanvasResizeInteraction(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView, @NotNull Configuration configuration) {
        List<Object> devicesToShow;
        if (designSurface == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(0);
        }
        if (screenView == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(2);
        }
        this.myUnavailableLayer = new UnavailableSizesLayer();
        this.myDeviceLayers = Lists.newArrayList();
        this.myAndroidCoordinatesToDeviceMap = Maps.newHashMapWithExpectedSize((int)DEVICES_TO_SHOW.length);
        this.myLayerUpdate = new Update("CanvasResizeLayerUpdate"){

            public void run() {
                CanvasResizeInteraction.this.mySizeBucketLayer.reset();
                CanvasResizeInteraction.this.myOrientationLayer.reset();
                CanvasResizeInteraction.this.updateUnavailableLayer(true);
            }
        };
        this.myPositionUpdate = new Update("CanvasResizePositionUpdate"){

            public void run() {
                int androidX = Coordinates.getAndroidX(CanvasResizeInteraction.this.myScreenView, CanvasResizeInteraction.this.myCurrentX);
                int androidY = Coordinates.getAndroidY(CanvasResizeInteraction.this.myScreenView, CanvasResizeInteraction.this.myCurrentY);
                if (androidX > 0 && androidY > 0 && androidX < CanvasResizeInteraction.this.myMaxSize && androidY < CanvasResizeInteraction.this.myMaxSize) {
                    NlModelHelperKt.overrideConfigurationScreenSize(CanvasResizeInteraction.this.myScreenView.getModel(), androidX, androidY);
                    if (CanvasResizeInteraction.this.isPreviewSurface) {
                        CanvasResizeInteraction.this.updateUnavailableLayer(false);
                    }
                }
            }
        };
        this.myDesignSurface = designSurface;
        this.myScreenView = screenView;
        this.myConfiguration = configuration;
        this.isPreviewSurface = designSurface.isPreviewSurface();
        this.myOrientationLayer = new OrientationLayer(this.myDesignSurface, this.myScreenView, this.myConfiguration);
        this.mySizeBucketLayer = new SizeBucketLayer();
        this.myUpdateQueue = new MergingUpdateQueue("layout.editor.canvas.resize", 25, true, null, (Disposable)this.myDesignSurface);
        this.myUpdateQueue.setRestartTimerOnAdd(true);
        this.myOriginalDevice = configuration.getDevice();
        this.myOriginalDeviceState = configuration.getDeviceState();
        VirtualFile file = configuration.getFile();
        assert (file != null);
        String layoutName = file.getNameWithoutExtension();
        LocalResourceRepository resourceRepository = ResourceRepositoryManager.getProjectResources(configuration.getModule());
        assert (resourceRepository != null);
        List layouts = resourceRepository.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, layoutName);
        this.myFolderConfigurations = layouts.stream().map(Configurable::getConfiguration).sorted(Collections.reverseOrder()).collect(Collectors.toList());
        double currentDpi = configuration.getDensity().getDpiValue();
        ConfigurationManager configManager = configuration.getConfigurationManager();
        boolean addSmallScreen = false;
        if (HardwareConfigHelper.isWear((Device)this.myOriginalDevice)) {
            devicesToShow = configManager.getDevices().stream().filter(d -> HardwareConfigHelper.isWear((Device)d) && !"Custom".equals(d.getId())).collect(Collectors.toList());
        } else if (HardwareConfigHelper.isTv((Device)this.myOriginalDevice)) {
            devicesToShow = Collections.singletonList(configManager.getDeviceById("tv_1080p"));
        } else {
            devicesToShow = Lists.newArrayListWithExpectedSize((int)DEVICES_TO_SHOW.length);
            for (String id : DEVICES_TO_SHOW) {
                devicesToShow.add(configManager.getDeviceById(id));
            }
            addSmallScreen = true;
        }
        for (Device device : devicesToShow) {
            assert (device != null);
            Screen screen = device.getDefaultHardware().getScreen();
            double dpiRatio = currentDpi / (double)screen.getPixelDensity().getDpiValue();
            Point p = new Point((int)((double)screen.getXDimension() * dpiRatio), (int)((double)screen.getYDimension() * dpiRatio));
            this.myAndroidCoordinatesToDeviceMap.put(p, device);
            this.myDeviceLayers.add(new DeviceLayer(this.myDesignSurface, this.myScreenView, this.myConfiguration, p.x, p.y, device.getDisplayName()));
        }
        if (addSmallScreen) {
            this.myDeviceLayers.add(new DeviceLayer(this.myDesignSurface, this.myScreenView, this.myConfiguration, (int)(426.0 * currentDpi / (double)Density.DEFAULT_DENSITY), (int)(320.0 * currentDpi / (double)Density.DEFAULT_DENSITY), "Small Screen"));
        }
        this.myMaxSize = (int)(1500.0 * currentDpi / (double)Density.DEFAULT_DENSITY);
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int startMask) {
        super.begin(x, y, startMask);
        this.myCurrentX = x;
        this.myCurrentY = y;
        this.myDesignSurface.setResizeMode(true);
        this.updateUnavailableLayer(false);
    }

    private void updateUnavailableLayer(boolean forceRecompute) {
        FolderConfiguration currentFolderConfig = FolderConfiguration.getConfigForFolder((String)this.myConfiguration.getFile().getParent().getNameWithoutExtension());
        assert (currentFolderConfig != null);
        if (!forceRecompute && currentFolderConfig.equals((Object)this.myUnavailableLayer.getCurrentFolderConfig())) {
            return;
        }
        ArrayList configAreas = Lists.newArrayList();
        Area totalCoveredArea = new Area();
        for (FolderConfiguration configuration : this.myFolderConfigurations) {
            Area configArea = this.coveredAreaForConfig(configuration, this.myScreenView);
            configArea.subtract(totalCoveredArea);
            if (!configuration.equals((Object)currentFolderConfig)) {
                configAreas.add(configArea);
            }
            totalCoveredArea.add(configArea);
        }
        this.myUnavailableLayer.update(configAreas, currentFolderConfig);
    }

    @NotNull
    private Area coveredAreaForConfig(@NotNull FolderConfiguration config, @NotNull SceneView screenView) {
        ScreenRatioQualifier ratioQualifier;
        ScreenSizeQualifier sizeQualifier;
        ScreenHeightQualifier heightQualifier;
        ScreenWidthQualifier widthQualifier;
        if (config == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(3);
        }
        if (screenView == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(4);
        }
        int x0 = screenView.getX();
        int y0 = screenView.getY();
        JComponent layeredPane = this.myDesignSurface.getLayeredPane();
        int width = layeredPane.getWidth();
        int height = layeredPane.getHeight();
        int maxDim = Math.max(width, height);
        int minX = 0;
        int maxX = -1;
        int minY = 0;
        int maxY = -1;
        SmallestScreenWidthQualifier smallestWidthQualifier = config.getSmallestScreenWidthQualifier();
        if (smallestWidthQualifier != null) {
            minX = Coordinates.dpToPx(screenView, smallestWidthQualifier.getValue());
            minY = Coordinates.dpToPx(screenView, smallestWidthQualifier.getValue());
        }
        if ((widthQualifier = config.getScreenWidthQualifier()) != null) {
            minX = Math.max(minX, Coordinates.dpToPx(screenView, widthQualifier.getValue()));
        }
        if ((heightQualifier = config.getScreenHeightQualifier()) != null) {
            minY = Math.max(minY, Coordinates.dpToPx(screenView, heightQualifier.getValue()));
        }
        if ((sizeQualifier = config.getScreenSizeQualifier()) != null && sizeQualifier.getValue() != null) {
            switch (sizeQualifier.getValue()) {
                case SMALL: {
                    maxX = Coordinates.dpToPx(screenView, 320);
                    maxY = Coordinates.dpToPx(screenView, 470);
                    break;
                }
                case NORMAL: {
                    break;
                }
                case LARGE: {
                    minX = Coordinates.dpToPx(screenView, 480);
                    minY = Coordinates.dpToPx(screenView, 640);
                    break;
                }
                case XLARGE: {
                    minX = Coordinates.dpToPx(screenView, 720);
                    minY = Coordinates.dpToPx(screenView, 960);
                }
            }
        }
        ScreenRatio ratio = (ratioQualifier = config.getScreenRatioQualifier()) != null ? ratioQualifier.getValue() : null;
        ScreenOrientationQualifier orientationQualifier = config.getScreenOrientationQualifier();
        ScreenOrientation orientation = orientationQualifier != null ? orientationQualifier.getValue() : null;
        Polygon portrait = new Polygon();
        Polygon landscape = new Polygon();
        if (orientation == null || orientation.equals((Object)ScreenOrientation.PORTRAIT)) {
            CanvasResizeInteraction.constructPolygon(portrait, ratio, maxDim, true);
            portrait.translate(x0, y0);
        }
        if (orientation == null || orientation.equals((Object)ScreenOrientation.LANDSCAPE)) {
            CanvasResizeInteraction.constructPolygon(landscape, ratio, maxDim, false);
            landscape.translate(x0, y0);
        }
        Area portraitArea = new Area(portrait);
        Area landscapeArea = new Area(landscape);
        Area portraitBounds = new Area(new Rectangle(Coordinates.getSwingX(screenView, minX), Coordinates.getSwingY(screenView, minY), maxX >= 0 ? Coordinates.getSwingDimension(screenView, maxX - minX) : width, maxY >= 0 ? Coordinates.getSwingDimension(screenView, maxY - minY) : height));
        Area landscapeBounds = new Area(new Rectangle(Coordinates.getSwingX(screenView, minY), Coordinates.getSwingY(screenView, minX), maxY >= 0 ? Coordinates.getSwingDimension(screenView, maxY - minY) : width, maxX >= 0 ? Coordinates.getSwingDimension(screenView, maxX - minX) : height));
        portraitArea.intersect(portraitBounds);
        landscapeArea.intersect(landscapeBounds);
        portraitArea.add(landscapeArea);
        Area area = portraitArea;
        if (area == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(5);
        }
        return area;
    }

    private static void constructPolygon(@NotNull Polygon polygon, @Nullable ScreenRatio ratio, int dim, boolean isPortrait) {
        if (polygon == null) {
            CanvasResizeInteraction.$$$reportNull$$$0(6);
        }
        polygon.reset();
        int x1 = isPortrait ? 0 : dim;
        int y1 = isPortrait ? dim : 0;
        int x2 = isPortrait ? dim : 5 * dim / 3;
        int y2 = isPortrait ? 5 * dim / 3 : dim;
        polygon.addPoint(0, 0);
        if (ratio == null) {
            polygon.addPoint(x1, y1);
            polygon.addPoint(dim, dim);
        } else if (ratio == ScreenRatio.LONG) {
            polygon.addPoint(x1, y1);
            polygon.addPoint(x2, y2);
        } else {
            polygon.addPoint(x2, y2);
            polygon.addPoint(dim, dim);
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiers) {
        if (this.myOriginalDevice.isScreenRound()) {
            int deltaX = x - this.myStartX;
            int deltaY = y - this.myStartY;
            if (deltaX > deltaY) {
                y = this.myStartY + deltaX;
            } else {
                x = this.myStartX + deltaY;
            }
        }
        super.update(x, y, modifiers);
        this.myCurrentX = x;
        this.myCurrentY = y;
        JComponent layeredPane = this.myDesignSurface.getLayeredPane();
        int maxX = Coordinates.getSwingX((SceneView)this.myScreenView, this.myMaxSize) + 50;
        int maxY = Coordinates.getSwingY((SceneView)this.myScreenView, this.myMaxSize) + 50;
        if (x < maxX && y < maxY && (x > layeredPane.getWidth() || y > layeredPane.getHeight())) {
            Dimension d = layeredPane.getPreferredSize();
            layeredPane.setPreferredSize(new Dimension(Math.max(d.width, x), Math.max(d.height, y)));
            layeredPane.revalidate();
            this.myUpdateQueue.queue(this.myLayerUpdate);
        }
        if (this.isPreviewSurface || this.myUnavailableLayer.isAvailable(x, y)) {
            this.myUpdateQueue.queue(this.myPositionUpdate);
        }
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiers, boolean canceled) {
        super.end(x, y, modifiers, canceled);
        this.myDesignSurface.setResizeMode(false);
        int androidX = Coordinates.getAndroidX(this.myScreenView, x);
        int androidY = Coordinates.getAndroidY(this.myScreenView, y);
        if (canceled || androidX < 0 || androidY < 0) {
            this.myConfiguration.setEffectiveDevice(this.myOriginalDevice, this.myOriginalDeviceState);
        } else {
            int snapThreshold = Coordinates.getAndroidDimension(this.myScreenView, 20);
            Device deviceToSnap = this.snapToDevice(androidX, androidY, snapThreshold);
            if (deviceToSnap != null) {
                State deviceState = deviceToSnap.getState(androidX < androidY ? "Portrait" : "Landscape");
                this.myConfiguration.setEffectiveDevice(deviceToSnap, deviceState);
            } else {
                NlModelHelperKt.overrideConfigurationScreenSize(this.myScreenView.getModel(), androidX, androidY);
            }
        }
    }

    @Nullable
    private Device snapToDevice(int x, int y, int threshold) {
        for (Point p : this.myAndroidCoordinatesToDeviceMap.keySet()) {
            if ((Math.abs(x - p.x) >= threshold || Math.abs(y - p.y) >= threshold) && (Math.abs(y - p.x) >= threshold || Math.abs(x - p.y) >= threshold)) continue;
            return this.myAndroidCoordinatesToDeviceMap.get(p);
        }
        return null;
    }

    @Override
    public synchronized List<Layer> createOverlays() {
        ImmutableList.Builder layers = ImmutableList.builder();
        if (HardwareConfigHelper.isMobile((Device)this.myOriginalDevice)) {
            layers.add((Object)this.mySizeBucketLayer);
        }
        layers.add((Object)this.myUnavailableLayer);
        layers.addAll(this.myDeviceLayers);
        layers.add((Object)this.myOrientationLayer);
        layers.add((Object)new ResizeLayer());
        return layers.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "polygon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "coveredAreaForConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "coveredAreaForConfig";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructPolygon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SizeBucketLayer
    extends Layer {
        private final Polygon myClip = new Polygon();
        private final FontMetrics myFontMetrics;
        private final Map<ScreenSize, SoftReference<BufferedImage>> myPortraitBuckets;
        private final Map<ScreenSize, SoftReference<BufferedImage>> myLandscapeBuckets;
        private int myTotalHeight;
        private int myTotalWidth;

        SizeBucketLayer() {
            JScrollPane scrollPane = CanvasResizeInteraction.this.myDesignSurface.getScrollPane();
            JComponent layeredPane = CanvasResizeInteraction.this.myDesignSurface.getLayeredPane();
            this.myTotalHeight = layeredPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
            this.myTotalWidth = layeredPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            this.myFontMetrics = CanvasResizeInteraction.this.myDesignSurface.getFontMetrics(CanvasResizeInteraction.this.myDesignSurface.getFont());
            int screenSizeNumbers = ScreenSize.values().length;
            this.myPortraitBuckets = Maps.newHashMapWithExpectedSize((int)screenSizeNumbers);
            this.myLandscapeBuckets = Maps.newHashMapWithExpectedSize((int)screenSizeNumbers);
        }

        @Override
        public synchronized void paint(@NotNull Graphics2D g2d) {
            BufferedImage bucket;
            int height;
            if (g2d == null) {
                SizeBucketLayer.$$$reportNull$$$0(0);
            }
            State deviceState = CanvasResizeInteraction.this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            int width = Coordinates.getAndroidX(CanvasResizeInteraction.this.myScreenView, CanvasResizeInteraction.this.myCurrentX);
            if (width > (height = Coordinates.getAndroidY(CanvasResizeInteraction.this.myScreenView, CanvasResizeInteraction.this.myCurrentY)) && isDevicePortrait || width < height && !isDevicePortrait) {
                return;
            }
            int small = Math.min(width, height);
            int big = Math.max(width, height);
            ScreenSize screenSizeBucket = this.getScreenSizeBucket(small, big);
            Map<ScreenSize, SoftReference<BufferedImage>> buckets = isDevicePortrait ? this.myPortraitBuckets : this.myLandscapeBuckets;
            SoftReference<BufferedImage> bucketRef = buckets.get(screenSizeBucket);
            BufferedImage bufferedImage = bucket = bucketRef != null ? (BufferedImage)bucketRef.get() : null;
            if (bucket == null) {
                bucket = UIUtil.createImage((int)this.myTotalWidth, (int)this.myTotalHeight, (int)2);
                CanvasResizeInteraction.constructPolygon(this.myClip, null, Math.max(this.myTotalHeight, this.myTotalWidth), isDevicePortrait);
                this.myClip.translate(CanvasResizeInteraction.this.myScreenView.getX(), CanvasResizeInteraction.this.myScreenView.getY());
                Graphics2D graphics = bucket.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.clip(this.myClip);
                graphics.setColor(NlConstants.RESIZING_BUCKET_COLOR);
                Area coveredArea = this.getAreaForScreenSize(screenSizeBucket, CanvasResizeInteraction.this.myScreenView, isDevicePortrait);
                graphics.fill(coveredArea);
                graphics.setColor(NlConstants.RESIZING_CORNER_COLOR);
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                graphics.draw(coveredArea);
                graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
                Rectangle bounds = coveredArea.getBounds();
                if (isDevicePortrait) {
                    int left = bounds.x + 5;
                    int bottom = Math.min(bounds.y + bounds.height, this.myTotalHeight) - 5;
                    graphics.drawString(screenSizeBucket.getShortDisplayValue() + " size range", left, bottom);
                } else {
                    String text = screenSizeBucket.getShortDisplayValue() + " size range";
                    Rectangle2D textBounds = this.myFontMetrics.getStringBounds(text, null);
                    int left = (int)((double)Math.min(bounds.x + bounds.width, this.myTotalWidth) - textBounds.getWidth() - 5.0);
                    int bottom = (int)((double)bounds.y + textBounds.getHeight());
                    graphics.drawString(text, left, bottom);
                }
                graphics.dispose();
                buckets.put(screenSizeBucket, (SoftReference<BufferedImage>)new SoftReference((Object)bucket));
            }
            UIUtil.drawImage((Graphics)g2d, (BufferedImage)bucket, null, (int)0, (int)0);
        }

        @NotNull
        private ScreenSize getScreenSizeBucket(int small, int big) {
            if (big < 470) {
                ScreenSize screenSize = ScreenSize.SMALL;
                if (screenSize == null) {
                    SizeBucketLayer.$$$reportNull$$$0(1);
                }
                return screenSize;
            }
            if (big >= 960 && small >= 720) {
                ScreenSize screenSize = ScreenSize.XLARGE;
                if (screenSize == null) {
                    SizeBucketLayer.$$$reportNull$$$0(2);
                }
                return screenSize;
            }
            if (big >= 640 && small >= 480) {
                ScreenSize screenSize = ScreenSize.LARGE;
                if (screenSize == null) {
                    SizeBucketLayer.$$$reportNull$$$0(3);
                }
                return screenSize;
            }
            ScreenSize screenSize = ScreenSize.NORMAL;
            if (screenSize == null) {
                SizeBucketLayer.$$$reportNull$$$0(4);
            }
            return screenSize;
        }

        @NotNull
        private Area getAreaForScreenSize(@NotNull ScreenSize screenSize, @NotNull SceneView screenView, boolean isDevicePortrait) {
            if (screenSize == null) {
                SizeBucketLayer.$$$reportNull$$$0(5);
            }
            if (screenView == null) {
                SizeBucketLayer.$$$reportNull$$$0(6);
            }
            int x0 = screenView.getX();
            int y0 = screenView.getY();
            int smallX = Coordinates.getSwingXDip(screenView, 470);
            int smallY = Coordinates.getSwingYDip(screenView, 470);
            Area smallArea = new Area(new Rectangle(x0 - 2, y0 - 2, smallX - x0 + 2, smallY - y0 + 2));
            if (screenSize == ScreenSize.SMALL) {
                Area area = smallArea;
                if (area == null) {
                    SizeBucketLayer.$$$reportNull$$$0(7);
                }
                return area;
            }
            int xlargeX = Coordinates.getSwingXDip(screenView, isDevicePortrait ? 720 : 960);
            int xlargeY = Coordinates.getSwingYDip(screenView, isDevicePortrait ? 960 : 720);
            Area xlargeArea = new Area(new Rectangle(xlargeX, xlargeY, this.myTotalWidth, this.myTotalHeight));
            if (screenSize == ScreenSize.XLARGE) {
                Area area = xlargeArea;
                if (area == null) {
                    SizeBucketLayer.$$$reportNull$$$0(8);
                }
                return area;
            }
            int largeX = Coordinates.getSwingXDip(screenView, isDevicePortrait ? 480 : 640);
            int largeY = Coordinates.getSwingYDip(screenView, isDevicePortrait ? 640 : 480);
            Area largeArea = new Area(new Rectangle(largeX, largeY, this.myTotalWidth, this.myTotalHeight));
            if (screenSize == ScreenSize.LARGE) {
                largeArea.subtract(xlargeArea);
                Area area = largeArea;
                if (area == null) {
                    SizeBucketLayer.$$$reportNull$$$0(9);
                }
                return area;
            }
            Area normalArea = new Area(new Rectangle(x0 - 2, y0 - 2, this.myTotalWidth, this.myTotalHeight));
            normalArea.subtract(smallArea);
            normalArea.subtract(largeArea);
            Area area = normalArea;
            if (area == null) {
                SizeBucketLayer.$$$reportNull$$$0(10);
            }
            return area;
        }

        public synchronized void reset() {
            JScrollPane scrollPane = CanvasResizeInteraction.this.myDesignSurface.getScrollPane();
            JComponent layeredPane = CanvasResizeInteraction.this.myDesignSurface.getLayeredPane();
            this.myTotalHeight = layeredPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
            this.myTotalWidth = layeredPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
            this.myPortraitBuckets.clear();
            this.myLandscapeBuckets.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenSize";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$SizeBucketLayer";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScreenSizeBucket";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAreaForScreenSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getAreaForScreenSize";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrientationLayer
    extends Layer {
        private final Polygon myOrientationPolygon;
        private final double myPortraitWidth;
        private final double myLandscapeWidth;
        @NotNull
        private final NlDesignSurface myDesignSurface;
        @NotNull
        private final ScreenView myScreenView;
        @NotNull
        private final Configuration myConfiguration;
        private BufferedImage myOrientationImage;
        private ScreenOrientation myLastOrientation;

        OrientationLayer(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView, @NotNull Configuration configuration) {
            if (designSurface == null) {
                OrientationLayer.$$$reportNull$$$0(0);
            }
            if (screenView == null) {
                OrientationLayer.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                OrientationLayer.$$$reportNull$$$0(2);
            }
            this.myOrientationPolygon = new Polygon();
            this.myDesignSurface = designSurface;
            this.myScreenView = screenView;
            this.myConfiguration = configuration;
            FontMetrics fontMetrics = this.myDesignSurface.getFontMetrics(this.myDesignSurface.getFont());
            this.myPortraitWidth = fontMetrics.getStringBounds("Portrait", null).getWidth();
            this.myLandscapeWidth = fontMetrics.getStringBounds("Landscape", null).getWidth();
        }

        @Override
        public synchronized void paint(@NotNull Graphics2D g2d) {
            BufferedImage image;
            if (g2d == null) {
                OrientationLayer.$$$reportNull$$$0(3);
            }
            State deviceState = this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            ScreenOrientation currentOrientation = deviceState.getOrientation();
            boolean isDevicePortrait = currentOrientation == ScreenOrientation.PORTRAIT;
            BufferedImage bufferedImage = image = currentOrientation == this.myLastOrientation ? this.myOrientationImage : null;
            if (image == null) {
                int yL;
                int xL;
                int yP;
                int xP;
                this.myLastOrientation = currentOrientation;
                JComponent layeredPane = this.myDesignSurface.getLayeredPane();
                JScrollPane scrollPane = this.myDesignSurface.getScrollPane();
                int height = layeredPane.getHeight() - scrollPane.getHorizontalScrollBar().getHeight();
                int width = layeredPane.getWidth() - scrollPane.getVerticalScrollBar().getWidth();
                int x0 = this.myScreenView.getX();
                int y0 = this.myScreenView.getY();
                int maxDim = Math.max(width, height);
                image = UIUtil.createImage((int)maxDim, (int)maxDim, (int)2);
                CanvasResizeInteraction.constructPolygon(this.myOrientationPolygon, null, maxDim, !isDevicePortrait);
                this.myOrientationPolygon.translate(x0, y0);
                Graphics2D graphics = image.createGraphics();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(NlConstants.UNAVAILABLE_ZONE_COLOR);
                graphics.fill(this.myOrientationPolygon);
                if ((double)(height - width) < this.myPortraitWidth / SQRT_2) {
                    xP = height - y0 + x0 - (int)(this.myPortraitWidth * SQRT_2) - 5;
                    yP = height;
                } else {
                    xP = width - (int)(this.myPortraitWidth / SQRT_2) - 5;
                    yP = width - x0 + y0 + (int)(this.myPortraitWidth / SQRT_2);
                }
                if ((double)(height - width) < (double)(y0 - x0) - this.myLandscapeWidth / SQRT_2) {
                    xL = height - y0 + x0 + 5;
                    yL = height;
                } else {
                    xL = width - (int)(this.myLandscapeWidth / SQRT_2);
                    yL = width - x0 + y0 - (int)(this.myLandscapeWidth / SQRT_2) - 5;
                }
                graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
                graphics.rotate(-0.7853981633974483, xL, yL);
                graphics.drawString("Landscape", xL, yL);
                graphics.rotate(0.7853981633974483, xL, yL);
                graphics.rotate(-0.7853981633974483, xP, yP);
                graphics.drawString("Portrait", xP, yP);
                graphics.dispose();
                this.myOrientationImage = image;
            }
            UIUtil.drawImage((Graphics)g2d, (BufferedImage)image, null, (int)0, (int)0);
        }

        public synchronized void reset() {
            this.myOrientationImage = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "designSurface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$OrientationLayer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DeviceLayer
    extends Layer {
        private final String myName;
        @NotNull
        private final NlDesignSurface myDesignSurface;
        @NotNull
        private final ScreenView myScreenView;
        @NotNull
        private final Configuration myConfiguration;
        private final int myNameWidth;
        private int myBigDimension;
        private int mySmallDimension;

        DeviceLayer(@NotNull NlDesignSurface designSurface, @NotNull ScreenView screenView, @NotNull Configuration configuration, int pxWidth, int pxHeight, @NotNull String name) {
            if (designSurface == null) {
                DeviceLayer.$$$reportNull$$$0(0);
            }
            if (screenView == null) {
                DeviceLayer.$$$reportNull$$$0(1);
            }
            if (configuration == null) {
                DeviceLayer.$$$reportNull$$$0(2);
            }
            if (name == null) {
                DeviceLayer.$$$reportNull$$$0(3);
            }
            this.myDesignSurface = designSurface;
            this.myScreenView = screenView;
            this.myConfiguration = configuration;
            this.myBigDimension = Math.max(pxWidth, pxHeight);
            this.mySmallDimension = Math.min(pxWidth, pxHeight);
            this.myName = name;
            FontMetrics fontMetrics = this.myDesignSurface.getFontMetrics(this.myDesignSurface.getFont());
            this.myNameWidth = (int)fontMetrics.getStringBounds(this.myName, null).getWidth();
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                DeviceLayer.$$$reportNull$$$0(4);
            }
            State deviceState = this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            int x = Coordinates.getSwingX((SceneView)this.myScreenView, isDevicePortrait ? this.mySmallDimension : this.myBigDimension);
            int y = Coordinates.getSwingY((SceneView)this.myScreenView, isDevicePortrait ? this.myBigDimension : this.mySmallDimension);
            Graphics2D graphics = (Graphics2D)g2d.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(NlConstants.RESIZING_CORNER_COLOR);
            graphics.drawLine(x, y, x - 32, y);
            graphics.drawLine(x, y, x, y - 32);
            graphics.setColor(NlConstants.RESIZING_TEXT_COLOR);
            graphics.drawString(this.myName, x - this.myNameWidth - 5, y - 5);
            graphics.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "designSurface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "screenView";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$DeviceLayer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class UnavailableSizesLayer
    extends Layer {
        private Polygon myClip = new Polygon();
        private List<Area> myConfigAreas;
        private FolderConfiguration myCurrentFolderConfig;

        private UnavailableSizesLayer() {
        }

        @Override
        public synchronized void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                UnavailableSizesLayer.$$$reportNull$$$0(0);
            }
            State deviceState = CanvasResizeInteraction.this.myConfiguration.getDeviceState();
            assert (deviceState != null);
            boolean isDevicePortrait = deviceState.getOrientation() == ScreenOrientation.PORTRAIT;
            JComponent layeredPane = CanvasResizeInteraction.this.myDesignSurface.getLayeredPane();
            CanvasResizeInteraction.constructPolygon(this.myClip, null, Math.max(layeredPane.getWidth(), layeredPane.getHeight()), isDevicePortrait);
            this.myClip.translate(CanvasResizeInteraction.this.myScreenView.getX() + 1, CanvasResizeInteraction.this.myScreenView.getY() + 1);
            Graphics2D graphics = (Graphics2D)g2d.create();
            graphics.clip(this.myClip);
            int n = 0;
            for (Area configArea : this.myConfigAreas) {
                graphics.setColor(NlConstants.RESIZING_OTHER_CONFIG_COLOR_ARRAY[n++ % NlConstants.RESIZING_OTHER_CONFIG_COLOR_ARRAY.length]);
                graphics.fill(configArea);
            }
            graphics.dispose();
        }

        private boolean isAvailable(int x, int y) {
            for (Area configArea : this.myConfigAreas) {
                if (!configArea.contains(x, y)) continue;
                return false;
            }
            return true;
        }

        private synchronized void update(@NotNull List<Area> configAreas, @NotNull FolderConfiguration currentFolderConfig) {
            if (configAreas == null) {
                UnavailableSizesLayer.$$$reportNull$$$0(1);
            }
            if (currentFolderConfig == null) {
                UnavailableSizesLayer.$$$reportNull$$$0(2);
            }
            this.myConfigAreas = configAreas;
            this.myCurrentFolderConfig = currentFolderConfig;
        }

        @Nullable
        private FolderConfiguration getCurrentFolderConfig() {
            return this.myCurrentFolderConfig;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g2d";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configAreas";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentFolderConfig";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$UnavailableSizesLayer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paint";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ResizeLayer
    extends Layer {
        private ResizeLayer() {
        }

        @Override
        public void create() {
        }

        @Override
        public void dispose() {
        }

        @Override
        public void paint(@NotNull Graphics2D g2d) {
            if (g2d == null) {
                ResizeLayer.$$$reportNull$$$0(0);
            }
            int x = CanvasResizeInteraction.this.myScreenView.getX();
            int y = CanvasResizeInteraction.this.myScreenView.getY();
            if (CanvasResizeInteraction.this.myCurrentX > x && CanvasResizeInteraction.this.myCurrentY > y) {
                Graphics2D graphics = (Graphics2D)g2d.create();
                graphics.setColor(NlConstants.RESIZING_CONTOUR_COLOR);
                graphics.setStroke(NlConstants.THICK_SOLID_STROKE);
                graphics.drawRect(x - 1, y - 1, CanvasResizeInteraction.this.myCurrentX - x, CanvasResizeInteraction.this.myCurrentY - y);
                graphics.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2d", "com/android/tools/idea/uibuilder/surface/CanvasResizeInteraction$ResizeLayer", "paint"));
        }
    }
}

