/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.renderer;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.adtui.ptable.PTableItem;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.GutterIconCache;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.uibuilder.property.renderer.NlAttributeRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.AndroidAnnotatorUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDefaultRenderer
extends NlAttributeRenderer {
    public static final int ICON_SIZE = 14;

    protected void customizeCellRenderer(@NotNull PTable table2, @NotNull PTableItem value2, boolean selected, boolean hasFocus, int row, int col) {
        if (table2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(1);
        }
        if (value2 instanceof NlProperty) {
            this.customize((NlProperty)value2, col, selected);
        }
    }

    void customize(NlProperty property2, int column, boolean selected) {
        if (column == 0) {
            this.appendName(property2);
        } else {
            this.appendValue(property2, selected);
        }
    }

    private void appendValue(@NotNull NlProperty property2, boolean selected) {
        if (property2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(2);
        }
        String value2 = property2.getValue();
        String text = StringUtil.notNullize((String)value2);
        Icon icon = NlDefaultRenderer.getIcon(property2, 14);
        if (icon != null) {
            this.setIcon(icon);
        }
        if (!selected && !property2.isDefaultValue(value2)) {
            this.setForeground((Color)JBColor.BLUE);
        }
        this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.setToolTipText(text);
    }

    @Nullable
    public static Icon getIcon(@NotNull NlProperty property2, int iconSize) {
        String text;
        if (property2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(3);
        }
        if ((text = property2.getResolvedValue()) == null) {
            return null;
        }
        if (NlDefaultRenderer.isColorValue(text)) {
            return NlDefaultRenderer.getColorIcon(text, iconSize);
        }
        Configuration configuration = property2.getModel().getConfiguration();
        if (configuration == null) {
            return null;
        }
        ResourceResolver resolver = configuration.getResourceResolver();
        if (resolver == null) {
            return null;
        }
        if (text.startsWith("@color/") || text.startsWith("@android:color/")) {
            return NlDefaultRenderer.getColorIcon(resolver, property2, text, iconSize);
        }
        if (text.startsWith("@drawable/") || text.startsWith("@android:drawable/") || text.startsWith("@mipmap/")) {
            return NlDefaultRenderer.getDrawableIcon(resolver, property2, text);
        }
        return null;
    }

    @Nullable
    private static Icon getDrawableIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property2, @NotNull String value2) {
        if (resolver == null) {
            NlDefaultRenderer.$$$reportNull$$$0(4);
        }
        if (property2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(5);
        }
        if (value2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(6);
        }
        ResourceType type = value2.startsWith("@mipmap/") ? ResourceType.MIPMAP : ResourceType.DRAWABLE;
        ResourceValue drawable = resolver.resolveResValue((ResourceValue)new ResourceValueImpl(new ResourceReference(ResourceNamespace.TODO(), type, property2.getName()), value2));
        if (drawable == null) {
            return null;
        }
        VirtualFile bitmap = ResourceHelper.resolveDrawable((RenderResources)resolver, drawable, property2.getModel().getProject());
        return (bitmap = AndroidAnnotatorUtil.pickBestBitmap(bitmap)) == null ? null : GutterIconCache.getInstance().getIcon(bitmap.getPath(), (RenderResources)resolver);
    }

    @Nullable
    private static Icon getColorIcon(@NotNull ResourceResolver resolver, @NotNull NlProperty property2, @NotNull String value2, int iconSize) {
        ResourceValue resourceValue2;
        if (resolver == null) {
            NlDefaultRenderer.$$$reportNull$$$0(7);
        }
        if (property2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(9);
        }
        if ((resourceValue2 = resolver.resolveResValue((ResourceValue)new ResourceValueImpl(new ResourceReference(ResourceNamespace.TODO(), ResourceType.COLOR, property2.getName()), value2))) == null) {
            return null;
        }
        String resolvedValue = resourceValue2.getValue();
        if (NlDefaultRenderer.isColorValue(resolvedValue)) {
            return NlDefaultRenderer.getColorIcon(resolvedValue, iconSize);
        }
        return null;
    }

    private static boolean isColorValue(@Nullable String value2) {
        return value2 != null && value2.startsWith("#") && value2.matches("#\\p{XDigit}+");
    }

    @Nullable
    private static Icon getColorIcon(@NotNull String hexColor, int iconSize) {
        Color color;
        if (hexColor == null) {
            NlDefaultRenderer.$$$reportNull$$$0(10);
        }
        return (color = ResourceHelper.parseColor(hexColor)) == null ? null : JBUI.scale((JBUI.JBIcon)new ColorIcon(iconSize, color, true));
    }

    private void appendName(@NotNull NlProperty property2) {
        if (property2 == null) {
            NlDefaultRenderer.$$$reportNull$$$0(11);
        }
        this.append(property2.getName());
        this.setToolTipText(property2.getTooltipText());
    }

    @Override
    public boolean canRender(@NotNull NlProperty p, @NotNull Set<AttributeFormat> formats) {
        if (p == null) {
            NlDefaultRenderer.$$$reportNull$$$0(12);
        }
        if (formats == null) {
            NlDefaultRenderer.$$$reportNull$$$0(13);
        }
        return true;
    }

    SimpleColoredComponent getLabel() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hexColor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/renderer/NlDefaultRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDrawableIcon";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getColorIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "canRender";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

