/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors.support;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.property.NlProperty;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.property.editors.support.AttributeDefinitionEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.EnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.FontEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.IdEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.OnClickEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.SimpleEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.SimpleQuantityEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.SimpleValuePairEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleEnumSupport;
import com.android.tools.idea.uibuilder.property.editors.support.StyleFilter;
import com.android.tools.idea.uibuilder.property.editors.support.TextAppearanceEnumSupport;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSupportFactory {
    static final String TEXT_APPEARANCE_SUFFIX = "TextAppearance";
    static final List<String> AVAILABLE_TEXT_SIZES = ImmutableList.of((Object)"8sp", (Object)"10sp", (Object)"12sp", (Object)"14sp", (Object)"18sp", (Object)"24sp", (Object)"30sp", (Object)"36sp");
    static final List<String> AVAILABLE_LINE_SPACINGS = AVAILABLE_TEXT_SIZES;
    static final List<String> AVAILABLE_TYPEFACES = ImmutableList.of((Object)"normal", (Object)"sans", (Object)"serif", (Object)"monospace");
    static final List<String> AVAILABLE_SIZES = ImmutableList.of((Object)"match_parent", (Object)"wrap_content");

    public static boolean supportsProperty(@NotNull NlProperty property2) {
        if (property2 == null) {
            EnumSupportFactory.$$$reportNull$$$0(0);
        }
        if (EnumSupportFactory.getEnumValueOverride(property2) != null) {
            return true;
        }
        switch (property2.getName()) {
            case "fontFamily": 
            case "typeface": 
            case "textSize": 
            case "lineSpacingExtra": 
            case "textAppearance": 
            case "layout_height": 
            case "layout_width": 
            case "dropDownHeight": 
            case "dropDownWidth": 
            case "onClick": {
                return true;
            }
            case "id": {
                return false;
            }
            case "style": {
                String tagName = property2.getTagName();
                ResourceResolver resolver = property2.getResolver();
                if (tagName == null || resolver == null) {
                    return false;
                }
                StyleFilter filter2 = new StyleFilter(property2.getModel().getFacet(), resolver);
                return filter2.hasWidgetStyles(tagName);
            }
        }
        if (property2.getName().endsWith(TEXT_APPEARANCE_SUFFIX)) {
            return true;
        }
        if (AndroidDomUtil.getSpecialResourceTypes(property2.getName()).contains(ResourceType.ID)) {
            return true;
        }
        AttributeDefinition definition = property2.getDefinition();
        Set<Object> formats = definition != null ? definition.getFormats() : Collections.emptySet();
        return formats.contains(AttributeFormat.ENUM);
    }

    public static EnumSupport create(@NotNull NlProperty property2) {
        Map<String, String> values2;
        if (property2 == null) {
            EnumSupportFactory.$$$reportNull$$$0(1);
        }
        if ((values2 = EnumSupportFactory.getEnumValueOverride(property2)) != null) {
            return new SimpleValuePairEnumSupport(property2, values2);
        }
        switch (property2.getName()) {
            case "fontFamily": {
                return new FontEnumSupport(property2);
            }
            case "typeface": {
                return new SimpleEnumSupport(property2, AVAILABLE_TYPEFACES);
            }
            case "textSize": {
                return new SimpleQuantityEnumSupport(property2, AVAILABLE_TEXT_SIZES);
            }
            case "lineSpacingExtra": {
                return new SimpleQuantityEnumSupport(property2, AVAILABLE_LINE_SPACINGS);
            }
            case "textAppearance": {
                return new TextAppearanceEnumSupport(property2);
            }
            case "layout_height": 
            case "layout_width": 
            case "dropDownHeight": 
            case "dropDownWidth": {
                return new SimpleQuantityEnumSupport(property2, AVAILABLE_SIZES);
            }
            case "onClick": {
                return new OnClickEnumSupport(property2);
            }
            case "style": {
                return new StyleEnumSupport(property2);
            }
        }
        if (property2.getName().endsWith(TEXT_APPEARANCE_SUFFIX)) {
            return new TextAppearanceEnumSupport(property2);
        }
        if (AndroidDomUtil.getSpecialResourceTypes(property2.getName()).contains(ResourceType.ID)) {
            return new IdEnumSupport(property2);
        }
        return new AttributeDefinitionEnumSupport(property2);
    }

    @Nullable
    private static Map<String, String> getEnumValueOverride(@NotNull NlProperty property2) {
        Collection<NlComponent> components;
        if (property2 == null) {
            EnumSupportFactory.$$$reportNull$$$0(2);
        }
        if ((components = property2.getComponents()).isEmpty()) {
            return null;
        }
        if (property2.getName().startsWith("layout_")) {
            IdentityHashMap parents = new IdentityHashMap();
            components.stream().map(NlComponent::getParent).filter(Objects::nonNull).forEach(parent -> parents.put(parent, parent));
            components = parents.keySet();
        }
        Map<String, String> values2 = null;
        for (NlComponent component : components) {
            ViewHandler handler = NlComponentHelperKt.getViewHandler(component);
            if (handler == null) {
                return null;
            }
            Map<String, String> overrides = handler.getEnumPropertyValues(component).get(property2.getName());
            if (overrides == null) {
                return null;
            }
            if (values2 == null) {
                values2 = overrides;
                continue;
            }
            if (overrides.equals(values2)) continue;
            return null;
        }
        return values2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "property";
        objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/support/EnumSupportFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumValueOverride";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

